/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.common.guava;

import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.io.druid.common.guava.GuavaUtils;
import org.junit.Assert;
import org.junit.Test;

public class GuavaUtilsTest {
    @Test
    public void testParseLong() {
        Assert.assertNull((Object)Longs.tryParse((String)"+100"));
        Assert.assertNull((Object)GuavaUtils.tryParseLong((String)""));
        Assert.assertNull((Object)GuavaUtils.tryParseLong(null));
        Assert.assertNull((Object)GuavaUtils.tryParseLong((String)"+"));
        Assert.assertNull((Object)GuavaUtils.tryParseLong((String)"++100"));
        Assert.assertEquals((Object)Long.parseLong("+100"), (Object)GuavaUtils.tryParseLong((String)"+100"));
        Assert.assertEquals((Object)Long.parseLong("-100"), (Object)GuavaUtils.tryParseLong((String)"-100"));
        Assert.assertNotEquals((Object)new Long(100L), (Object)GuavaUtils.tryParseLong((String)"+101"));
    }

    @Test
    public void testGetEnumIfPresent() {
        Assert.assertEquals((Object)((Object)MyEnum.ONE), (Object)GuavaUtils.getEnumIfPresent(MyEnum.class, (String)"ONE"));
        Assert.assertEquals((Object)((Object)MyEnum.TWO), (Object)GuavaUtils.getEnumIfPresent(MyEnum.class, (String)"TWO"));
        Assert.assertEquals((Object)((Object)MyEnum.BUCKLE_MY_SHOE), (Object)GuavaUtils.getEnumIfPresent(MyEnum.class, (String)"BUCKLE_MY_SHOE"));
        Assert.assertEquals(null, (Object)GuavaUtils.getEnumIfPresent(MyEnum.class, (String)"buckle_my_shoe"));
    }

    static enum MyEnum {
        ONE,
        TWO,
        BUCKLE_MY_SHOE;

    }
}

