/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client.cache;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.client.cache.ByteCountingLRUMap;
import org.apache.hive.druid.io.druid.client.cache.Cache;
import org.apache.hive.druid.io.druid.client.cache.CacheProvider;
import org.apache.hive.druid.io.druid.client.cache.HybridCache;
import org.apache.hive.druid.io.druid.client.cache.HybridCacheConfig;
import org.apache.hive.druid.io.druid.client.cache.HybridCacheProvider;
import org.apache.hive.druid.io.druid.client.cache.LocalCacheProvider;
import org.apache.hive.druid.io.druid.client.cache.MapCache;
import org.apache.hive.druid.io.druid.client.cache.MemcachedCacheProvider;
import org.apache.hive.druid.io.druid.guice.CacheModule;
import org.apache.hive.druid.io.druid.guice.GuiceInjectors;
import org.apache.hive.druid.io.druid.guice.annotations.Global;
import org.apache.hive.druid.io.druid.initialization.Initialization;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class HybridCacheTest {
    private static final byte[] HI = StringUtils.toUtf8((String)"hi");

    @Test
    public void testInjection() throws Exception {
        String prefix = "testInjectHybridCache";
        System.setProperty("testInjectHybridCache.type", "hybrid");
        System.setProperty("testInjectHybridCache.l1.type", "local");
        System.setProperty("testInjectHybridCache.l2.type", "memcached");
        System.setProperty("testInjectHybridCache.useL2", "false");
        System.setProperty("testInjectHybridCache.l2.hosts", "localhost:11711");
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("hybridTest");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
                binder.install((Module)new CacheModule("testInjectHybridCache"));
            }
        }));
        CacheProvider cacheProvider = (CacheProvider)injector.getInstance(Key.get(CacheProvider.class, Global.class));
        Assert.assertNotNull((Object)cacheProvider);
        Assert.assertEquals(HybridCacheProvider.class, cacheProvider.getClass());
        Cache cache = (Cache)cacheProvider.get();
        Assert.assertNotNull((Object)cache);
        Assert.assertFalse((boolean)cache.isLocal());
        Assert.assertFalse((boolean)((HybridCacheProvider)cacheProvider).getUseL2());
        Assert.assertTrue((boolean)((HybridCacheProvider)cacheProvider).getPopulateL2());
        Assert.assertEquals(LocalCacheProvider.class, ((HybridCacheProvider)cacheProvider).level1.getClass());
        Assert.assertEquals(MemcachedCacheProvider.class, ((HybridCacheProvider)cacheProvider).level2.getClass());
    }

    @Test
    public void testSanity() throws Exception {
        MapCache l1 = new MapCache(new ByteCountingLRUMap(0x100000L));
        MapCache l2 = new MapCache(new ByteCountingLRUMap(0x100000L));
        HybridCache cache = new HybridCache(new HybridCacheConfig(), (Cache)l1, (Cache)l2);
        Cache.NamedKey key1 = new Cache.NamedKey("a", HI);
        Cache.NamedKey key2 = new Cache.NamedKey("b", HI);
        Cache.NamedKey key3 = new Cache.NamedKey("c", HI);
        Cache.NamedKey key4 = new Cache.NamedKey("d", HI);
        byte[] value1 = Ints.toByteArray((int)1);
        byte[] value2 = Ints.toByteArray((int)2);
        byte[] value3 = Ints.toByteArray((int)3);
        cache.put(key1, value1);
        Assert.assertEquals((Object)value1, (Object)l1.get(key1));
        Assert.assertEquals((Object)value1, (Object)l2.get(key1));
        Assert.assertEquals((Object)value1, (Object)cache.get(key1));
        int hits = 0;
        Assert.assertEquals((long)0L, (long)cache.getStats().getNumMisses());
        Assert.assertEquals((long)(++hits), (long)cache.getStats().getNumHits());
        l1.put(key2, value2);
        Assert.assertEquals((Object)value2, (Object)cache.get(key2));
        Assert.assertEquals((long)0L, (long)cache.getStats().getNumMisses());
        Assert.assertEquals((long)(++hits), (long)cache.getStats().getNumHits());
        l2.put(key3, value3);
        Assert.assertEquals((Object)value3, (Object)cache.get(key3));
        Assert.assertEquals((long)0L, (long)cache.getStats().getNumMisses());
        Assert.assertEquals((long)(++hits), (long)cache.getStats().getNumHits());
        HashSet keys = Sets.newHashSet((Object[])new Cache.NamedKey[]{key1, key2, key3});
        Map res = cache.getBulk((Iterable)keys);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)keys, res.keySet());
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])res.get(key1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])res.get(key2)));
        Assert.assertArrayEquals((byte[])value3, (byte[])((byte[])res.get(key3)));
        Assert.assertEquals((long)0L, (long)cache.getStats().getNumMisses());
        Assert.assertEquals((long)(hits += 3), (long)cache.getStats().getNumHits());
        keys = Sets.newHashSet((Object[])new Cache.NamedKey[]{key1, key2});
        res = cache.getBulk((Iterable)keys);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)keys, res.keySet());
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])res.get(key1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])res.get(key2)));
        Assert.assertEquals((long)0L, (long)cache.getStats().getNumMisses());
        Assert.assertEquals((long)(hits += 2), (long)cache.getStats().getNumHits());
        int misses = 0;
        Assert.assertNull((Object)cache.get(key4));
        Assert.assertEquals((long)(++misses), (long)cache.getStats().getNumMisses());
        Assert.assertTrue((boolean)cache.getBulk((Iterable)Sets.newHashSet((Object[])new Cache.NamedKey[]{key4})).isEmpty());
        Assert.assertEquals((long)(++misses), (long)cache.getStats().getNumMisses());
        res = cache.getBulk((Iterable)Sets.newHashSet((Object[])new Cache.NamedKey[]{key1, key4}));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new Cache.NamedKey[]{key1}), res.keySet());
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])res.get(key1)));
        Assert.assertEquals((long)(++hits), (long)cache.getStats().getNumHits());
        Assert.assertEquals((long)(++misses), (long)cache.getStats().getNumMisses());
        res = cache.getBulk((Iterable)Sets.newHashSet((Object[])new Cache.NamedKey[]{key3, key4}));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new Cache.NamedKey[]{key3}), res.keySet());
        Assert.assertArrayEquals((byte[])value3, (byte[])((byte[])res.get(key3)));
        Assert.assertEquals((long)(++hits), (long)cache.getStats().getNumHits());
        Assert.assertEquals((long)(++misses), (long)cache.getStats().getNumMisses());
    }
}

