/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client.cache;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.client.cache.ByteCountingLRUMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ByteCountingLRUMapTest {
    private ByteCountingLRUMap map;

    @Before
    public void setUp() throws Exception {
        this.map = new ByteCountingLRUMap(100L);
    }

    @Test
    public void testSanity() throws Exception {
        ByteBuffer tenKey = ByteBuffer.allocate(10);
        byte[] eightyEightVal = ByteBuffer.allocate(88).array();
        byte[] eightNineNineVal = ByteBuffer.allocate(89).array();
        ByteBuffer oneByte = ByteBuffer.allocate(1);
        ByteBuffer twoByte = ByteBuffer.allocate(2);
        this.assertMapValues(0, 0, 0);
        this.map.put(tenKey, eightNineNineVal);
        this.assertMapValues(1, 99, 0);
        Assert.assertEquals((Object)ByteBuffer.wrap(eightNineNineVal), (Object)ByteBuffer.wrap((byte[])this.map.get((Object)tenKey)));
        this.map.put(oneByte, oneByte.array());
        this.assertMapValues(1, 2, 1);
        Assert.assertNull((Object)this.map.get((Object)tenKey));
        Assert.assertEquals((Object)oneByte, (Object)ByteBuffer.wrap((byte[])this.map.get((Object)oneByte)));
        this.map.put(tenKey, eightyEightVal);
        this.assertMapValues(2, 100, 1);
        Assert.assertEquals((Object)oneByte, (Object)ByteBuffer.wrap((byte[])this.map.get((Object)oneByte)));
        Assert.assertEquals((Object)ByteBuffer.wrap(eightyEightVal), (Object)ByteBuffer.wrap((byte[])this.map.get((Object)tenKey)));
        this.map.put(twoByte, oneByte.array());
        this.assertMapValues(1, 3, 3);
        Assert.assertEquals(null, (Object)this.map.get((Object)tenKey));
        Assert.assertEquals((Object)oneByte, (Object)ByteBuffer.wrap((byte[])this.map.get((Object)twoByte)));
        Iterator it = this.map.keySet().iterator();
        LinkedList toRemove = Lists.newLinkedList();
        while (it.hasNext()) {
            ByteBuffer buf = (ByteBuffer)it.next();
            if (buf.remaining() != 10) continue;
            toRemove.add(buf);
        }
        for (ByteBuffer buf : toRemove) {
            this.map.remove((Object)buf);
        }
        this.assertMapValues(1, 3, 3);
        this.map.remove((Object)twoByte);
        this.assertMapValues(0, 0, 3);
    }

    @Test
    public void testSameKeyUpdate() throws Exception {
        ByteBuffer k = ByteBuffer.allocate(1);
        this.assertMapValues(0, 0, 0);
        this.map.put(k, new byte[1]);
        this.map.put(k, new byte[2]);
        this.map.put(k, new byte[5]);
        this.map.put(k, new byte[3]);
        this.assertMapValues(1, 4, 0);
    }

    private void assertMapValues(int size, int numBytes, int evictionCount) {
        Assert.assertEquals((long)size, (long)this.map.size());
        Assert.assertEquals((long)numBytes, (long)this.map.getNumBytes());
        Assert.assertEquals((long)evictionCount, (long)this.map.getEvictionCount());
    }
}

