/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.http.client;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.junit.Assert;
import org.junit.Test;

public class AsyncHttpClientTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestTimeout() throws Exception {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        final ServerSocket serverSocket = new ServerSocket(0);
        exec.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Socket clientSocket = serverSocket.accept();
                        Throwable throwable = null;
                        try {
                            BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                            Throwable throwable2 = null;
                            try {
                                OutputStream out = clientSocket.getOutputStream();
                                Throwable throwable3 = null;
                                try {
                                    while (!in.readLine().equals("")) {
                                    }
                                    Thread.sleep(5000L);
                                    out.write("HTTP/1.1 200 OK\r\nContent-Length: 6\r\n\r\nhello!".getBytes(Charsets.UTF_8));
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (out == null) continue;
                                    if (throwable3 != null) {
                                        try {
                                            out.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable3.addSuppressed(throwable5);
                                        }
                                        continue;
                                    }
                                    out.close();
                                }
                            }
                            catch (Throwable throwable6) {
                                throwable2 = throwable6;
                                throw throwable6;
                            }
                            finally {
                                if (in == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                    continue;
                                }
                                in.close();
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable = throwable8;
                            throw throwable8;
                        }
                        finally {
                            if (clientSocket == null) continue;
                            if (throwable != null) {
                                try {
                                    clientSocket.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                }
                                continue;
                            }
                            clientSocket.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
        long requestStart = 0L;
        DefaultAsyncHttpClient client = new DefaultAsyncHttpClient();
        this.warmUp(serverSocket, client);
        try {
            requestStart = System.currentTimeMillis();
            ListenableFuture future = ((BoundRequestBuilder)client.prepareGet(String.format("http://localhost:%d/", serverSocket.getLocalPort())).setRequestTimeout(2000)).execute();
            System.out.println("created future in: " + (System.currentTimeMillis() - requestStart));
            future.get(3000L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Expected timeout");
        }
        catch (ExecutionException | TimeoutException e) {
            long elapsed = System.currentTimeMillis() - requestStart;
            Assert.assertTrue((String)("elapsed: " + elapsed), (elapsed < 2200L ? 1 : 0) != 0);
        }
        finally {
            exec.shutdownNow();
            serverSocket.close();
        }
    }

    private void warmUp(ServerSocket serverSocket, DefaultAsyncHttpClient client) {
        try {
            ListenableFuture future = ((BoundRequestBuilder)client.prepareGet(String.format("http://localhost:%d/", serverSocket.getLocalPort())).setRequestTimeout(100)).execute();
            future.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

