/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.testbed.Ambig;
import org.apache.commons.lang3.reflect.testbed.Annotated;
import org.apache.commons.lang3.reflect.testbed.Foo;
import org.apache.commons.lang3.reflect.testbed.PrivatelyShadowedChild;
import org.apache.commons.lang3.reflect.testbed.PublicChild;
import org.apache.commons.lang3.reflect.testbed.PubliclyShadowedChild;
import org.apache.commons.lang3.reflect.testbed.StaticContainer;
import org.apache.commons.lang3.reflect.testbed.StaticContainerChild;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FieldUtilsTest {
    private static final String JACOCO_DATA_FIELD_NAME = "$jacocoData";
    static final Integer I0 = 0;
    static final Integer I1 = 1;
    static final Double D0 = 0.0;
    static final Double D1 = 1.0;
    @Annotated
    private PublicChild publicChild;
    private PubliclyShadowedChild publiclyShadowedChild;
    @Annotated
    private PrivatelyShadowedChild privatelyShadowedChild;
    private final Class<? super PublicChild> parentClass = PublicChild.class.getSuperclass();

    @BeforeEach
    public void setUp() {
        StaticContainer.reset();
        this.publicChild = new PublicChild();
        this.publiclyShadowedChild = new PubliclyShadowedChild();
        this.privatelyShadowedChild = new PrivatelyShadowedChild();
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new FieldUtils());
        Constructor<?>[] cons = FieldUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(FieldUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(FieldUtils.class.getModifiers()));
    }

    @Test
    public void testGetField() {
        Assertions.assertEquals(Foo.class, FieldUtils.getField(PublicChild.class, (String)"VALUE").getDeclaringClass());
        Assertions.assertEquals(this.parentClass, FieldUtils.getField(PublicChild.class, (String)"s").getDeclaringClass());
        Assertions.assertNull((Object)FieldUtils.getField(PublicChild.class, (String)"b"));
        Assertions.assertNull((Object)FieldUtils.getField(PublicChild.class, (String)"i"));
        Assertions.assertNull((Object)FieldUtils.getField(PublicChild.class, (String)"d"));
        Assertions.assertEquals(Foo.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"VALUE").getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"s").getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"b").getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"i").getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"d").getDeclaringClass());
        Assertions.assertEquals(Foo.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"VALUE").getDeclaringClass());
        Assertions.assertEquals(this.parentClass, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"s").getDeclaringClass());
        Assertions.assertNull((Object)FieldUtils.getField(PrivatelyShadowedChild.class, (String)"b"));
        Assertions.assertNull((Object)FieldUtils.getField(PrivatelyShadowedChild.class, (String)"i"));
        Assertions.assertNull((Object)FieldUtils.getField(PrivatelyShadowedChild.class, (String)"d"));
    }

    @Test
    public void testGetFieldIllegalArgumentException1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getField(null, (String)"none"));
    }

    @Test
    public void testGetFieldIllegalArgumentException2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getField(PublicChild.class, null));
    }

    @Test
    public void testGetFieldIllegalArgumentException3() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getField(PublicChild.class, (String)""));
    }

    @Test
    public void testGetFieldIllegalArgumentException4() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getField(PublicChild.class, (String)" "));
    }

    @Test
    public void testGetFieldForceAccess() {
        Assertions.assertEquals(PublicChild.class, FieldUtils.getField(PublicChild.class, (String)"VALUE", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(this.parentClass, FieldUtils.getField(PublicChild.class, (String)"s", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(this.parentClass, FieldUtils.getField(PublicChild.class, (String)"b", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(this.parentClass, FieldUtils.getField(PublicChild.class, (String)"i", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(this.parentClass, FieldUtils.getField(PublicChild.class, (String)"d", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(Foo.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"VALUE", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"s", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"b", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"i", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"d", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(Foo.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"VALUE", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"s", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"b", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"i", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"d", (boolean)true).getDeclaringClass());
    }

    @Test
    public void testGetFieldForceAccessIllegalArgumentException1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getField(null, (String)"none", (boolean)true));
    }

    @Test
    public void testGetFieldForceAccessIllegalArgumentException2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getField(PublicChild.class, null, (boolean)true));
    }

    @Test
    public void testGetFieldForceAccessIllegalArgumentException3() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getField(PublicChild.class, (String)"", (boolean)true));
    }

    @Test
    public void testGetFieldForceAccessIllegalArgumentException4() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getField(PublicChild.class, (String)" ", (boolean)true));
    }

    @Test
    public void testGetAllFields() {
        Assertions.assertArrayEquals((Object[])new Field[0], (Object[])FieldUtils.getAllFields(Object.class));
        Object[] fieldsNumber = Number.class.getDeclaredFields();
        Assertions.assertArrayEquals((Object[])fieldsNumber, (Object[])FieldUtils.getAllFields(Number.class));
        Object[] fieldsInteger = Integer.class.getDeclaredFields();
        Assertions.assertArrayEquals((Object[])ArrayUtils.addAll((Object[])fieldsInteger, (Object[])fieldsNumber), (Object[])FieldUtils.getAllFields(Integer.class));
        Object[] allFields = FieldUtils.getAllFields(PublicChild.class);
        int expected = 5;
        for (Field field : allFields) {
            if (!field.getName().equals(JACOCO_DATA_FIELD_NAME)) continue;
            ++expected;
        }
        Assertions.assertEquals((int)expected, (int)allFields.length, (String)Arrays.toString(allFields));
    }

    @Test
    public void testGetAllFieldsList() {
        Assertions.assertEquals((int)0, (int)FieldUtils.getAllFieldsList(Object.class).size());
        List<Field> fieldsNumber = Arrays.asList(Number.class.getDeclaredFields());
        Assertions.assertEquals(fieldsNumber, (Object)FieldUtils.getAllFieldsList(Number.class));
        List<Field> fieldsInteger = Arrays.asList(Integer.class.getDeclaredFields());
        ArrayList<Field> allFieldsInteger = new ArrayList<Field>(fieldsInteger);
        allFieldsInteger.addAll(fieldsNumber);
        Assertions.assertEquals(allFieldsInteger, (Object)FieldUtils.getAllFieldsList(Integer.class));
        List allFields = FieldUtils.getAllFieldsList(PublicChild.class);
        int expected = 5;
        for (Field field : allFields) {
            if (!field.getName().equals(JACOCO_DATA_FIELD_NAME)) continue;
            ++expected;
        }
        Assertions.assertEquals((int)expected, (int)allFields.size(), (String)allFields.toString());
    }

    @Test
    public void testGetFieldsWithAnnotation() throws NoSuchFieldException {
        Assertions.assertArrayEquals((Object[])new Field[0], (Object[])FieldUtils.getFieldsWithAnnotation(Object.class, Annotated.class));
        Object[] annotatedFields = new Field[]{FieldUtilsTest.class.getDeclaredField("publicChild"), FieldUtilsTest.class.getDeclaredField("privatelyShadowedChild")};
        Assertions.assertArrayEquals((Object[])annotatedFields, (Object[])FieldUtils.getFieldsWithAnnotation(FieldUtilsTest.class, Annotated.class));
    }

    @Test
    public void testGetFieldsWithAnnotationIllegalArgumentException1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getFieldsWithAnnotation(FieldUtilsTest.class, null));
    }

    @Test
    public void testGetFieldsWithAnnotationIllegalArgumentException2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getFieldsWithAnnotation(null, Annotated.class));
    }

    @Test
    public void testGetFieldsWithAnnotationIllegalArgumentException3() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getFieldsWithAnnotation(null, null));
    }

    @Test
    public void testGetFieldsListWithAnnotation() throws NoSuchFieldException {
        Assertions.assertEquals((int)0, (int)FieldUtils.getFieldsListWithAnnotation(Object.class, Annotated.class).size());
        List<Field> annotatedFields = Arrays.asList(FieldUtilsTest.class.getDeclaredField("publicChild"), FieldUtilsTest.class.getDeclaredField("privatelyShadowedChild"));
        List fieldUtilsTestAnnotatedFields = FieldUtils.getFieldsListWithAnnotation(FieldUtilsTest.class, Annotated.class);
        Assertions.assertEquals((int)annotatedFields.size(), (int)fieldUtilsTestAnnotatedFields.size());
        Assertions.assertTrue((boolean)fieldUtilsTestAnnotatedFields.contains(annotatedFields.get(0)));
        Assertions.assertTrue((boolean)fieldUtilsTestAnnotatedFields.contains(annotatedFields.get(1)));
    }

    @Test
    public void testGetFieldsListWithAnnotationIllegalArgumentException1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getFieldsListWithAnnotation(FieldUtilsTest.class, null));
    }

    @Test
    public void testGetFieldsListWithAnnotationIllegalArgumentException2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getFieldsListWithAnnotation(null, Annotated.class));
    }

    @Test
    public void testGetFieldsListWithAnnotationIllegalArgumentException3() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getFieldsListWithAnnotation(null, null));
    }

    @Test
    public void testGetDeclaredField() {
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"VALUE"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"s"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"b"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"i"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"d"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"VALUE"));
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"s").getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"b").getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"i").getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"d").getDeclaringClass());
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"VALUE"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"s"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"b"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"i"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"d"));
    }

    @Test
    public void testGetDeclaredFieldAccessIllegalArgumentException1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getDeclaredField(null, (String)"none"));
    }

    @Test
    public void testGetDeclaredFieldAccessIllegalArgumentException2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getDeclaredField(PublicChild.class, null));
    }

    @Test
    public void testGetDeclaredFieldAccessIllegalArgumentException3() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getDeclaredField(PublicChild.class, (String)""));
    }

    @Test
    public void testGetDeclaredFieldAccessIllegalArgumentException4() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getDeclaredField(PublicChild.class, (String)" "));
    }

    @Test
    public void testGetDeclaredFieldForceAccess() {
        Assertions.assertEquals(PublicChild.class, FieldUtils.getDeclaredField(PublicChild.class, (String)"VALUE", (boolean)true).getDeclaringClass());
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"s", (boolean)true));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"b", (boolean)true));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"i", (boolean)true));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"d", (boolean)true));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"VALUE", (boolean)true));
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"s", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"b", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"i", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"d", (boolean)true).getDeclaringClass());
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"VALUE", (boolean)true));
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"s", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"b", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"i", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"d", (boolean)true).getDeclaringClass());
    }

    @Test
    public void testGetDeclaredFieldForceAccessIllegalArgumentException1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getDeclaredField(null, (String)"none", (boolean)true));
    }

    @Test
    public void testGetDeclaredFieldForceAccessIllegalArgumentException2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getDeclaredField(PublicChild.class, null, (boolean)true));
    }

    @Test
    public void testGetDeclaredFieldForceAccessIllegalArgumentException3() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getDeclaredField(PublicChild.class, (String)"", (boolean)true));
    }

    @Test
    public void testGetDeclaredFieldForceAccessIllegalArgumentException4() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getDeclaredField(PublicChild.class, (String)" ", (boolean)true));
    }

    @Test
    public void testReadStaticField() throws Exception {
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField((Field)FieldUtils.getField(Foo.class, (String)"VALUE")));
    }

    @Test
    public void testReadStaticFieldIllegalArgumentException1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField(null));
    }

    @Test
    public void testReadStaticFieldIllegalArgumentException2() throws Exception {
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField((Field)FieldUtils.getField(Foo.class, (String)"VALUE")));
        Field nonStaticField = FieldUtils.getField(PublicChild.class, (String)"s");
        Assumptions.assumeTrue((nonStaticField != null ? 1 : 0) != 0);
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField((Field)nonStaticField));
    }

    @Test
    public void testReadStaticFieldForceAccess() throws Exception {
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField((Field)FieldUtils.getField(Foo.class, (String)"VALUE")));
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField((Field)FieldUtils.getField(PublicChild.class, (String)"VALUE")));
    }

    @Test
    public void testReadStaticFieldForceAccessIllegalArgumentException1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField(null, (boolean)true));
    }

    @Test
    public void testReadStaticFieldForceAccessIllegalArgumentException2() {
        Field nonStaticField = FieldUtils.getField(PublicChild.class, (String)"s", (boolean)true);
        Assumptions.assumeTrue((nonStaticField != null ? 1 : 0) != 0);
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField((Field)nonStaticField));
    }

    @Test
    public void testReadNamedStaticField() throws Exception {
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(Foo.class, (String)"VALUE"));
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(PubliclyShadowedChild.class, (String)"VALUE"));
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(PrivatelyShadowedChild.class, (String)"VALUE"));
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(PublicChild.class, (String)"VALUE"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField(null, (String)"none"), (String)"null class should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField(Foo.class, null), (String)"null field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField(Foo.class, (String)""), (String)"empty field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField(Foo.class, (String)" "), (String)"blank field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField(Foo.class, (String)"does_not_exist"), (String)"a field that doesn't exist should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField(PublicChild.class, (String)"s"), (String)"non-static field should cause an IllegalArgumentException");
    }

    @Test
    public void testReadNamedStaticFieldForceAccess() throws Exception {
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(Foo.class, (String)"VALUE", (boolean)true));
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(PubliclyShadowedChild.class, (String)"VALUE", (boolean)true));
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(PrivatelyShadowedChild.class, (String)"VALUE", (boolean)true));
        Assertions.assertEquals((Object)"child", (Object)FieldUtils.readStaticField(PublicChild.class, (String)"VALUE", (boolean)true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField(null, (String)"none", (boolean)true), (String)"null class should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField(Foo.class, null, (boolean)true), (String)"null field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField(Foo.class, (String)"", (boolean)true), (String)"empty field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField(Foo.class, (String)" ", (boolean)true), (String)"blank field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField(Foo.class, (String)"does_not_exist", (boolean)true), (String)"a field that doesn't exist should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readStaticField(PublicChild.class, (String)"s", (boolean)false), (String)"non-static field should cause an IllegalArgumentException");
    }

    @Test
    public void testReadDeclaredNamedStaticField() throws Exception {
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readDeclaredStaticField(Foo.class, (String)"VALUE"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredStaticField(PublicChild.class, (String)"VALUE"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredStaticField(PubliclyShadowedChild.class, (String)"VALUE"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredStaticField(PrivatelyShadowedChild.class, (String)"VALUE"));
    }

    @Test
    public void testReadDeclaredNamedStaticFieldForceAccess() throws Exception {
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readDeclaredStaticField(Foo.class, (String)"VALUE", (boolean)true));
        Assertions.assertEquals((Object)"child", (Object)FieldUtils.readDeclaredStaticField(PublicChild.class, (String)"VALUE", (boolean)true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredStaticField(PubliclyShadowedChild.class, (String)"VALUE", (boolean)true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredStaticField(PrivatelyShadowedChild.class, (String)"VALUE", (boolean)true));
    }

    @Test
    public void testReadField() throws Exception {
        Field parentS = FieldUtils.getDeclaredField(this.parentClass, (String)"s");
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.publicChild));
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.publiclyShadowedChild));
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.privatelyShadowedChild));
        Field parentB = FieldUtils.getDeclaredField(this.parentClass, (String)"b", (boolean)true);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.publicChild));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.publiclyShadowedChild));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.privatelyShadowedChild));
        Field parentI = FieldUtils.getDeclaredField(this.parentClass, (String)"i", (boolean)true);
        Assertions.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.publicChild));
        Assertions.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.publiclyShadowedChild));
        Assertions.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.privatelyShadowedChild));
        Field parentD = FieldUtils.getDeclaredField(this.parentClass, (String)"d", (boolean)true);
        Assertions.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.publicChild));
        Assertions.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.publiclyShadowedChild));
        Assertions.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.privatelyShadowedChild));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField(null, (Object)this.publicChild), (String)"a null field should cause an IllegalArgumentException");
    }

    @Test
    public void testReadFieldForceAccess() throws Exception {
        Field parentS = FieldUtils.getDeclaredField(this.parentClass, (String)"s");
        parentS.setAccessible(false);
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.publicChild, (boolean)true));
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.publiclyShadowedChild, (boolean)true));
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.privatelyShadowedChild, (boolean)true));
        Field parentB = FieldUtils.getDeclaredField(this.parentClass, (String)"b", (boolean)true);
        parentB.setAccessible(false);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.publicChild, (boolean)true));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.publiclyShadowedChild, (boolean)true));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.privatelyShadowedChild, (boolean)true));
        Field parentI = FieldUtils.getDeclaredField(this.parentClass, (String)"i", (boolean)true);
        parentI.setAccessible(false);
        Assertions.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.publicChild, (boolean)true));
        Assertions.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.publiclyShadowedChild, (boolean)true));
        Assertions.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.privatelyShadowedChild, (boolean)true));
        Field parentD = FieldUtils.getDeclaredField(this.parentClass, (String)"d", (boolean)true);
        parentD.setAccessible(false);
        Assertions.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.publicChild, (boolean)true));
        Assertions.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.publiclyShadowedChild, (boolean)true));
        Assertions.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.privatelyShadowedChild, (boolean)true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField(null, (Object)this.publicChild, (boolean)true), (String)"a null field should cause an IllegalArgumentException");
    }

    @Test
    public void testReadNamedField() throws Exception {
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Object)this.publicChild, (String)"s"));
        Assertions.assertEquals((Object)"ss", (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"s"));
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"s"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField((Object)this.publicChild, null), (String)"a null field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField((Object)this.publicChild, (String)""), (String)"an empty field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField((Object)this.publicChild, (String)" "), (String)"a blank field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField(null, (String)"none"), (String)"a null target should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField((Object)this.publicChild, (String)"b"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"b"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"b"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField((Object)this.publicChild, (String)"i"));
        Assertions.assertEquals((Object)I1, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"i"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"i"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField((Object)this.publicChild, (String)"d"));
        Assertions.assertEquals((Object)D1, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"d"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"d"));
    }

    @Test
    public void testReadNamedFieldForceAccess() throws Exception {
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Object)this.publicChild, (String)"s", (boolean)true));
        Assertions.assertEquals((Object)"ss", (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"s", (boolean)true));
        Assertions.assertEquals((Object)"ss", (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"s", (boolean)true));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Object)this.publicChild, (String)"b", (boolean)true));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"b", (boolean)true));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"b", (boolean)true));
        Assertions.assertEquals((Object)I0, (Object)FieldUtils.readField((Object)this.publicChild, (String)"i", (boolean)true));
        Assertions.assertEquals((Object)I1, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"i", (boolean)true));
        Assertions.assertEquals((Object)I1, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"i", (boolean)true));
        Assertions.assertEquals((Object)D0, (Object)FieldUtils.readField((Object)this.publicChild, (String)"d", (boolean)true));
        Assertions.assertEquals((Object)D1, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"d", (boolean)true));
        Assertions.assertEquals((Object)D1, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"d", (boolean)true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField((Object)this.publicChild, null, (boolean)true), (String)"a null field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField((Object)this.publicChild, (String)"", (boolean)true), (String)"an empty field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField((Object)this.publicChild, (String)" ", (boolean)true), (String)"a blank field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readField(null, (String)"none", (boolean)true), (String)"a null target should cause an IllegalArgumentException");
    }

    @Test
    public void testReadDeclaredNamedField() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.publicChild, null), (String)"a null field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)""), (String)"an empty field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)" "), (String)"a blank field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField(null, (String)"none"), (String)"a null target should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"s"));
        Assertions.assertEquals((Object)"ss", (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"s"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"s"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"b"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"b"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"b"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"i"));
        Assertions.assertEquals((Object)I1, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"i"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"i"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"d"));
        Assertions.assertEquals((Object)D1, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"d"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"d"));
    }

    @Test
    public void testReadDeclaredNamedFieldForceAccess() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.publicChild, null, (boolean)true), (String)"a null field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"", (boolean)true), (String)"an empty field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)" ", (boolean)true), (String)"a blank field name should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField(null, (String)"none", (boolean)true), (String)"a null target should cause an IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"s", (boolean)true));
        Assertions.assertEquals((Object)"ss", (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"s", (boolean)true));
        Assertions.assertEquals((Object)"ss", (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"s", (boolean)true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"b", (boolean)true));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"b", (boolean)true));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"b", (boolean)true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"i", (boolean)true));
        Assertions.assertEquals((Object)I1, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"i", (boolean)true));
        Assertions.assertEquals((Object)I1, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"i", (boolean)true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"d", (boolean)true));
        Assertions.assertEquals((Object)D1, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"d", (boolean)true));
        Assertions.assertEquals((Object)D1, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"d", (boolean)true));
    }

    @Test
    public void testWriteStaticField() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("mutablePublic");
        FieldUtils.writeStaticField((Field)field, (Object)"new");
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("mutableProtected"), (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("mutablePackage"), (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("mutablePrivate"), (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PUBLIC"), (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PROTECTED"), (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PACKAGE"), (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PRIVATE"), (Object)"new"));
    }

    @Test
    public void testWriteStaticFieldForceAccess() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("mutablePublic");
        FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        field = StaticContainer.class.getDeclaredField("mutableProtected");
        FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutableProtected());
        field = StaticContainer.class.getDeclaredField("mutablePackage");
        FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutablePackage());
        field = StaticContainer.class.getDeclaredField("mutablePrivate");
        FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutablePrivate());
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PUBLIC"), (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PROTECTED"), (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PACKAGE"), (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PRIVATE"), (Object)"new", (boolean)true));
    }

    @Test
    public void testWriteNamedStaticField() throws Exception {
        FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePublic", (Object)"new");
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutableProtected", (Object)"new"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePackage", (Object)"new"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePrivate", (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PUBLIC", (Object)"new"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PROTECTED", (Object)"new"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PACKAGE", (Object)"new"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PRIVATE", (Object)"new"));
    }

    @Test
    public void testWriteNamedStaticFieldForceAccess() throws Exception {
        FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePublic", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutableProtected", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutableProtected());
        FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePackage", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutablePackage());
        FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePrivate", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutablePrivate());
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PUBLIC", (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PROTECTED", (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PACKAGE", (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PRIVATE", (Object)"new", (boolean)true));
    }

    @Test
    public void testWriteDeclaredNamedStaticField() throws Exception {
        FieldUtils.writeStaticField(StaticContainer.class, (String)"mutablePublic", (Object)"new");
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutableProtected", (Object)"new"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutablePackage", (Object)"new"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutablePrivate", (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PUBLIC", (Object)"new"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PROTECTED", (Object)"new"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PACKAGE", (Object)"new"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PRIVATE", (Object)"new"));
    }

    @Test
    public void testWriteDeclaredNamedStaticFieldForceAccess() throws Exception {
        FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutablePublic", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutableProtected", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutableProtected());
        FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutablePackage", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutablePackage());
        FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutablePrivate", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutablePrivate());
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PUBLIC", (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PROTECTED", (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PACKAGE", (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PRIVATE", (Object)"new", (boolean)true));
    }

    @Test
    public void testWriteField() throws Exception {
        Field field = this.parentClass.getDeclaredField("s");
        FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)"S");
        Assertions.assertEquals((Object)"S", (Object)field.get(this.publicChild));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeField((Field)this.parentClass.getDeclaredField("b"), (Object)this.publicChild, (Object)Boolean.TRUE));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeField((Field)this.parentClass.getDeclaredField("i"), (Object)this.publicChild, (Object)Integer.MAX_VALUE));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeField((Field)this.parentClass.getDeclaredField("d"), (Object)this.publicChild, (Object)Double.MAX_VALUE));
    }

    @Test
    public void testWriteFieldForceAccess() throws Exception {
        Field field = this.parentClass.getDeclaredField("s");
        FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)"S", (boolean)true);
        Assertions.assertEquals((Object)"S", (Object)field.get(this.publicChild));
        field = this.parentClass.getDeclaredField("b");
        FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)Boolean.TRUE, (boolean)true);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)field.get(this.publicChild));
        field = this.parentClass.getDeclaredField("i");
        FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)Integer.MAX_VALUE, (boolean)true);
        Assertions.assertEquals((Object)Integer.MAX_VALUE, (Object)field.get(this.publicChild));
        field = this.parentClass.getDeclaredField("d");
        FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)Double.MAX_VALUE, (boolean)true);
        Assertions.assertEquals((Object)Double.MAX_VALUE, (Object)field.get(this.publicChild));
    }

    @Test
    public void testWriteNamedField() throws Exception {
        FieldUtils.writeField((Object)this.publicChild, (String)"s", (Object)"S");
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.publicChild, (String)"s"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeField((Object)this.publicChild, (String)"b", (Object)Boolean.TRUE));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeField((Object)this.publicChild, (String)"i", (Object)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeField((Object)this.publicChild, (String)"d", (Object)1.0));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"s", (Object)"S");
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"s"));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"b", (Object)Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"b"));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"i", (Object)0);
        Assertions.assertEquals((Object)0, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"i"));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"d", (Object)0.0);
        Assertions.assertEquals((Object)0.0, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"d"));
        FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"s", (Object)"S");
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"s"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"b", (Object)Boolean.TRUE));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"i", (Object)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"d", (Object)1.0));
    }

    @Test
    public void testWriteNamedFieldForceAccess() throws Exception {
        FieldUtils.writeField((Object)this.publicChild, (String)"s", (Object)"S", (boolean)true);
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.publicChild, (String)"s", (boolean)true));
        FieldUtils.writeField((Object)this.publicChild, (String)"b", (Object)Boolean.TRUE, (boolean)true);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readField((Object)this.publicChild, (String)"b", (boolean)true));
        FieldUtils.writeField((Object)this.publicChild, (String)"i", (Object)1, (boolean)true);
        Assertions.assertEquals((Object)1, (Object)FieldUtils.readField((Object)this.publicChild, (String)"i", (boolean)true));
        FieldUtils.writeField((Object)this.publicChild, (String)"d", (Object)1.0, (boolean)true);
        Assertions.assertEquals((Object)1.0, (Object)FieldUtils.readField((Object)this.publicChild, (String)"d", (boolean)true));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"s", (Object)"S", (boolean)true);
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"s", (boolean)true));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"b", (Object)Boolean.FALSE, (boolean)true);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"b", (boolean)true));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"i", (Object)0, (boolean)true);
        Assertions.assertEquals((Object)0, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"i", (boolean)true));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"d", (Object)0.0, (boolean)true);
        Assertions.assertEquals((Object)0.0, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"d", (boolean)true));
        FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"s", (Object)"S", (boolean)true);
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"s", (boolean)true));
        FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"b", (Object)Boolean.FALSE, (boolean)true);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"b", (boolean)true));
        FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"i", (Object)0, (boolean)true);
        Assertions.assertEquals((Object)0, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"i", (boolean)true));
        FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"d", (Object)0.0, (boolean)true);
        Assertions.assertEquals((Object)0.0, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"d", (boolean)true));
    }

    @Test
    public void testWriteDeclaredNamedField() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"s", (Object)"S"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"b", (Object)Boolean.TRUE));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"i", (Object)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"d", (Object)1.0));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"s", (Object)"S");
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"s"));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"b", (Object)Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"b"));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"i", (Object)0);
        Assertions.assertEquals((Object)0, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"i"));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"d", (Object)0.0);
        Assertions.assertEquals((Object)0.0, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"d"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"s", (Object)"S"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"b", (Object)Boolean.TRUE));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"i", (Object)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"d", (Object)1.0));
    }

    @Test
    public void testWriteDeclaredNamedFieldForceAccess() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"s", (Object)"S", (boolean)true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"b", (Object)Boolean.TRUE, (boolean)true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"i", (Object)1, (boolean)true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"d", (Object)1.0, (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"s", (Object)"S", (boolean)true);
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"s", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"b", (Object)Boolean.FALSE, (boolean)true);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"b", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"i", (Object)0, (boolean)true);
        Assertions.assertEquals((Object)0, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"i", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"d", (Object)0.0, (boolean)true);
        Assertions.assertEquals((Object)0.0, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"d", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"s", (Object)"S", (boolean)true);
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"s", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"b", (Object)Boolean.FALSE, (boolean)true);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"b", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"i", (Object)0, (boolean)true);
        Assertions.assertEquals((Object)0, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"i", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"d", (Object)0.0, (boolean)true);
        Assertions.assertEquals((Object)0.0, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"d", (boolean)true));
    }

    @Test
    public void testAmbig() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FieldUtils.getField(Ambig.class, (String)"VALUE"));
    }

    @Test
    public void testRemoveFinalModifier() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("IMMUTABLE_PRIVATE_2");
        Assertions.assertFalse((boolean)field.isAccessible());
        Assertions.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
        this.callRemoveFinalModifierCheckForException(field, true);
        if (SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11)) {
            Assertions.assertFalse((boolean)Modifier.isFinal(field.getModifiers()));
            Assertions.assertFalse((boolean)field.isAccessible());
        }
    }

    @Test
    public void testRemoveFinalModifierWithAccess() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("IMMUTABLE_PRIVATE_2");
        Assertions.assertFalse((boolean)field.isAccessible());
        Assertions.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
        this.callRemoveFinalModifierCheckForException(field, true);
        if (SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11)) {
            Assertions.assertFalse((boolean)Modifier.isFinal(field.getModifiers()));
            Assertions.assertFalse((boolean)field.isAccessible());
        }
    }

    @Test
    public void testRemoveFinalModifierWithoutAccess() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("IMMUTABLE_PRIVATE_2");
        Assertions.assertFalse((boolean)field.isAccessible());
        Assertions.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
        this.callRemoveFinalModifierCheckForException(field, false);
        if (SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11)) {
            Assertions.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
            Assertions.assertFalse((boolean)field.isAccessible());
        }
    }

    @Test
    public void testRemoveFinalModifierAccessNotNeeded() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("IMMUTABLE_PACKAGE");
        Assertions.assertFalse((boolean)field.isAccessible());
        Assertions.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
        this.callRemoveFinalModifierCheckForException(field, false);
        if (SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11)) {
            Assertions.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
            Assertions.assertFalse((boolean)field.isAccessible());
        }
    }

    private void callRemoveFinalModifierCheckForException(Field field, Boolean forceAccess) {
        try {
            FieldUtils.removeFinalModifier((Field)field, (boolean)forceAccess);
        }
        catch (UnsupportedOperationException exception) {
            if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12)) {
                Assertions.assertTrue((boolean)(exception.getCause() instanceof NoSuchFieldException));
            }
            Assertions.fail((String)"No exception should be thrown for java prior to 12.0");
        }
    }
}

