/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.regex.Pattern;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConstantInitializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConstantInitializerTest {
    private static final Integer VALUE = 42;
    private ConstantInitializer<Integer> init;

    @BeforeEach
    public void setUp() {
        this.init = new ConstantInitializer((Object)VALUE);
    }

    private void checkEquals(Object obj, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)this.init.equals(obj), (String)"Wrong result of equals");
        if (obj != null) {
            Assertions.assertEquals((Object)expected, (Object)obj.equals(this.init), (String)"Not symmetric");
            if (expected) {
                Assertions.assertEquals((int)this.init.hashCode(), (int)obj.hashCode(), (String)"Different hash codes");
            }
        }
    }

    @Test
    public void testGetObject() {
        Assertions.assertEquals((Integer)VALUE, (Integer)((Integer)this.init.getObject()), (String)"Wrong object");
    }

    @Test
    public void testGet() throws ConcurrentException {
        Assertions.assertEquals((Integer)VALUE, (Integer)((Integer)this.init.get()), (String)"Wrong object");
    }

    @Test
    public void testEqualsTrue() {
        this.checkEquals(this.init, true);
        ConstantInitializer init2 = new ConstantInitializer((Object)VALUE);
        this.checkEquals(init2, true);
        this.init = new ConstantInitializer(null);
        init2 = new ConstantInitializer(null);
        this.checkEquals(init2, true);
    }

    @Test
    public void testEqualsFalse() {
        ConstantInitializer init2 = new ConstantInitializer(null);
        this.checkEquals(init2, false);
        init2 = new ConstantInitializer((Object)(VALUE + 1));
        this.checkEquals(init2, false);
    }

    @Test
    public void testEqualsWithOtherObjects() {
        this.checkEquals(null, false);
        this.checkEquals(this, false);
        this.checkEquals(new ConstantInitializer((Object)"Test"), false);
    }

    @Test
    public void testToString() {
        String s = this.init.toString();
        Pattern pattern = Pattern.compile("ConstantInitializer@-?\\d+ \\[ object = " + VALUE + " \\]");
        Assertions.assertTrue((boolean)pattern.matcher(s).matches(), (String)("Wrong string: " + s));
    }

    @Test
    public void testToStringNull() {
        String s = new ConstantInitializer(null).toString();
        Assertions.assertTrue((s.indexOf("object = null") > 0 ? 1 : 0) != 0, (String)("Object not found: " + s));
    }
}

