/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarFile;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class TarTestCase
extends AbstractTestCase {
    @Test
    public void testTarArchiveCreation() throws Exception {
        File output = new File(this.dir, "bla.tar");
        File file1 = TarTestCase.getFile("test1.xml");
        OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
        ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", out);
        TarArchiveEntry entry = new TarArchiveEntry("testdata/test1.xml");
        entry.setModTime(0L);
        entry.setSize(file1.length());
        entry.setUserId(0);
        entry.setGroupId(0);
        entry.setUserName("avalon");
        entry.setGroupName("excalibur");
        entry.setMode(32768);
        os.putArchiveEntry((ArchiveEntry)entry);
        IOUtils.copy((InputStream)Files.newInputStream(file1.toPath(), new OpenOption[0]), (OutputStream)os);
        os.closeArchiveEntry();
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTarArchiveLongNameCreation() throws Exception {
        String name = "testdata/12345678901234567890123456789012345678901234567890123456789012345678901234567890123456.xml";
        byte[] bytes = "testdata/12345678901234567890123456789012345678901234567890123456789012345678901234567890123456.xml".getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((long)bytes.length, (long)99L);
        File output = new File(this.dir, "bla.tar");
        File file1 = TarTestCase.getFile("test1.xml");
        OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
        ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", out);
        TarArchiveEntry entry = new TarArchiveEntry("testdata/12345678901234567890123456789012345678901234567890123456789012345678901234567890123456.xml");
        entry.setModTime(0L);
        entry.setSize(file1.length());
        entry.setUserId(0);
        entry.setGroupId(0);
        entry.setUserName("avalon");
        entry.setGroupName("excalibur");
        entry.setMode(32768);
        os.putArchiveEntry((ArchiveEntry)entry);
        InputStream in = Files.newInputStream(file1.toPath(), new OpenOption[0]);
        IOUtils.copy((InputStream)in, (OutputStream)os);
        os.closeArchiveEntry();
        os.close();
        out.close();
        in.close();
        try (ArchiveOutputStream os2 = null;){
            String toLongName = "testdata/123456789012345678901234567890123456789012345678901234567890123456789012345678901234567.xml";
            File output2 = new File(this.dir, "bla.tar");
            OutputStream out2 = Files.newOutputStream(output2.toPath(), new OpenOption[0]);
            os2 = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", out2);
            TarArchiveEntry entry2 = new TarArchiveEntry("testdata/123456789012345678901234567890123456789012345678901234567890123456789012345678901234567.xml");
            entry2.setModTime(0L);
            entry2.setSize(file1.length());
            entry2.setUserId(0);
            entry2.setGroupId(0);
            entry2.setUserName("avalon");
            entry2.setGroupName("excalibur");
            entry2.setMode(32768);
            os2.putArchiveEntry((ArchiveEntry)entry);
            IOUtils.copy((InputStream)Files.newInputStream(file1.toPath(), new OpenOption[0]), (OutputStream)os2);
            os2.closeArchiveEntry();
        }
    }

    @Test
    public void testTarUnarchive() throws Exception {
        File input = TarTestCase.getFile("bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("tar", is);){
            TarArchiveEntry entry = (TarArchiveEntry)in.getNextEntry();
            try (OutputStream out = Files.newOutputStream(new File(this.dir, entry.getName()).toPath(), new OpenOption[0]);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
    }

    @Test
    public void testTarFileUnarchive() throws Exception {
        File file = TarTestCase.getFile("bla.tar");
        try (TarFile tarFile = new TarFile(file);){
            TarArchiveEntry entry = (TarArchiveEntry)tarFile.getEntries().get(0);
            try (OutputStream out = Files.newOutputStream(new File(this.dir, entry.getName()).toPath(), new OpenOption[0]);){
                IOUtils.copy((InputStream)tarFile.getInputStream(entry), (OutputStream)out);
            }
        }
    }

    @Test
    public void testCOMPRESS114() throws Exception {
        File input = TarTestCase.getFile("COMPRESS-114.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             TarArchiveInputStream in = new TarArchiveInputStream(is, "ISO-8859-1");){
            TarArchiveEntry entry = (TarArchiveEntry)in.getNextEntry();
            Assert.assertEquals((Object)"3\u00b1\u00b1\u00b1F06\u00b1W2345\u00b1ZB\u00b1la\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1BLA", (Object)entry.getName());
            entry = (TarArchiveEntry)in.getNextEntry();
            Assert.assertEquals((Object)"0302-0601-3\u00b1\u00b1\u00b1F06\u00b1W2345\u00b1ZB\u00b1la\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1BLA", (Object)entry.getName());
        }
    }

    @Test
    public void testTarFileCOMPRESS114() throws Exception {
        File input = TarTestCase.getFile("COMPRESS-114.tar");
        try (TarFile tarFile = new TarFile(input, "ISO-8859-1");){
            List entries = tarFile.getEntries();
            TarArchiveEntry entry = (TarArchiveEntry)entries.get(0);
            Assert.assertEquals((Object)"3\u00b1\u00b1\u00b1F06\u00b1W2345\u00b1ZB\u00b1la\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1BLA", (Object)entry.getName());
            entry = (TarArchiveEntry)entries.get(1);
            Assert.assertEquals((Object)"0302-0601-3\u00b1\u00b1\u00b1F06\u00b1W2345\u00b1ZB\u00b1la\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1BLA", (Object)entry.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectoryEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        TarArchiveOutputStream tos = null;
        TarArchiveInputStream tis = null;
        try {
            archive = File.createTempFile("test.", ".tar", tmp[0]);
            archive.deleteOnExit();
            tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            long beforeArchiveWrite = tmp[0].lastModified();
            TarArchiveEntry in = new TarArchiveEntry(tmp[0], "foo");
            tos.putArchiveEntry((ArchiveEntry)in);
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new TarArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            TarArchiveEntry out = tis.getNextTarEntry();
            tis.close();
            tis = null;
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo/", (Object)out.getName());
            Assert.assertEquals((long)0L, (long)out.getSize());
            Assert.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assert.assertTrue((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            TarTestCase.tryHardToDelete(archive);
            TarTestCase.tryHardToDelete(tmp[1]);
            TarTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTarFileDirectoryEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = File.createTempFile("test.", ".tar", tmp[0]);
        archive.deleteOnExit();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            long beforeArchiveWrite = tmp[0].lastModified();
            TarArchiveEntry in = new TarArchiveEntry(tmp[0], "foo");
            tos.putArchiveEntry((ArchiveEntry)in);
            tos.closeArchiveEntry();
            tos.close();
            try (TarFile tarFile = new TarFile(archive);){
                TarArchiveEntry entry = (TarArchiveEntry)tarFile.getEntries().get(0);
                Assert.assertNotNull((Object)entry);
                Assert.assertEquals((Object)"foo/", (Object)entry.getName());
                Assert.assertEquals((long)0L, (long)entry.getSize());
                Assert.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(entry.getLastModifiedDate().getTime() / 1000L));
                Assert.assertTrue((boolean)entry.isDirectory());
            }
            finally {
                TarTestCase.tryHardToDelete(archive);
                TarTestCase.tryHardToDelete(tmp[1]);
                TarTestCase.rmdir(tmp[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitDirectoryEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        TarArchiveOutputStream tos = null;
        TarArchiveInputStream tis = null;
        try {
            archive = File.createTempFile("test.", ".tar", tmp[0]);
            archive.deleteOnExit();
            tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            long beforeArchiveWrite = tmp[0].lastModified();
            TarArchiveEntry in = new TarArchiveEntry("foo/");
            in.setModTime(beforeArchiveWrite);
            tos.putArchiveEntry((ArchiveEntry)in);
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new TarArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            TarArchiveEntry out = tis.getNextTarEntry();
            tis.close();
            tis = null;
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo/", (Object)out.getName());
            Assert.assertEquals((long)0L, (long)out.getSize());
            Assert.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assert.assertTrue((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            TarTestCase.tryHardToDelete(archive);
            TarTestCase.tryHardToDelete(tmp[1]);
            TarTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTarFileExplicitDirectoryEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = File.createTempFile("test.", ".tar", tmp[0]);
        archive.deleteOnExit();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            long beforeArchiveWrite = tmp[0].lastModified();
            TarArchiveEntry in = new TarArchiveEntry("foo/");
            in.setModTime(beforeArchiveWrite);
            tos.putArchiveEntry((ArchiveEntry)in);
            tos.closeArchiveEntry();
            tos.close();
            try (TarFile tarFile = new TarFile(archive);){
                TarArchiveEntry entry = (TarArchiveEntry)tarFile.getEntries().get(0);
                Assert.assertNotNull((Object)entry);
                Assert.assertEquals((Object)"foo/", (Object)entry.getName());
                Assert.assertEquals((long)0L, (long)entry.getSize());
                Assert.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(entry.getLastModifiedDate().getTime() / 1000L));
                Assert.assertTrue((boolean)entry.isDirectory());
            }
        }
        finally {
            TarTestCase.tryHardToDelete(archive);
            TarTestCase.tryHardToDelete(tmp[1]);
            TarTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        TarArchiveOutputStream tos = null;
        TarArchiveInputStream tis = null;
        InputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".tar", tmp[0]);
            archive.deleteOnExit();
            tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            TarArchiveEntry in = new TarArchiveEntry(tmp[1], "foo");
            tos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = Files.newInputStream(tmp[1].toPath(), new OpenOption[0]);
            while (fis.read(b) > 0) {
                tos.write(b);
            }
            fis.close();
            fis = null;
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new TarArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            TarArchiveEntry out = tis.getNextTarEntry();
            tis.close();
            tis = null;
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo", (Object)out.getName());
            Assert.assertEquals((long)tmp[1].length(), (long)out.getSize());
            Assert.assertEquals((long)(tmp[1].lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assert.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            TarTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            TarTestCase.tryHardToDelete(tmp[1]);
            TarTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTarFileEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = File.createTempFile("test.", ".tar", tmp[0]);
        archive.deleteOnExit();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            TarArchiveEntry in = new TarArchiveEntry(tmp[1], "foo");
            tos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            try (InputStream fis = Files.newInputStream(tmp[1].toPath(), new OpenOption[0]);){
                while (fis.read(b) > 0) {
                    tos.write(b);
                }
            }
            tos.closeArchiveEntry();
            tos.close();
            var8_10 = null;
            try (TarFile tarFile = new TarFile(archive);){
                TarArchiveEntry entry = (TarArchiveEntry)tarFile.getEntries().get(0);
                Assert.assertNotNull((Object)entry);
                Assert.assertEquals((Object)"foo", (Object)entry.getName());
                Assert.assertEquals((long)tmp[1].length(), (long)entry.getSize());
                Assert.assertEquals((long)(tmp[1].lastModified() / 1000L), (long)(entry.getLastModifiedDate().getTime() / 1000L));
                Assert.assertFalse((boolean)entry.isDirectory());
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
        }
        finally {
            TarTestCase.tryHardToDelete(archive);
            TarTestCase.tryHardToDelete(tmp[1]);
            TarTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitFileEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        TarArchiveOutputStream tos = null;
        TarArchiveInputStream tis = null;
        InputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".tar", tmp[0]);
            archive.deleteOnExit();
            tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            TarArchiveEntry in = new TarArchiveEntry("foo");
            in.setModTime(tmp[1].lastModified());
            in.setSize(tmp[1].length());
            tos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = Files.newInputStream(tmp[1].toPath(), new OpenOption[0]);
            while (fis.read(b) > 0) {
                tos.write(b);
            }
            fis.close();
            fis = null;
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new TarArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            TarArchiveEntry out = tis.getNextTarEntry();
            tis.close();
            tis = null;
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo", (Object)out.getName());
            Assert.assertEquals((long)tmp[1].length(), (long)out.getSize());
            Assert.assertEquals((long)(tmp[1].lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assert.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            TarTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            TarTestCase.tryHardToDelete(tmp[1]);
            TarTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTarFileExplicitFileEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = File.createTempFile("test.", ".tar", tmp[0]);
        archive.deleteOnExit();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            TarArchiveEntry in = new TarArchiveEntry("foo");
            in.setModTime(tmp[1].lastModified());
            in.setSize(tmp[1].length());
            tos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            try (InputStream fis = Files.newInputStream(tmp[1].toPath(), new OpenOption[0]);){
                while (fis.read(b) > 0) {
                    tos.write(b);
                }
            }
            tos.closeArchiveEntry();
            var8_10 = null;
            try (TarFile tarFile = new TarFile(archive);){
                TarArchiveEntry entry = (TarArchiveEntry)tarFile.getEntries().get(0);
                Assert.assertNotNull((Object)entry);
                Assert.assertEquals((Object)"foo", (Object)entry.getName());
                Assert.assertEquals((long)tmp[1].length(), (long)entry.getSize());
                Assert.assertEquals((long)(tmp[1].lastModified() / 1000L), (long)(entry.getLastModifiedDate().getTime() / 1000L));
                Assert.assertFalse((boolean)entry.isDirectory());
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
        }
        finally {
            TarTestCase.tryHardToDelete(archive);
            TarTestCase.tryHardToDelete(tmp[1]);
            TarTestCase.rmdir(tmp[0]);
        }
    }

    @Test
    public void testCOMPRESS178() throws Exception {
        File input = TarTestCase.getFile("COMPRESS-178.tar");
        InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
        ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("tar", is);
        try {
            in.getNextEntry();
            Assert.fail((String)"Expected IOException");
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            Assert.assertTrue((String)"Expected cause = IllegalArgumentException", (boolean)(t instanceof IllegalArgumentException));
        }
        in.close();
    }

    @Test
    public void testTarFileCOMPRESS178() throws Exception {
        File input = TarTestCase.getFile("COMPRESS-178.tar");
        try (TarFile tarFile = new TarFile(input);){
            Assert.fail((String)"Expected IOException");
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            Assert.assertTrue((String)"Expected cause = IllegalArgumentException", (boolean)(t instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testCOMPRESS178Lenient() throws Exception {
        File input = TarTestCase.getFile("COMPRESS-178.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             TarArchiveInputStream in = new TarArchiveInputStream(is, true);){
            in.getNextEntry();
        }
    }

    @Test
    public void testTarFileCOMPRESS178Lenient() throws Exception {
        File input = TarTestCase.getFile("COMPRESS-178.tar");
        TarFile tarFile = new TarFile(input, true);
        Throwable throwable = null;
        if (tarFile != null) {
            if (throwable != null) {
                try {
                    tarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                tarFile.close();
            }
        }
    }

    @Test
    public void testDirectoryRead() throws IOException {
        File input = TarTestCase.getFile("directory.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             TarArchiveInputStream in = new TarArchiveInputStream(is);){
            TarArchiveEntry directoryEntry = in.getNextTarEntry();
            Assert.assertEquals((Object)"directory/", (Object)directoryEntry.getName());
            Assert.assertTrue((boolean)directoryEntry.isDirectory());
            byte[] directoryRead = IOUtils.toByteArray((InputStream)in);
            Assert.assertArrayEquals((byte[])ByteUtils.EMPTY_BYTE_ARRAY, (byte[])directoryRead);
        }
    }

    @Test
    public void testTarFileDirectoryRead() throws IOException {
        File input = TarTestCase.getFile("directory.tar");
        try (TarFile tarFile = new TarFile(input);){
            TarArchiveEntry directoryEntry = (TarArchiveEntry)tarFile.getEntries().get(0);
            Assert.assertEquals((Object)"directory/", (Object)directoryEntry.getName());
            Assert.assertTrue((boolean)directoryEntry.isDirectory());
            try (InputStream directoryStream = tarFile.getInputStream(directoryEntry);){
                byte[] directoryRead = IOUtils.toByteArray((InputStream)directoryStream);
                Assert.assertArrayEquals((byte[])ByteUtils.EMPTY_BYTE_ARRAY, (byte[])directoryRead);
            }
        }
    }

    @Test
    public void testLongNameLargerThanBuffer() throws IOException {
        List<Integer> nameLength = Arrays.asList(300, 4096);
        for (Integer length : nameLength) {
            String fileName = this.createLongName(length);
            Assert.assertEquals((long)length.intValue(), (long)fileName.length());
            byte[] data = this.createTarWithOneLongNameEntry(fileName);
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            Throwable throwable = null;
            try {
                TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)bis);
                Throwable throwable2 = null;
                try {
                    Assert.assertEquals((Object)fileName, (Object)tis.getNextTarEntry().getName());
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (tis == null) continue;
                    if (throwable2 != null) {
                        try {
                            tis.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    tis.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (bis == null) continue;
                if (throwable != null) {
                    try {
                        bis.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                bis.close();
            }
        }
    }

    @Test
    public void testTarFileLongNameLargerThanBuffer() throws IOException {
        List<Integer> nameLength = Arrays.asList(300, 4096);
        for (Integer length : nameLength) {
            String fileName = this.createLongName(length);
            Assert.assertEquals((long)length.intValue(), (long)fileName.length());
            byte[] data = this.createTarWithOneLongNameEntry(fileName);
            TarFile tarFile = new TarFile(data);
            Throwable throwable = null;
            try {
                List entries = tarFile.getEntries();
                Assert.assertEquals((Object)fileName, (Object)((TarArchiveEntry)entries.get(0)).getName());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tarFile == null) continue;
                if (throwable != null) {
                    try {
                        tarFile.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tarFile.close();
            }
        }
    }

    private String createLongName(int nameLength) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < nameLength; ++i) {
            buffer.append('a');
        }
        return buffer.toString();
    }

    private byte[] createTarWithOneLongNameEntry(String longName) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);){
            tos.setLongFileMode(2);
            TarArchiveEntry longFileNameEntry = new TarArchiveEntry(longName);
            tos.putArchiveEntry((ArchiveEntry)longFileNameEntry);
            tos.closeArchiveEntry();
        }
        return bos.toByteArray();
    }
}

