/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.ColonPrefixNamedParamStatementRewriter;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterArgumentFactory;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;
import org.skife.jdbi.v2.tweak.StatementRewriter;

public class TestRegisterArgumentFactory {
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(String.format("jdbc:h2:mem:%s", UUID.randomUUID()));
        DBI dbi = new DBI((DataSource)ds);
        dbi.setStatementRewriter((StatementRewriter)new ColonPrefixNamedParamStatementRewriter());
        this.handle = dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testFoo() throws Exception {
        Waffle w = (Waffle)this.handle.attach(Waffle.class);
        w.insert(1, new Name("Brian", "McCallister"));
        Assert.assertThat((Object)w.findName(1), (Matcher)CoreMatchers.equalTo((Object)"Brian McCallister"));
    }

    public static class Name {
        private final String first;
        private final String last;

        public Name(String first, String last) {
            this.first = first;
            this.last = last;
        }

        public String getFullName() {
            return this.first + " " + this.last;
        }

        public String toString() {
            return "<Name first=" + this.first + " last=" + this.last + " >";
        }
    }

    public static class NameAF
    implements ArgumentFactory<Name> {
        public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
            return expectedType == Object.class && value instanceof Name;
        }

        public Argument build(Class<?> expectedType, final Name value, StatementContext ctx) {
            return new Argument(){

                public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
                    statement.setString(position, value.getFullName());
                }
            };
        }
    }

    @RegisterArgumentFactory(value={NameAF.class})
    public static interface Waffle {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") Name var2);

        @SqlQuery(value="select name from something where id = :id")
        public String findName(@Bind(value="id") int var1);
    }
}

