/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.mixins.GetHandle;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class TestReentrancy {
    private DBI dbi;
    private Handle handle;

    @Test
    public void testGetHandleProvidesSeperateHandle() throws Exception {
        TheBasics dao = (TheBasics)this.dbi.onDemand(TheBasics.class);
        Handle h = dao.getHandle();
        try {
            h.execute("insert into something (id, name) values (1, 'Stephen')", new Object[0]);
            Assert.fail((String)"should have raised exception, connection will be closed at this point");
        }
        catch (UnableToCreateStatementException unableToCreateStatementException) {
            // empty catch block
        }
    }

    @Test
    public void testHandleReentrant() throws Exception {
        final TheBasics dao = (TheBasics)this.dbi.onDemand(TheBasics.class);
        dao.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                dao.insert(new Something(7, "Martin"));
                handle.createQuery("SELECT 1").list();
                return null;
            }
        });
    }

    @Test
    public void testTxnReentrant() throws Exception {
        final TheBasics dao = (TheBasics)this.dbi.onDemand(TheBasics.class);
        dao.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                handle.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

                    public Void inTransaction(Handle conn, TransactionStatus status) throws Exception {
                        dao.insert(new Something(1, "x"));
                        List rs = conn.createQuery("select name from something where id = 1").map((ResultSetMapper)StringMapper.FIRST).list();
                        Assert.assertThat((Object)rs.size(), (Matcher)CoreMatchers.equalTo((Object)1));
                        conn.createQuery("SELECT 1").list();
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(String.format("jdbc:h2:mem:%s;MVCC=TRUE", UUID.randomUUID()));
        this.dbi = new DBI((DataSource)ds);
        this.dbi.registerMapper((ResultSetMapper)new SomethingMapper());
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    static interface TheBasics
    extends GetHandle {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public int insert(@BindBean Something var1);
    }
}

