/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.DefaultStatementBuilder;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.StatementBuilder;

public class TestTooManyCursors
extends DBITestCase {
    @Test
    public void testFoo() throws Exception {
        DataSource ds = DERBY_HELPER.getDataSource();
        ErrorProducingDataSource dataSource = new ErrorProducingDataSource(ds, 99);
        DBI dbi = new DBI((DataSource)dataSource);
        try {
            dbi.withHandle((HandleCallback)new HandleCallback<Object>(){

                public Void withHandle(Handle handle) throws Exception {
                    handle.setStatementBuilder((StatementBuilder)new DefaultStatementBuilder());
                    for (int idx = 0; idx < 100; ++idx) {
                        handle.createQuery("SELECT " + idx + " FROM something").first();
                    }
                    return null;
                }
            });
        }
        catch (CallbackFailedException e) {
            Assert.fail((String)"We have too many open connections");
        }
    }

    private static class StatementInvocationHandler
    implements InvocationHandler {
        private Statement stmt;
        private ConnectionInvocationHandler connectionHandler;

        public static Statement newInstance(Statement stmt, ConnectionInvocationHandler connectionHandler) {
            Class<?> o = stmt.getClass();
            ArrayList interfaces = new ArrayList();
            while (!o.equals(Object.class)) {
                interfaces.addAll(Arrays.asList(o.getInterfaces()));
                o = o.getSuperclass();
            }
            return (Statement)Proxy.newProxyInstance(stmt.getClass().getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)new StatementInvocationHandler(stmt, connectionHandler));
        }

        public StatementInvocationHandler(Statement stmt, ConnectionInvocationHandler connectionHandler) {
            this.stmt = stmt;
            this.connectionHandler = connectionHandler;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("close".equals(method.getName())) {
                this.connectionHandler.registerCloseStatement();
            }
            try {
                return method.invoke((Object)this.stmt, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private static class ConnectionInvocationHandler
    implements InvocationHandler {
        private Connection connection;
        private int numSuccessfulStatements;
        private int numStatements = 0;

        public static Connection newInstance(Connection connection, int numSuccessfulStatements) {
            return (Connection)Proxy.newProxyInstance(connection.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler(connection, numSuccessfulStatements));
        }

        public ConnectionInvocationHandler(Connection connection, int numSuccessfulStatements) {
            this.connection = connection;
            this.numSuccessfulStatements = numSuccessfulStatements;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if ("createStatement".equals(method.getName()) || "prepareCall".equals(method.getName()) || "prepareStatement".equals(method.getName())) {
                    if (++this.numStatements > this.numSuccessfulStatements) {
                        throw new SQLException("Fake 'maximum open cursors exceeded' error");
                    }
                    return StatementInvocationHandler.newInstance((Statement)method.invoke((Object)this.connection, args), this);
                }
                return method.invoke((Object)this.connection, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        public void registerCloseStatement() {
            --this.numStatements;
        }
    }

    private static class ErrorProducingDataSource
    implements DataSource {
        private final DataSource target;
        private final int connCount;

        ErrorProducingDataSource(DataSource target, int i) {
            this.target = target;
            this.connCount = i;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return ConnectionInvocationHandler.newInstance(this.target.getConnection(), this.connCount);
        }

        @Override
        public Connection getConnection(String string, String string1) throws SQLException {
            return ConnectionInvocationHandler.newInstance(this.target.getConnection(string, string1), this.connCount);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.target.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter printWriter) throws SQLException {
            this.target.setLogWriter(printWriter);
        }

        @Override
        public void setLoginTimeout(int i) throws SQLException {
            this.target.setLoginTimeout(i);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.target.getLoginTimeout();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new UnsupportedOperationException();
        }
    }
}

