/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.CachingStatementBuilder;
import org.skife.jdbi.v2.ClasspathStatementLocator;
import org.skife.jdbi.v2.ColonPrefixNamedParamStatementRewriter;
import org.skife.jdbi.v2.ContainerFactoryRegistry;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.DefaultStatementBuilder;
import org.skife.jdbi.v2.DelegatingConnection;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.MappingRegistry;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.logging.NoOpLog;
import org.skife.jdbi.v2.tweak.SQLLog;
import org.skife.jdbi.v2.tweak.StatementBuilder;
import org.skife.jdbi.v2.tweak.StatementLocator;
import org.skife.jdbi.v2.tweak.StatementRewriter;
import org.skife.jdbi.v2.tweak.TransactionHandler;
import org.skife.jdbi.v2.tweak.transactions.LocalTransactionHandler;

public class TestPreparedStatementCache
extends DBITestCase {
    @Test
    public void testSomething() throws Exception {
        final int[] prep_count = new int[]{0};
        DelegatingConnection c = new DelegatingConnection(DERBY_HELPER.getConnection()){

            public PreparedStatement prepareStatement(String s, int flag) throws SQLException {
                prep_count[0] = prep_count[0] + 1;
                return super.prepareStatement(s, flag);
            }

            public PreparedStatement prepareStatement(String s) throws SQLException {
                prep_count[0] = prep_count[0] + 1;
                return super.prepareStatement(s);
            }
        };
        CachingStatementBuilder builder = new CachingStatementBuilder((StatementBuilder)new DefaultStatementBuilder());
        BasicHandle h = new BasicHandle((TransactionHandler)new LocalTransactionHandler(), (StatementLocator)new ClasspathStatementLocator(), (StatementBuilder)builder, (StatementRewriter)new ColonPrefixNamedParamStatementRewriter(), (Connection)c, new HashMap(), (SQLLog)new NoOpLog(), TimingCollector.NOP_TIMING_COLLECTOR, new MappingRegistry(), new Foreman(), new ContainerFactoryRegistry());
        ((Update)h.createStatement("insert into something (id, name) values (:id, :name)").bindFromProperties((Object)new Something(0, "Keith"))).execute();
        Assert.assertEquals((long)1L, (long)prep_count[0]);
        ((Update)h.createStatement("insert into something (id, name) values (:id, :name)").bindFromProperties((Object)new Something(0, "Keith"))).execute();
        Assert.assertEquals((long)1L, (long)prep_count[0]);
    }
}

