/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.uri;

import java.net.MalformedURLException;
import java.net.URI;
import org.asynchttpclient.uri.Uri;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UriTest {
    private static void assertUriEquals(Uri uri, URI javaUri) {
        Assert.assertEquals((String)uri.getScheme(), (String)uri.getScheme());
        Assert.assertEquals((String)uri.getUserInfo(), (String)uri.getUserInfo());
        Assert.assertEquals((String)uri.getHost(), (String)uri.getHost());
        Assert.assertEquals((int)uri.getPort(), (int)uri.getPort());
        Assert.assertEquals((String)uri.getPath(), (String)uri.getPath());
        Assert.assertEquals((String)uri.getQuery(), (String)uri.getQuery());
    }

    private static void validateAgainstAbsoluteURI(String url) throws MalformedURLException {
        UriTest.assertUriEquals(Uri.create((String)url), URI.create(url));
    }

    private static void validateAgainstRelativeURI(String context, String url) throws MalformedURLException {
        UriTest.assertUriEquals(Uri.create((Uri)Uri.create((String)context), (String)url), URI.create(context).resolve(URI.create(url)));
    }

    @Test
    public void testSimpleParsing() throws MalformedURLException {
        UriTest.validateAgainstAbsoluteURI("https://graph.facebook.com/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testRootRelativeURIWithRootContext() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://graph.facebook.com", "/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testRootRelativeURIWithNonRootContext() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://graph.facebook.com/foo/bar", "/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testNonRootRelativeURIWithNonRootContext() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://graph.facebook.com/foo/bar", "750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testNonRootRelativeURIWithRootContext() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://graph.facebook.com", "750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testAbsoluteURIWithContext() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://hello.com/foo/bar", "https://graph.facebook.com/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testRelativeUriWithDots() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1/level2/", "../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithDotsAboveRoot() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1", "../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithAbsoluteDots() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1/", "/../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithConsecutiveDots() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1/level2/", "../../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsAboveRoot() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1/level2", "../../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithAbsoluteConsecutiveDots() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1/level2/", "/../../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromRoot() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://hello.com/", "../../../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromRootResource() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1", "../../../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromSubrootResource() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1/level2", "../../../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromLevel3Resource() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1/level2/level3", "../../../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithNoScheme() throws MalformedURLException {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1", "//world.org/content/img.png");
    }

    @Test
    public void testCreateAndToUrl() {
        String url = "https://hello.com/level1/level2/level3";
        Uri uri = Uri.create((String)url);
        Assert.assertEquals((String)uri.toUrl(), (String)url, (String)"url used to create uri and url returned from toUrl do not match");
    }

    @Test
    public void testToUrlWithUserInfoPortPathAndQuery() {
        Uri uri = new Uri("http", "user", "example.com", 44, "/path/path2", "query=4");
        Assert.assertEquals((String)uri.toUrl(), (String)"http://user@example.com:44/path/path2?query=4", (String)"toUrl returned incorrect url");
    }

    @Test
    public void testQueryWithNonRootPath() {
        Uri uri = Uri.create((String)"http://hello.com/foo?query=value");
        Assert.assertEquals((String)uri.getPath(), (String)"/foo");
        Assert.assertEquals((String)uri.getQuery(), (String)"query=value");
    }

    @Test
    public void testQueryWithNonRootPathAndTrailingSlash() {
        Uri uri = Uri.create((String)"http://hello.com/foo/?query=value");
        Assert.assertEquals((String)uri.getPath(), (String)"/foo/");
        Assert.assertEquals((String)uri.getQuery(), (String)"query=value");
    }

    @Test
    public void testQueryWithRootPath() {
        Uri uri = Uri.create((String)"http://hello.com?query=value");
        Assert.assertEquals((String)uri.getPath(), (String)"");
        Assert.assertEquals((String)uri.getQuery(), (String)"query=value");
    }

    @Test
    public void testQueryWithRootPathAndTrailingSlash() {
        Uri uri = Uri.create((String)"http://hello.com/?query=value");
        Assert.assertEquals((String)uri.getPath(), (String)"/");
        Assert.assertEquals((String)uri.getQuery(), (String)"query=value");
    }

    @Test
    public void testWithNewScheme() {
        Uri uri = new Uri("http", "user", "example.com", 44, "/path/path2", "query=4");
        Uri newUri = uri.withNewScheme("https");
        Assert.assertEquals((String)newUri.getScheme(), (String)"https");
        Assert.assertEquals((String)newUri.toUrl(), (String)"https://user@example.com:44/path/path2?query=4", (String)"toUrl returned incorrect url");
    }

    @Test
    public void testWithNewQuery() {
        Uri uri = new Uri("http", "user", "example.com", 44, "/path/path2", "query=4");
        Uri newUri = uri.withNewQuery("query2=10&query3=20");
        Assert.assertEquals((String)newUri.getQuery(), (String)"query2=10&query3=20");
        Assert.assertEquals((String)newUri.toUrl(), (String)"http://user@example.com:44/path/path2?query2=10&query3=20", (String)"toUrl returned incorrect url");
    }

    @Test
    public void testToRelativeUrl() {
        Uri uri = new Uri("http", "user", "example.com", 44, "/path/path2", "query=4");
        String relativeUrl = uri.toRelativeUrl();
        Assert.assertEquals((String)relativeUrl, (String)"/path/path2?query=4", (String)"toRelativeUrl returned incorrect url");
    }

    @Test
    public void testToRelativeUrlWithEmptyPath() {
        Uri uri = new Uri("http", "user", "example.com", 44, null, "query=4");
        String relativeUrl = uri.toRelativeUrl();
        Assert.assertEquals((String)relativeUrl, (String)"/?query=4", (String)"toRelativeUrl returned incorrect url");
    }

    @Test
    public void testGetSchemeDefaultPortHttpScheme() {
        String url = "https://hello.com/level1/level2/level3";
        Uri uri = Uri.create((String)url);
        Assert.assertEquals((int)uri.getSchemeDefaultPort(), (int)443, (String)"schema default port should be 443 for https url");
        String url2 = "http://hello.com/level1/level2/level3";
        Uri uri2 = Uri.create((String)url2);
        Assert.assertEquals((int)uri2.getSchemeDefaultPort(), (int)80, (String)"schema default port should be 80 for http url");
    }

    @Test
    public void testGetSchemeDefaultPortWebSocketScheme() {
        String url = "wss://hello.com/level1/level2/level3";
        Uri uri = Uri.create((String)url);
        Assert.assertEquals((int)uri.getSchemeDefaultPort(), (int)443, (String)"schema default port should be 443 for wss url");
        String url2 = "ws://hello.com/level1/level2/level3";
        Uri uri2 = Uri.create((String)url2);
        Assert.assertEquals((int)uri2.getSchemeDefaultPort(), (int)80, (String)"schema default port should be 80 for ws url");
    }

    @Test
    public void testGetExplicitPort() {
        String url = "http://hello.com/level1/level2/level3";
        Uri uri = Uri.create((String)url);
        Assert.assertEquals((int)uri.getExplicitPort(), (int)80, (String)"getExplicitPort should return port 80 for http url when port is not specified in url");
        String url2 = "http://hello.com:8080/level1/level2/level3";
        Uri uri2 = Uri.create((String)url2);
        Assert.assertEquals((int)uri2.getExplicitPort(), (int)8080, (String)"getExplicitPort should return the port given in the url");
    }

    @Test
    public void testEquals() {
        String url = "http://user@hello.com:8080/level1/level2/level3?q=1";
        Uri createdUri = Uri.create((String)url);
        Uri constructedUri = new Uri("http", "user", "hello.com", 8080, "/level1/level2/level3", "q=1");
        Assert.assertTrue((boolean)createdUri.equals((Object)constructedUri), (String)"The equals method returned false for two equal urls");
    }

    @Test
    public void testIsWebsocket() {
        String url = "http://user@hello.com:8080/level1/level2/level3?q=1";
        Uri uri = Uri.create((String)url);
        Assert.assertFalse((boolean)uri.isWebSocket(), (String)"isWebSocket should return false for http url");
        url = "https://user@hello.com:8080/level1/level2/level3?q=1";
        uri = Uri.create((String)url);
        Assert.assertFalse((boolean)uri.isWebSocket(), (String)"isWebSocket should return false for https url");
        url = "ws://user@hello.com:8080/level1/level2/level3?q=1";
        uri = Uri.create((String)url);
        Assert.assertTrue((boolean)uri.isWebSocket(), (String)"isWebSocket should return true for ws url");
        url = "wss://user@hello.com:8080/level1/level2/level3?q=1";
        uri = Uri.create((String)url);
        Assert.assertTrue((boolean)uri.isWebSocket(), (String)"isWebSocket should return true for wss url");
    }

    @Test
    public void creatingUriWithDefinedSchemeAndHostWorks() {
        Uri.create((String)"http://localhost");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void creatingUriWithMissingSchemeThrowsIllegalArgumentException() {
        Uri.create((String)"localhost");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void creatingUriWithMissingHostThrowsIllegalArgumentException() {
        Uri.create((String)"http://");
    }
}

