/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.generator;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.generator.FeedListener;
import org.asynchttpclient.request.body.generator.UnboundedQueueFeedableBodyGenerator;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FeedableBodyGeneratorTest {
    private UnboundedQueueFeedableBodyGenerator feedableBodyGenerator;
    private TestFeedListener listener;

    @BeforeMethod
    public void setUp() throws Exception {
        this.feedableBodyGenerator = new UnboundedQueueFeedableBodyGenerator();
        this.listener = new TestFeedListener();
        this.feedableBodyGenerator.setListener((FeedListener)this.listener);
    }

    @Test(groups={"standalone"})
    public void feedNotifiesListener() throws Exception {
        this.feedableBodyGenerator.feed(ByteBuffer.allocate(0), false);
        this.feedableBodyGenerator.feed(ByteBuffer.allocate(0), true);
        Assert.assertEquals((int)this.listener.getCalls(), (int)2);
    }

    @Test(groups={"standalone"})
    public void readingBytesReturnsFedContentWithoutChunkBoundaries() throws Exception {
        byte[] content = "Test123".getBytes(StandardCharsets.US_ASCII);
        this.feedableBodyGenerator.feed(ByteBuffer.wrap(content), true);
        Body body = this.feedableBodyGenerator.createBody();
        Assert.assertEquals((Object)this.readFromBody(body), (Object)"Test123".getBytes(StandardCharsets.US_ASCII));
        Assert.assertEquals((Object)body.transferTo(Unpooled.buffer((int)1)), (Object)Body.BodyState.STOP);
    }

    @Test(groups={"standalone"})
    public void returnZeroToSuspendStreamWhenNothingIsInQueue() throws Exception {
        byte[] content = "Test123".getBytes(StandardCharsets.US_ASCII);
        this.feedableBodyGenerator.feed(ByteBuffer.wrap(content), false);
        Body body = this.feedableBodyGenerator.createBody();
        Assert.assertEquals((Object)this.readFromBody(body), (Object)"Test123".getBytes(StandardCharsets.US_ASCII));
        Assert.assertEquals((Object)body.transferTo(Unpooled.buffer((int)1)), (Object)Body.BodyState.SUSPEND);
    }

    private byte[] readFromBody(Body body) throws IOException {
        ByteBuf byteBuf = Unpooled.buffer((int)512);
        body.transferTo(byteBuf);
        byte[] readBytes = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(readBytes);
        return readBytes;
    }

    private static class TestFeedListener
    implements FeedListener {
        private int calls;

        private TestFeedListener() {
        }

        public void onContentAdded() {
            ++this.calls;
        }

        public void onError(Throwable t) {
        }

        public int getCalls() {
            return this.calls;
        }
    }
}

