/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.ntlm;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Response;
import org.asynchttpclient.ntlm.NtlmEngine;
import org.asynchttpclient.ntlm.NtlmEngineException;
import org.asynchttpclient.util.Base64;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NtlmTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new NTLMHandler();
    }

    private Realm.Builder realmBuilderBase() {
        return Dsl.ntlmAuthRealm((String)"Zaphod", (String)"Beeblebrox").setNtlmDomain("Ursa-Minor").setNtlmHost("LightCity");
    }

    private void ntlmAuthTest(Realm.Builder realmBuilder) throws IOException, InterruptedException, ExecutionException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRealm(realmBuilder));){
            ListenableFuture responseFuture = client.executeRequest(Dsl.get((String)this.getTargetUrl()));
            int status = ((Response)responseFuture.get()).getStatusCode();
            Assert.assertEquals((int)status, (int)200);
        }
    }

    @Test(groups={"standalone"})
    public void lazyNTLMAuthTest() throws IOException, InterruptedException, ExecutionException {
        this.ntlmAuthTest(this.realmBuilderBase());
    }

    @Test(groups={"standalone"})
    public void preemptiveNTLMAuthTest() throws IOException, InterruptedException, ExecutionException {
        this.ntlmAuthTest(this.realmBuilderBase().setUsePreemptiveAuth(true));
    }

    @Test
    public void testGenerateType1Msg() {
        NtlmEngine engine = new NtlmEngine();
        String message = engine.generateType1Msg();
        Assert.assertEquals((String)message, (String)"TlRMTVNTUAABAAAAAYIIogAAAAAoAAAAAAAAACgAAAAFASgKAAAADw==", (String)"Incorrect type1 message generated");
    }

    @Test(expectedExceptions={NtlmEngineException.class})
    public void testGenerateType3MsgThrowsExceptionWhenChallengeTooShort() {
        NtlmEngine engine = new NtlmEngine();
        engine.generateType3Msg("username", "password", "localhost", "workstation", Base64.encode((byte[])"a".getBytes()));
        Assert.fail((String)"An NtlmEngineException must have occurred as challenge length is too short");
    }

    @Test(expectedExceptions={NtlmEngineException.class})
    public void testGenerateType3MsgThrowsExceptionWhenChallengeDoesNotFollowCorrectFormat() {
        NtlmEngine engine = new NtlmEngine();
        engine.generateType3Msg("username", "password", "localhost", "workstation", Base64.encode((byte[])"challenge".getBytes()));
        Assert.fail((String)"An NtlmEngineException must have occurred as challenge format is not correct");
    }

    private static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    @Test(expectedExceptions={NtlmEngineException.class})
    public void testGenerateType3MsgThworsExceptionWhenType2IndicatorNotPresent() throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        buf.write("NTLMSSP".getBytes(StandardCharsets.US_ASCII));
        buf.write(0);
        buf.write(3);
        buf.write(0);
        buf.write(0);
        buf.write(0);
        buf.write("challenge".getBytes());
        NtlmEngine engine = new NtlmEngine();
        engine.generateType3Msg("username", "password", "localhost", "workstation", Base64.encode((byte[])buf.toByteArray()));
        buf.close();
        Assert.fail((String)"An NtlmEngineException must have occurred as type 2 indicator is incorrect");
    }

    @Test(expectedExceptions={NtlmEngineException.class})
    public void testGenerateType3MsgThrowsExceptionWhenUnicodeSupportNotIndicated() throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        buf.write("NTLMSSP".getBytes(StandardCharsets.US_ASCII));
        buf.write(0);
        buf.write(2);
        buf.write(0);
        buf.write(0);
        buf.write(0);
        buf.write(NtlmTest.longToBytes(1L));
        buf.write(0);
        buf.write(0);
        buf.write(0);
        buf.write(0);
        buf.write(NtlmTest.longToBytes(1L));
        NtlmEngine engine = new NtlmEngine();
        engine.generateType3Msg("username", "password", "localhost", "workstation", Base64.encode((byte[])buf.toByteArray()));
        buf.close();
        Assert.fail((String)"An NtlmEngineException must have occurred as unicode support is not indicated");
    }

    @Test(groups={"standalone"})
    public void testGenerateType2Msg() {
        NtlmEngine.Type2Message type2Message = new NtlmEngine.Type2Message("TlRMTVNTUAACAAAAAAAAACgAAAABggAAU3J2Tm9uY2UAAAAAAAAAAA==");
        Assert.assertEquals((int)type2Message.getMessageLength(), (int)40, (String)"This is a sample challenge that should return 40");
    }

    @Test
    public void testGenerateType3Msg() throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        buf.write("NTLMSSP".getBytes(StandardCharsets.US_ASCII));
        buf.write(0);
        buf.write(2);
        buf.write(0);
        buf.write(0);
        buf.write(0);
        buf.write(NtlmTest.longToBytes(0L));
        buf.write(1);
        buf.write(0);
        buf.write(0);
        buf.write(0);
        buf.write(NtlmTest.longToBytes(1L));
        NtlmEngine engine = new NtlmEngine();
        String type3Msg = engine.generateType3Msg("username", "password", "localhost", "workstation", Base64.encode((byte[])buf.toByteArray()));
        buf.close();
        Assert.assertEquals((String)type3Msg, (String)"TlRMTVNTUAADAAAAGAAYAEgAAAAYABgAYAAAABIAEgB4AAAAEAAQAIoAAAAWABYAmgAAAAAAAACwAAAAAQAAAgUBKAoAAAAP1g6lqqN1HZ0wSSxeQ5riQkyh7/UexwVlCPQm0SHU2vsDQm2wM6NbT2zPonPzLJL0TABPAEMAQQBMAEgATwBTAFQAdQBzAGUAcgBuAGEAbQBlAFcATwBSAEsAUwBUAEEAVABJAE8ATgA=", (String)"Incorrect type3 message generated");
    }

    @Test
    public void testWriteULong() {
        byte[] buffer = new byte[4];
        NtlmEngine.writeULong((byte[])buffer, (int)1, (int)0);
        Assert.assertEquals((Object)buffer, (Object)new byte[]{1, 0, 0, 0}, (String)"Unsigned long value 1 was not written correctly to the buffer");
        buffer = new byte[4];
        NtlmEngine.writeULong((byte[])buffer, (int)257, (int)0);
        Assert.assertEquals((Object)buffer, (Object)new byte[]{1, 1, 0, 0}, (String)"Unsigned long value 257 was not written correctly to the buffer");
        buffer = new byte[4];
        NtlmEngine.writeULong((byte[])buffer, (int)0x1000000, (int)0);
        Assert.assertEquals((Object)buffer, (Object)new byte[]{0, 0, 0, 1}, (String)"Unsigned long value 16777216 was not written correctly to the buffer");
    }

    public static class NTLMHandler
    extends AbstractHandler {
        public void handle(String pathInContext, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            String authorization = httpRequest.getHeader("Authorization");
            if (authorization == null) {
                httpResponse.setStatus(401);
                httpResponse.setHeader("WWW-Authenticate", "NTLM");
            } else if (authorization.equals("NTLM TlRMTVNTUAABAAAAAYIIogAAAAAoAAAAAAAAACgAAAAFASgKAAAADw==")) {
                httpResponse.setStatus(401);
                httpResponse.setHeader("WWW-Authenticate", "NTLM TlRMTVNTUAACAAAAAAAAACgAAAABggAAU3J2Tm9uY2UAAAAAAAAAAA==");
            } else if (authorization.equals("NTLM TlRMTVNTUAADAAAAGAAYAEgAAAAYABgAYAAAABQAFAB4AAAADAAMAIwAAAASABIAmAAAAAAAAACqAAAAAYIAAgUBKAoAAAAPrYfKbe/jRoW5xDxHeoxC1gBmfWiS5+iX4OAN4xBKG/IFPwfH3agtPEia6YnhsADTVQBSAFMAQQAtAE0ASQBOAE8AUgBaAGEAcABoAG8AZABMAEkARwBIAFQAQwBJAFQAWQA=")) {
                httpResponse.setStatus(200);
            } else {
                httpResponse.setStatus(401);
            }
            httpResponse.setContentLength(0);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

