/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NettyResponseFutureTest {
    @Test
    public void testCancel() {
        AsyncHandler asyncHandler = (AsyncHandler)Mockito.mock(AsyncHandler.class);
        NettyResponseFuture nettyResponseFuture = new NettyResponseFuture(null, asyncHandler, null, 3, null, null);
        boolean result = nettyResponseFuture.cancel(false);
        ((AsyncHandler)Mockito.verify((Object)asyncHandler)).onThrowable((Throwable)Mockito.anyObject());
        Assert.assertTrue((boolean)result, (String)"Cancel should return true if the Future was cancelled successfully");
        Assert.assertTrue((boolean)nettyResponseFuture.isCancelled(), (String)"isCancelled should return true for a cancelled Future");
    }

    @Test
    public void testCancelOnAlreadyCancelled() {
        AsyncHandler asyncHandler = (AsyncHandler)Mockito.mock(AsyncHandler.class);
        NettyResponseFuture nettyResponseFuture = new NettyResponseFuture(null, asyncHandler, null, 3, null, null);
        nettyResponseFuture.cancel(false);
        boolean result = nettyResponseFuture.cancel(false);
        Assert.assertFalse((boolean)result, (String)"cancel should return false for an already cancelled Future");
        Assert.assertTrue((boolean)nettyResponseFuture.isCancelled(), (String)"isCancelled should return true for a cancelled Future");
    }

    @Test(expectedExceptions={CancellationException.class})
    public void testGetContentThrowsCancellationExceptionIfCancelled() throws InterruptedException, ExecutionException {
        AsyncHandler asyncHandler = (AsyncHandler)Mockito.mock(AsyncHandler.class);
        NettyResponseFuture nettyResponseFuture = new NettyResponseFuture(null, asyncHandler, null, 3, null, null);
        nettyResponseFuture.cancel(false);
        nettyResponseFuture.get();
        Assert.fail((String)"A CancellationException must have occurred by now as 'cancel' was called before 'get'");
    }

    @Test
    public void testGet() throws Exception {
        AsyncHandler asyncHandler = (AsyncHandler)Mockito.mock(AsyncHandler.class);
        Object value = new Object();
        Mockito.when((Object)asyncHandler.onCompleted()).thenReturn(value);
        NettyResponseFuture nettyResponseFuture = new NettyResponseFuture(null, asyncHandler, null, 3, null, null);
        nettyResponseFuture.done();
        Object result = nettyResponseFuture.get();
        Assert.assertEquals((Object)result, (Object)value, (String)"The Future should return the value given by asyncHandler#onCompleted");
    }

    @Test(expectedExceptions={ExecutionException.class})
    public void testGetThrowsExceptionThrownByAsyncHandler() throws Exception {
        AsyncHandler asyncHandler = (AsyncHandler)Mockito.mock(AsyncHandler.class);
        Mockito.when((Object)asyncHandler.onCompleted()).thenThrow(new Throwable[]{new RuntimeException()});
        NettyResponseFuture nettyResponseFuture = new NettyResponseFuture(null, asyncHandler, null, 3, null, null);
        nettyResponseFuture.done();
        nettyResponseFuture.get();
        Assert.fail((String)"An ExecutionException must have occurred by now as asyncHandler threw an exception in 'onCompleted'");
    }

    @Test(expectedExceptions={ExecutionException.class})
    public void testGetThrowsExceptionOnAbort() throws InterruptedException, ExecutionException {
        AsyncHandler asyncHandler = (AsyncHandler)Mockito.mock(AsyncHandler.class);
        NettyResponseFuture nettyResponseFuture = new NettyResponseFuture(null, asyncHandler, null, 3, null, null);
        nettyResponseFuture.abort((Throwable)new RuntimeException());
        nettyResponseFuture.get();
        Assert.fail((String)"An ExecutionException must have occurred by now as 'abort' was called before 'get'");
    }
}

