/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.FilterException;
import org.asynchttpclient.filter.RequestFilter;
import org.asynchttpclient.filter.ResponseFilter;
import org.asynchttpclient.filter.ThrottleRequestFilter;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FilterTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new BasicHandler();
    }

    @Override
    public String getTargetUrl() {
        return String.format("http://localhost:%d/foo/test", this.port1);
    }

    @Test(groups={"standalone"})
    public void basicTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().addRequestFilter((RequestFilter)new ThrottleRequestFilter(100)));){
            Response response = (Response)c.preparePost(this.getTargetUrl()).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone"})
    public void loadThrottleTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().addRequestFilter((RequestFilter)new ThrottleRequestFilter(10)));){
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
            for (int i = 0; i < 200; ++i) {
                futures.add(c.preparePost(this.getTargetUrl()).execute());
            }
            for (Future future : futures) {
                Response r = (Response)future.get();
                Assert.assertNotNull(future.get());
                Assert.assertEquals((int)r.getStatusCode(), (int)200);
            }
        }
    }

    @Test(groups={"standalone"})
    public void maxConnectionsText() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().addRequestFilter((RequestFilter)new ThrottleRequestFilter(0, 1000)));){
            c.preparePost(this.getTargetUrl()).execute().get();
            Assert.fail((String)"Should have timed out");
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof FilterException));
        }
    }

    @Test(groups={"standalone"})
    public void basicResponseFilterTest() throws Exception {
        ResponseFilter responseFilter = new ResponseFilter(){

            public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
                return ctx;
            }
        };
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().addResponseFilter(responseFilter));){
            Response response = (Response)c.preparePost(this.getTargetUrl()).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone"})
    public void replayResponseFilterTest() throws Exception {
        final AtomicBoolean replay = new AtomicBoolean(true);
        ResponseFilter responseFilter = new ResponseFilter(){

            public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
                if (replay.getAndSet(false)) {
                    Request request = ((RequestBuilder)new RequestBuilder(ctx.getRequest()).addHeader((CharSequence)"X-Replay", "true")).build();
                    return new FilterContext.FilterContextBuilder().asyncHandler(ctx.getAsyncHandler()).request(request).replayRequest(true).build();
                }
                return ctx;
            }
        };
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().addResponseFilter(responseFilter));){
            Response response = (Response)c.preparePost(this.getTargetUrl()).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getHeader("X-Replay"), (String)"true");
        }
    }

    @Test(groups={"standalone"})
    public void replayStatusCodeResponseFilterTest() throws Exception {
        final AtomicBoolean replay = new AtomicBoolean(true);
        ResponseFilter responseFilter = new ResponseFilter(){

            public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
                if (ctx.getResponseStatus() != null && ctx.getResponseStatus().getStatusCode() == 200 && replay.getAndSet(false)) {
                    Request request = ((RequestBuilder)new RequestBuilder(ctx.getRequest()).addHeader((CharSequence)"X-Replay", "true")).build();
                    return new FilterContext.FilterContextBuilder().asyncHandler(ctx.getAsyncHandler()).request(request).replayRequest(true).build();
                }
                return ctx;
            }
        };
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().addResponseFilter(responseFilter));){
            Response response = (Response)c.preparePost(this.getTargetUrl()).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getHeader("X-Replay"), (String)"true");
        }
    }

    @Test(groups={"standalone"})
    public void replayHeaderResponseFilterTest() throws Exception {
        final AtomicBoolean replay = new AtomicBoolean(true);
        ResponseFilter responseFilter = new ResponseFilter(){

            public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
                if (ctx.getResponseHeaders() != null && ctx.getResponseHeaders().getHeaders().get("Ping").equals("Pong") && replay.getAndSet(false)) {
                    Request request = ((RequestBuilder)new RequestBuilder(ctx.getRequest()).addHeader((CharSequence)"Ping", "Pong")).build();
                    return new FilterContext.FilterContextBuilder().asyncHandler(ctx.getAsyncHandler()).request(request).replayRequest(true).build();
                }
                return ctx;
            }
        };
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().addResponseFilter(responseFilter));){
            Response response = (Response)((BoundRequestBuilder)c.preparePost(this.getTargetUrl()).addHeader((CharSequence)"Ping", "Pong")).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getHeader("Ping"), (String)"Pong");
        }
    }

    private static class BasicHandler
    extends AbstractHandler {
        private BasicHandler() {
        }

        public void handle(String s, org.eclipse.jetty.server.Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            Enumeration e = httpRequest.getHeaderNames();
            while (e.hasMoreElements()) {
                String param = e.nextElement().toString();
                httpResponse.addHeader(param, httpRequest.getHeader(param));
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

