/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.cookie;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.asynchttpclient.cookie.DateParser;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DateParserTest {
    @Test(groups={"standalone"})
    public void testRFC822() throws ParseException {
        Date date = DateParser.parse((String)"Sun, 06 Nov 1994 08:49:37 GMT");
        Assert.assertNotNull((Object)date);
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(date);
        Assert.assertEquals((int)cal.get(7), (int)1);
        Assert.assertEquals((int)cal.get(5), (int)6);
        Assert.assertEquals((int)cal.get(2), (int)10);
        Assert.assertEquals((int)cal.get(1), (int)1994);
        Assert.assertEquals((int)cal.get(10), (int)8);
        Assert.assertEquals((int)cal.get(12), (int)49);
        Assert.assertEquals((int)cal.get(13), (int)37);
    }

    @Test(groups={"standalone"})
    public void testRFC822SingleDigitDayOfMonth() throws ParseException {
        Date date = DateParser.parse((String)"Sun, 6 Nov 1994 08:49:37 GMT");
        Assert.assertNotNull((Object)date);
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(date);
        Assert.assertEquals((int)cal.get(7), (int)1);
        Assert.assertEquals((int)cal.get(5), (int)6);
        Assert.assertEquals((int)cal.get(2), (int)10);
        Assert.assertEquals((int)cal.get(1), (int)1994);
        Assert.assertEquals((int)cal.get(10), (int)8);
        Assert.assertEquals((int)cal.get(12), (int)49);
        Assert.assertEquals((int)cal.get(13), (int)37);
    }

    @Test(groups={"standalone"})
    public void testRFC822SingleDigitHour() throws ParseException {
        Date date = DateParser.parse((String)"Sun, 6 Nov 1994 8:49:37 GMT");
        Assert.assertNotNull((Object)date);
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(date);
        Assert.assertEquals((int)cal.get(7), (int)1);
        Assert.assertEquals((int)cal.get(5), (int)6);
        Assert.assertEquals((int)cal.get(2), (int)10);
        Assert.assertEquals((int)cal.get(1), (int)1994);
        Assert.assertEquals((int)cal.get(10), (int)8);
        Assert.assertEquals((int)cal.get(12), (int)49);
        Assert.assertEquals((int)cal.get(13), (int)37);
    }

    @Test(groups={"standalone"})
    public void testRFC850() throws ParseException {
        Date date = DateParser.parse((String)"Saturday, 06-Nov-94 08:49:37 GMT");
        Assert.assertNotNull((Object)date);
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(date);
        Assert.assertEquals((int)cal.get(7), (int)7);
        Assert.assertEquals((int)cal.get(5), (int)6);
        Assert.assertEquals((int)cal.get(2), (int)10);
        Assert.assertEquals((int)cal.get(1), (int)2094);
        Assert.assertEquals((int)cal.get(10), (int)8);
        Assert.assertEquals((int)cal.get(12), (int)49);
        Assert.assertEquals((int)cal.get(13), (int)37);
    }

    @Test(groups={"standalone"})
    public void testANSIC() throws ParseException {
        Date date = DateParser.parse((String)"Sun Nov 6 08:49:37 1994");
        Assert.assertNotNull((Object)date);
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(date);
        Assert.assertEquals((int)cal.get(7), (int)1);
        Assert.assertEquals((int)cal.get(5), (int)6);
        Assert.assertEquals((int)cal.get(2), (int)10);
        Assert.assertEquals((int)cal.get(1), (int)1994);
        Assert.assertEquals((int)cal.get(10), (int)8);
        Assert.assertEquals((int)cal.get(12), (int)49);
        Assert.assertEquals((int)cal.get(13), (int)37);
    }
}

