/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.net.ConnectException;
import java.util.Enumeration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.TestUtils;
import org.asynchttpclient.uri.Uri;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class PerRequestRelative302Test
extends AbstractBasicTest {
    private final AtomicBoolean isSet = new AtomicBoolean(false);

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        ServerConnector connector = TestUtils.addHttpConnector(this.server);
        this.server.setHandler((Handler)new Relative302Handler());
        this.server.start();
        this.port1 = connector.getLocalPort();
        this.logger.info("Local HTTP server started successfully");
        this.port2 = TestUtils.findFreePort();
    }

    @Test(groups={"online"})
    public void runAllSequentiallyBecauseNotThreadSafe() throws Exception {
        this.redirected302Test();
        this.notRedirected302Test();
        this.relativeLocationUrl();
        this.redirected302InvalidTest();
    }

    public void redirected302Test() throws Exception {
        this.isSet.getAndSet(false);
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)c.prepareGet(this.getTargetUrl()).setFollowRedirect(true)).setHeader((CharSequence)"X-redirect", "https://www.microsoft.com/")).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            String anyMicrosoftPage = "https://www.microsoft.com[^:]*:443";
            String baseUrl = this.getBaseUrl(response.getUri());
            Assert.assertTrue((boolean)baseUrl.matches(anyMicrosoftPage), (String)("response does not show redirection to " + anyMicrosoftPage));
        }
    }

    public void notRedirected302Test() throws Exception {
        this.isSet.getAndSet(false);
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true));){
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)c.prepareGet(this.getTargetUrl()).setFollowRedirect(false)).setHeader((CharSequence)"X-redirect", "http://www.microsoft.com/")).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)302);
        }
    }

    private String getBaseUrl(Uri uri) {
        String url = uri.toString();
        int port = uri.getPort();
        if (port == -1) {
            port = PerRequestRelative302Test.getPort(uri);
            url = url.substring(0, url.length() - 1) + ":" + port;
        }
        return url.substring(0, url.lastIndexOf(":") + String.valueOf(port).length() + 1);
    }

    private static int getPort(Uri uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = uri.getScheme().equals("http") ? 80 : 443;
        }
        return port;
    }

    public void redirected302InvalidTest() throws Exception {
        this.isSet.getAndSet(false);
        ExecutionException e = null;
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            ((BoundRequestBuilder)((BoundRequestBuilder)c.preparePost(this.getTargetUrl()).setFollowRedirect(true)).setHeader((CharSequence)"X-redirect", String.format("http://localhost:%d/", this.port2))).execute().get();
        }
        catch (ExecutionException ex) {
            e = ex;
        }
        Assert.assertNotNull((Object)e);
        Throwable cause = e.getCause();
        Assert.assertTrue((boolean)(cause instanceof ConnectException));
        Assert.assertTrue((boolean)cause.getMessage().contains(":" + this.port2));
    }

    public void relativeLocationUrl() throws Exception {
        this.isSet.getAndSet(false);
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)c.preparePost(this.getTargetUrl()).setFollowRedirect(true)).setHeader((CharSequence)"X-redirect", "/foo/test")).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getUri().toString(), (String)this.getTargetUrl());
        }
    }

    private class Relative302Handler
    extends AbstractHandler {
        private Relative302Handler() {
        }

        public void handle(String s, Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            httpResponse.setContentType("text/html;charset=UTF-8");
            Enumeration e = httpRequest.getHeaderNames();
            while (e.hasMoreElements()) {
                String param = e.nextElement().toString();
                if (!param.startsWith("X-redirect") || PerRequestRelative302Test.this.isSet.getAndSet(true)) continue;
                httpResponse.addHeader("Location", httpRequest.getHeader(param));
                httpResponse.setStatus(302);
                httpResponse.getOutputStream().flush();
                httpResponse.getOutputStream().close();
                return;
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

