/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ErrorResponseTest
extends AbstractBasicTest {
    static final String BAD_REQUEST_STR = "Very Bad Request! No cookies.";

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new ErrorHandler();
    }

    @Test(groups={"standalone"})
    public void testQueryParameters() throws Exception {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)client.prepareGet("http://localhost:" + this.port1 + "/foo").addHeader((CharSequence)"Accepts", "*/*")).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)400);
            Assert.assertEquals((String)resp.getResponseBody(), (String)BAD_REQUEST_STR);
        }
    }

    private static class ErrorHandler
    extends AbstractHandler {
        private ErrorHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            try {
                Thread.sleep(210L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            response.setContentType("text/plain");
            response.setStatus(400);
            ServletOutputStream out = response.getOutputStream();
            out.write(ErrorResponseTest.BAD_REQUEST_STR.getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
    }
}

