/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test.concurrent;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Properties;
import org.apache.hive.druid.org.apache.calcite.test.concurrent.ConcurrentTestCommand;
import org.apache.hive.druid.org.apache.calcite.test.concurrent.ConcurrentTestCommandGenerator;
import org.apache.hive.druid.org.apache.calcite.util.Unsafe;

class ConcurrentTestCommandExecutor
extends Thread {
    private Integer threadId;
    private String jdbcURL;
    private Properties jdbcProps;
    private Iterable<ConcurrentTestCommand> commands;
    private Sync synchronizer;
    private Connection connection;
    private Statement statement;
    private Throwable error;
    private String when;
    private final PrintStream debugPrintStream;
    private ConcurrentTestCommand errorCommand;

    ConcurrentTestCommandExecutor(int threadId, String threadName, String jdbcURL, Properties jdbcProps, Iterable<ConcurrentTestCommand> commands, Sync synchronizer, PrintStream debugPrintStream) {
        this.threadId = threadId;
        this.jdbcURL = jdbcURL;
        this.jdbcProps = jdbcProps;
        this.commands = commands;
        this.synchronizer = synchronizer;
        this.debugPrintStream = debugPrintStream;
        this.setName("Command Executor " + threadName);
    }

    @Override
    public void run() {
        try {
            this.connection = DriverManager.getConnection(this.jdbcURL, this.jdbcProps);
            if (this.connection.getMetaData().supportsTransactions()) {
                this.connection.setAutoCommit(false);
            }
        }
        catch (Throwable t) {
            this.handleError(t, "during connect", null);
        }
        int stepNumber = 0;
        for (ConcurrentTestCommand command : this.commands) {
            boolean isSync;
            if (!(command instanceof ConcurrentTestCommandGenerator.AutoSynchronizationCommand)) {
                ++stepNumber;
            }
            if (!(isSync = command instanceof ConcurrentTestCommandGenerator.SynchronizationCommand) && (this.connection == null || command == null || this.error != null)) continue;
            try {
                command.execute(this);
            }
            catch (Throwable t) {
                this.handleError(t, "during step " + stepNumber, command);
            }
        }
        try {
            if (this.connection != null) {
                if (this.connection.getMetaData().supportsTransactions()) {
                    this.connection.rollback();
                }
                this.connection.close();
            }
        }
        catch (Throwable t) {
            this.handleError(t, "during connection close", null);
        }
    }

    private void handleError(Throwable error, String when, ConcurrentTestCommand command) {
        this.error = error;
        this.when = when;
        this.errorCommand = command;
        if (this.debugPrintStream != null) {
            this.debugPrintStream.println(Thread.currentThread().getName() + ": " + when);
            error.printStackTrace(this.debugPrintStream);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement stmt) {
        assert (this.statement == null);
        this.statement = stmt;
    }

    public void clearStatement() {
        this.statement = null;
    }

    public Sync getSynchronizer() {
        return this.synchronizer;
    }

    public Throwable getFailureCause() {
        return this.error;
    }

    public String getFailureLocation() {
        return this.when;
    }

    public ConcurrentTestCommand getFailureCommand() {
        return this.errorCommand;
    }

    public Integer getThreadId() {
        return this.threadId;
    }

    public static class Sync {
        private int numThreads;
        private int numWaiting;

        Sync(int numThreads) {
            assert (numThreads > 0);
            this.numThreads = numThreads;
            this.numWaiting = 0;
        }

        synchronized void waitForOthers() throws InterruptedException {
            if (++this.numWaiting == this.numThreads) {
                this.numWaiting = 0;
                Unsafe.notifyAll((Object)this);
            } else {
                Unsafe.wait((Object)this);
            }
        }
    }
}

