/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.calcite.DataContext;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.hive.druid.org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.hive.druid.org.apache.calcite.linq4j.Enumerable;
import org.apache.hive.druid.org.apache.calcite.linq4j.Enumerator;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.schema.FilterableTable;
import org.apache.hive.druid.org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.hive.druid.org.apache.calcite.schema.ScannableTable;
import org.apache.hive.druid.org.apache.calcite.schema.Schema;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaPlus;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.hive.druid.org.apache.calcite.schema.impl.AbstractTable;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.test.CalciteAssert;
import org.apache.hive.druid.org.apache.calcite.test.Matchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ScannableTableTest {
    private static final Object[][] BEATLES = new Object[][]{{4, "John", 1940}, {4, "Paul", 1942}, {6, "George", 1943}, {5, "Ringo", 1940}};

    @Test
    public void testTens() throws SQLException {
        Enumerator<Object[]> cursor = ScannableTableTest.tens();
        Assert.assertTrue((boolean)cursor.moveNext());
        Assert.assertThat((Object)((Object[])cursor.current())[0], (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)((Object[])cursor.current()).length, (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertTrue((boolean)cursor.moveNext());
        Assert.assertThat((Object)((Object[])cursor.current())[0], (Matcher)CoreMatchers.equalTo((Object)10));
        Assert.assertTrue((boolean)cursor.moveNext());
        Assert.assertThat((Object)((Object[])cursor.current())[0], (Matcher)CoreMatchers.equalTo((Object)20));
        Assert.assertTrue((boolean)cursor.moveNext());
        Assert.assertThat((Object)((Object[])cursor.current())[0], (Matcher)CoreMatchers.equalTo((Object)30));
        Assert.assertFalse((boolean)cursor.moveNext());
    }

    @Test
    public void testSimple() throws Exception {
        CalciteAssert.that().with(this.newSchema("s", "simple", (Table)new SimpleTable())).query("select * from \"s\".\"simple\"").returnsUnordered("i=0", "i=10", "i=20", "i=30");
    }

    @Test
    public void testSimple2() throws Exception {
        CalciteAssert.that().with(this.newSchema("s", "beatles", (Table)new BeatlesTable())).query("select * from \"s\".\"beatles\"").returnsUnordered("i=4; j=John", "i=4; j=Paul", "i=6; j=George", "i=5; j=Ringo");
    }

    @Test
    public void testFilterableTableCooperative() throws Exception {
        StringBuilder buf = new StringBuilder();
        BeatlesFilterableTable table = new BeatlesFilterableTable(buf, true);
        String explain = "PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles]], filters=[[=($0, 4)]])";
        CalciteAssert.that().with(this.newSchema("s", "beatles", (Table)table)).query("select * from \"s\".\"beatles\" where \"i\" = 4").explainContains("PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles]], filters=[[=($0, 4)]])").returnsUnordered("i=4; j=John; k=1940", "i=4; j=Paul; k=1942");
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.is((Object)"returnCount=2, filter=4"));
    }

    @Test
    public void testFilterableTableNonCooperative() throws Exception {
        StringBuilder buf = new StringBuilder();
        BeatlesFilterableTable table = new BeatlesFilterableTable(buf, false);
        String explain = "PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles2]], filters=[[=($0, 4)]])";
        CalciteAssert.that().with(this.newSchema("s", "beatles2", (Table)table)).query("select * from \"s\".\"beatles2\" where \"i\" = 4").explainContains("PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles2]], filters=[[=($0, 4)]])").returnsUnordered("i=4; j=John; k=1940", "i=4; j=Paul; k=1942");
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.is((Object)"returnCount=4"));
    }

    @Test
    public void testProjectableFilterableCooperative() throws Exception {
        StringBuilder buf = new StringBuilder();
        BeatlesProjectableFilterableTable table = new BeatlesProjectableFilterableTable(buf, true);
        String explain = "PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles]], filters=[[=($0, 4)]], projects=[[1]])";
        CalciteAssert.that().with(this.newSchema("s", "beatles", (Table)table)).query("select \"j\" from \"s\".\"beatles\" where \"i\" = 4").explainContains("PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles]], filters=[[=($0, 4)]], projects=[[1]])").returnsUnordered("j=John", "j=Paul");
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.is((Object)"returnCount=2, filter=4, projects=[1]"));
    }

    @Test
    public void testProjectableFilterableNonCooperative() throws Exception {
        StringBuilder buf = new StringBuilder();
        BeatlesProjectableFilterableTable table = new BeatlesProjectableFilterableTable(buf, false);
        String explain = "PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles2]], filters=[[=($0, 4)]], projects=[[1]]";
        CalciteAssert.that().with(this.newSchema("s", "beatles2", (Table)table)).query("select \"j\" from \"s\".\"beatles2\" where \"i\" = 4").explainContains("PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles2]], filters=[[=($0, 4)]], projects=[[1]]").returnsUnordered("j=John", "j=Paul");
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.is((Object)"returnCount=4, projects=[1, 0]"));
    }

    @Test
    public void testProjectableFilterableWithProjectAndFilter() throws Exception {
        StringBuilder buf = new StringBuilder();
        BeatlesProjectableFilterableTable table = new BeatlesProjectableFilterableTable(buf, true);
        String explain = "PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles]], filters=[[=($0, 4)]], projects=[[2, 1]]";
        CalciteAssert.that().with(this.newSchema("s", "beatles", (Table)table)).query("select \"k\",\"j\" from \"s\".\"beatles\" where \"i\" = 4").explainContains("PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles]], filters=[[=($0, 4)]], projects=[[2, 1]]").returnsUnordered("k=1940; j=John", "k=1942; j=Paul");
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.is((Object)"returnCount=2, filter=4, projects=[2, 1]"));
    }

    @Test
    public void testProjectableFilterableWithProjectFilterNonCooperative() throws Exception {
        StringBuilder buf = new StringBuilder();
        BeatlesProjectableFilterableTable table = new BeatlesProjectableFilterableTable(buf, false);
        String explain = "PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles]], filters=[[>($2, 1941)]], projects=[[0, 2]])";
        CalciteAssert.that().with(this.newSchema("s", "beatles", (Table)table)).query("select \"i\",\"k\" from \"s\".\"beatles\" where \"k\" > 1941").explainContains("PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles]], filters=[[>($2, 1941)]], projects=[[0, 2]])").returnsUnordered("i=4; k=1942", "i=6; k=1943");
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.is((Object)"returnCount=4, projects=[0, 2]"));
    }

    @Test
    public void testPFTableRefusesFilterCooperative() throws Exception {
        StringBuilder buf = new StringBuilder();
        BeatlesProjectableFilterableTable table = new BeatlesProjectableFilterableTable(buf, false);
        String explain = "PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles2]], filters=[[=($0, 4)]], projects=[[2]])";
        CalciteAssert.that().with(this.newSchema("s", "beatles2", (Table)table)).query("select \"k\" from \"s\".\"beatles2\" where \"i\" = 4").explainContains("PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles2]], filters=[[=($0, 4)]], projects=[[2]])").returnsUnordered("k=1940", "k=1942");
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.is((Object)"returnCount=4, projects=[2, 0]"));
    }

    @Test
    public void testPFPushDownProjectFilterInAggregateNoGroup() {
        StringBuilder buf = new StringBuilder();
        BeatlesProjectableFilterableTable table = new BeatlesProjectableFilterableTable(buf, false);
        String explain = "PLAN=EnumerableAggregate(group=[{}], M=[MAX($0)])\n  EnumerableInterpreter\n    BindableTableScan(table=[[s, beatles]], filters=[[>($0, 1)]], projects=[[2]])";
        CalciteAssert.that().with(this.newSchema("s", "beatles", (Table)table)).query("select max(\"k\") as m from \"s\".\"beatles\" where \"i\" > 1").explainContains("PLAN=EnumerableAggregate(group=[{}], M=[MAX($0)])\n  EnumerableInterpreter\n    BindableTableScan(table=[[s, beatles]], filters=[[>($0, 1)]], projects=[[2]])").returnsUnordered("M=1943");
    }

    @Test
    public void testPFPushDownProjectFilterAggregateGroup() {
        String sql = "select \"i\", count(*) as c\nfrom \"s\".\"beatles\"\nwhere \"k\" > 1900\ngroup by \"i\"";
        StringBuilder buf = new StringBuilder();
        BeatlesProjectableFilterableTable table = new BeatlesProjectableFilterableTable(buf, false);
        String explain = "PLAN=EnumerableAggregate(group=[{0}], C=[COUNT()])\n  EnumerableInterpreter\n    BindableTableScan(table=[[s, beatles]], filters=[[>($2, 1900)]], projects=[[0]])";
        CalciteAssert.that().with(this.newSchema("s", "beatles", (Table)table)).query("select \"i\", count(*) as c\nfrom \"s\".\"beatles\"\nwhere \"k\" > 1900\ngroup by \"i\"").explainContains("PLAN=EnumerableAggregate(group=[{0}], C=[COUNT()])\n  EnumerableInterpreter\n    BindableTableScan(table=[[s, beatles]], filters=[[>($2, 1900)]], projects=[[0]])").returnsUnordered("i=4; C=2", "i=5; C=1", "i=6; C=1");
    }

    @Test
    public void testPFPushDownProjectFilterAggregateNested() {
        StringBuilder buf = new StringBuilder();
        String sql = "select \"k\", count(*) as c\nfrom (\n  select \"k\", \"i\" from \"s\".\"beatles\" group by \"k\", \"i\") t\nwhere \"k\" = 1940\ngroup by \"k\"";
        BeatlesProjectableFilterableTable table = new BeatlesProjectableFilterableTable(buf, false);
        String explain = "PLAN=EnumerableAggregate(group=[{0}], C=[COUNT()])\n  EnumerableAggregate(group=[{0, 1}])\n    EnumerableInterpreter\n      BindableTableScan(table=[[s, beatles]], filters=[[=($2, 1940)]], projects=[[2, 0]])";
        CalciteAssert.that().with(this.newSchema("s", "beatles", (Table)table)).query("select \"k\", count(*) as c\nfrom (\n  select \"k\", \"i\" from \"s\".\"beatles\" group by \"k\", \"i\") t\nwhere \"k\" = 1940\ngroup by \"k\"").explainContains("PLAN=EnumerableAggregate(group=[{0}], C=[COUNT()])\n  EnumerableAggregate(group=[{0, 1}])\n    EnumerableInterpreter\n      BindableTableScan(table=[[s, beatles]], filters=[[=($2, 1940)]], projects=[[2, 0]])").returnsUnordered("k=1940; C=2");
    }

    private static Integer getFilter(boolean cooperative, List<RexNode> filters) {
        Iterator<RexNode> filterIter = filters.iterator();
        while (filterIter.hasNext()) {
            RexNode node = filterIter.next();
            if (!cooperative || !(node instanceof RexCall) || ((RexCall)node).getOperator() != SqlStdOperatorTable.EQUALS || !(((RexCall)node).getOperands().get(0) instanceof RexInputRef) || ((RexInputRef)((RexCall)node).getOperands().get(0)).getIndex() != 0 || !(((RexCall)node).getOperands().get(1) instanceof RexLiteral)) continue;
            RexNode op1 = (RexNode)((RexCall)node).getOperands().get(1);
            filterIter.remove();
            return ((BigDecimal)((RexLiteral)op1).getValue()).intValue();
        }
        return null;
    }

    @Test
    public void testPFTableRefusesFilterSingleColumn() throws Exception {
        StringBuilder buf = new StringBuilder();
        BeatlesProjectableFilterableTable table = new BeatlesProjectableFilterableTable(buf, false);
        String explain = "PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles2]], filters=[[>($2, 1941)]], projects=[[2]])";
        CalciteAssert.that().with(this.newSchema("s", "beatles2", (Table)table)).query("select \"k\" from \"s\".\"beatles2\" where \"k\" > 1941").explainContains("PLAN=EnumerableInterpreter\n  BindableTableScan(table=[[s, beatles2]], filters=[[>($2, 1941)]], projects=[[2]])").returnsUnordered("k=1942", "k=1943");
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.is((Object)"returnCount=4, projects=[2]"));
    }

    @Test
    public void testCannotPushProject() throws Exception {
        StringBuilder buf = new StringBuilder();
        BeatlesProjectableFilterableTable table = new BeatlesProjectableFilterableTable(buf, true);
        String explain = "PLAN=EnumerableCalc(expr#0..2=[{inputs}], expr#3=[3], k=[$t2], j=[$t1], i=[$t0], EXPR$3=[$t3])\n  EnumerableInterpreter\n    BindableTableScan(table=[[s, beatles]])";
        CalciteAssert.that().with(this.newSchema("s", "beatles", (Table)table)).query("select \"k\",\"j\",\"i\",3 from \"s\".\"beatles\"").explainContains("PLAN=EnumerableCalc(expr#0..2=[{inputs}], expr#3=[3], k=[$t2], j=[$t1], i=[$t0], EXPR$3=[$t3])\n  EnumerableInterpreter\n    BindableTableScan(table=[[s, beatles]])").returnsUnordered("k=1940; j=John; i=4; EXPR$3=3", "k=1940; j=Ringo; i=5; EXPR$3=3", "k=1942; j=Paul; i=4; EXPR$3=3", "k=1943; j=George; i=6; EXPR$3=3");
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.is((Object)"returnCount=4"));
    }

    @Test
    public void testPrepared2() throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("caseSensitive", "true");
        try (Connection connection = DriverManager.getConnection("jdbc:calcite:", properties);){
            CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
            final AtomicInteger scanCount = new AtomicInteger();
            final AtomicInteger enumerateCount = new AtomicInteger();
            AbstractSchema schema = new AbstractSchema(){

                protected Map<String, Table> getTableMap() {
                    return ImmutableMap.of((Object)"TENS", (Object)((Object)new SimpleTable(){

                        private Enumerable<Object[]> superScan(DataContext root) {
                            return super.scan(root);
                        }

                        @Override
                        public Enumerable<Object[]> scan(final DataContext root) {
                            scanCount.incrementAndGet();
                            return new AbstractEnumerable<Object[]>(){

                                public Enumerator<Object[]> enumerator() {
                                    enumerateCount.incrementAndGet();
                                    return this.superScan(root).enumerator();
                                }
                            };
                        }
                    }));
                }
            };
            calciteConnection.getRootSchema().add("TEST", (Schema)schema);
            String sql = "select * from \"TEST\".\"TENS\" where \"i\" < ?";
            PreparedStatement statement = calciteConnection.prepareStatement("select * from \"TEST\".\"TENS\" where \"i\" < ?");
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)enumerateCount.get(), (Matcher)CoreMatchers.is((Object)0));
            statement.setInt(1, 20);
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)0));
            ResultSet resultSet = statement.executeQuery();
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)enumerateCount.get(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)resultSet, Matchers.returnsUnordered("i=0", "i=10"));
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)enumerateCount.get(), (Matcher)CoreMatchers.is((Object)1));
            resultSet = statement.executeQuery();
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertThat((Object)resultSet, Matchers.returnsUnordered("i=0", "i=10"));
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)2));
            statement.setInt(1, 30);
            resultSet = statement.executeQuery();
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)3));
            Assert.assertThat((Object)resultSet, Matchers.returnsUnordered("i=0", "i=10", "i=20"));
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)3));
        }
    }

    protected CalciteAssert.ConnectionPostProcessor newSchema(final String schemaName, final String tableName, final Table table) {
        return new CalciteAssert.ConnectionPostProcessor(){

            @Override
            public Connection apply(Connection connection) throws SQLException {
                CalciteConnection con = connection.unwrap(CalciteConnection.class);
                SchemaPlus rootSchema = con.getRootSchema();
                SchemaPlus schema = rootSchema.add(schemaName, (Schema)new AbstractSchema());
                schema.add(tableName, table);
                connection.setSchema(schemaName);
                return connection;
            }
        };
    }

    private static Enumerator<Object[]> tens() {
        return new Enumerator<Object[]>(){
            int row = -1;
            Object[] current;

            public Object[] current() {
                return this.current;
            }

            public boolean moveNext() {
                if (++this.row < 4) {
                    this.current = new Object[]{this.row * 10};
                    return true;
                }
                return false;
            }

            public void reset() {
                this.row = -1;
            }

            public void close() {
                this.current = null;
            }
        };
    }

    private static Enumerator<Object[]> beatles(final StringBuilder buf, final Integer filter, final int[] projects) {
        return new Enumerator<Object[]>(){
            int row = -1;
            int returnCount = 0;
            Object[] current;

            public Object[] current() {
                return this.current;
            }

            public boolean moveNext() {
                while (++this.row < 4) {
                    Object[] current = BEATLES[this.row % 4];
                    if (filter != null && !filter.equals(current[0])) continue;
                    if (projects == null) {
                        this.current = current;
                    } else {
                        Object[] newCurrent = new Object[projects.length];
                        for (int i = 0; i < projects.length; ++i) {
                            newCurrent[i] = current[projects[i]];
                        }
                        this.current = newCurrent;
                    }
                    ++this.returnCount;
                    return true;
                }
                return false;
            }

            public void reset() {
                this.row = -1;
            }

            public void close() {
                this.current = null;
                buf.append("returnCount=").append(this.returnCount);
                if (filter != null) {
                    buf.append(", filter=").append(filter);
                }
                if (projects != null) {
                    buf.append(", projects=").append(Arrays.toString(projects));
                }
            }
        };
    }

    public static class BeatlesProjectableFilterableTable
    extends AbstractTable
    implements ProjectableFilterableTable {
        private final StringBuilder buf;
        private final boolean cooperative;

        public BeatlesProjectableFilterableTable(StringBuilder buf, boolean cooperative) {
            this.buf = buf;
            this.cooperative = cooperative;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("i", SqlTypeName.INTEGER).add("j", SqlTypeName.VARCHAR).add("k", SqlTypeName.INTEGER).build();
        }

        public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters, final int[] projects) {
            final Integer filter = ScannableTableTest.getFilter(this.cooperative, filters);
            return new AbstractEnumerable<Object[]>(){

                public Enumerator<Object[]> enumerator() {
                    return ScannableTableTest.beatles(BeatlesProjectableFilterableTable.this.buf, filter, projects);
                }
            };
        }
    }

    public static class BeatlesFilterableTable
    extends AbstractTable
    implements FilterableTable {
        private final StringBuilder buf;
        private final boolean cooperative;

        public BeatlesFilterableTable(StringBuilder buf, boolean cooperative) {
            this.buf = buf;
            this.cooperative = cooperative;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("i", SqlTypeName.INTEGER).add("j", SqlTypeName.VARCHAR).add("k", SqlTypeName.INTEGER).build();
        }

        public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters) {
            final Integer filter = ScannableTableTest.getFilter(this.cooperative, filters);
            return new AbstractEnumerable<Object[]>(){

                public Enumerator<Object[]> enumerator() {
                    return ScannableTableTest.beatles(BeatlesFilterableTable.this.buf, filter, null);
                }
            };
        }
    }

    public static class BeatlesTable
    extends AbstractTable
    implements ScannableTable {
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("i", SqlTypeName.INTEGER).add("j", SqlTypeName.VARCHAR).build();
        }

        public Enumerable<Object[]> scan(DataContext root) {
            return new AbstractEnumerable<Object[]>(){

                public Enumerator<Object[]> enumerator() {
                    return ScannableTableTest.beatles(new StringBuilder(), null, null);
                }
            };
        }
    }

    public static class SimpleTable
    extends AbstractTable
    implements ScannableTable {
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("i", SqlTypeName.INTEGER).build();
        }

        public Enumerable<Object[]> scan(DataContext root) {
            return new AbstractEnumerable<Object[]>(){

                public Enumerator<Object[]> enumerator() {
                    return ScannableTableTest.tens();
                }
            };
        }
    }
}

