/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.hive.druid.com.google.common.collect.ImmutableMultiset;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.test.CalciteAssert;
import org.apache.hive.druid.org.apache.calcite.test.TableInRootSchemaTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RelMdColumnOriginsTest {
    @Test
    public void testQueryWithAggregateGroupingSets() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        calciteConnection.getRootSchema().add("T1", (Table)new TableInRootSchemaTest.SimpleTable());
        Statement statement = calciteConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT TABLE1.ID, TABLE2.ID FROM (SELECT GROUPING(A) AS ID FROM T1 GROUP BY ROLLUP(A,B)) TABLE1 JOIN (SELECT GROUPING(A) AS ID FROM T1 GROUP BY ROLLUP(A,B)) TABLE2 ON TABLE1.ID = TABLE2.ID");
        String result1 = "ID=0; ID=0";
        String result2 = "ID=1; ID=1";
        ImmutableMultiset expectedResult = ImmutableMultiset.builder().addCopies((Object)"ID=0; ID=0", 25).add((Object)"ID=1; ID=1").build();
        Assert.assertThat(CalciteAssert.toSet(resultSet), (Matcher)CoreMatchers.equalTo((Object)expectedResult));
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Assert.assertThat((Object)resultSetMetaData.getColumnName(1), (Matcher)CoreMatchers.equalTo((Object)"ID"));
        Assert.assertThat((Object)resultSetMetaData.getTableName(1), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)resultSetMetaData.getSchemaName(1), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)resultSetMetaData.getColumnName(2), (Matcher)CoreMatchers.equalTo((Object)"ID"));
        Assert.assertThat((Object)resultSetMetaData.getTableName(2), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)resultSetMetaData.getSchemaName(2), (Matcher)CoreMatchers.nullValue());
        resultSet.close();
        statement.close();
        connection.close();
    }
}

