/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.hive.druid.org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.hive.druid.org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.hive.druid.org.apache.calcite.schema.Schema;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaPlus;
import org.apache.hive.druid.org.apache.calcite.test.CalciteAssert;
import org.apache.hive.druid.org.apache.calcite.test.JdbcTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class MultiJdbcSchemaJoinTest {
    @Test
    public void test() throws SQLException, ClassNotFoundException {
        String db1 = TempDb.INSTANCE.getUrl();
        Connection c1 = DriverManager.getConnection(db1, "", "");
        Statement stmt1 = c1.createStatement();
        stmt1.execute("create table table1(id varchar(10) not null primary key, field1 varchar(10))");
        stmt1.execute("insert into table1 values('a', 'aaaa')");
        c1.close();
        String db2 = TempDb.INSTANCE.getUrl();
        Connection c2 = DriverManager.getConnection(db2, "", "");
        Statement stmt2 = c2.createStatement();
        stmt2.execute("create table table2(id varchar(10) not null primary key, field1 varchar(10))");
        stmt2.execute("insert into table2 values('a', 'aaaa')");
        c2.close();
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        DataSource ds1 = JdbcSchema.dataSource((String)db1, (String)"org.hsqldb.jdbcDriver", (String)"", (String)"");
        rootSchema.add("DB1", (Schema)JdbcSchema.create((SchemaPlus)rootSchema, (String)"DB1", (DataSource)ds1, null, null));
        DataSource ds2 = JdbcSchema.dataSource((String)db2, (String)"org.hsqldb.jdbcDriver", (String)"", (String)"");
        rootSchema.add("DB2", (Schema)JdbcSchema.create((SchemaPlus)rootSchema, (String)"DB2", (DataSource)ds2, null, null));
        Statement stmt3 = connection.createStatement();
        ResultSet rs = stmt3.executeQuery("select table1.id, table1.field1 from db1.table1 join db2.table2 on table1.id = table2.id");
        Assert.assertThat((Object)CalciteAssert.toString(rs), (Matcher)CoreMatchers.equalTo((Object)"ID=a; FIELD1=aaaa\n"));
    }

    @Test
    public void test2() throws SQLException, ClassNotFoundException {
        this.test();
    }

    private Connection setup() throws SQLException {
        String db = TempDb.INSTANCE.getUrl();
        Connection c1 = DriverManager.getConnection(db, "", "");
        Statement stmt1 = c1.createStatement();
        stmt1.execute("create table table1(id integer not null primary key, field1 varchar(10))");
        stmt1.execute("insert into table1 values(100, 'foo')");
        stmt1.execute("insert into table1 values(200, 'bar')");
        c1.close();
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        rootSchema.add("DB", (Schema)JdbcSchema.create((SchemaPlus)rootSchema, (String)"DB", (DataSource)JdbcSchema.dataSource((String)db, (String)"org.hsqldb.jdbcDriver", (String)"", (String)""), null, null));
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
        return connection;
    }

    @Test
    public void testJdbcWithEnumerableJoin() throws SQLException {
        String query = "select t.id, t.field1 from db.table1 t join \"hr\".\"emps\" e on e.\"empid\" = t.id";
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{100, 200});
        Assert.assertThat(this.runQuery(this.setup(), query), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testEnumerableWithJdbcJoin() throws SQLException {
        String query = "select t.id, t.field1 from \"hr\".\"emps\" e join db.table1 t on e.\"empid\" = t.id";
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{100, 200});
        Assert.assertThat(this.runQuery(this.setup(), query), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testEnumerableWithJdbcJoinWithWhereClause() throws SQLException {
        String query = "select t.id, t.field1 from \"hr\".\"emps\" e join db.table1 t on e.\"empid\" = t.id where e.\"name\" = 'Bill'";
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{100});
        Assert.assertThat(this.runQuery(this.setup(), query), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Integer> runQuery(Connection calciteConnection, String query) throws SQLException {
        try (Statement stmt = calciteConnection.createStatement();){
            ResultSet rs;
            if (CalcitePrepareImpl.DEBUG) {
                rs = stmt.executeQuery("explain plan for " + query);
                rs.next();
                System.out.println(rs.getString(1));
            }
            rs = stmt.executeQuery(query);
            HashSet ids = Sets.newHashSet();
            while (rs.next()) {
                ids.add(rs.getInt(1));
            }
            HashSet hashSet = ids;
            return hashSet;
        }
    }

    @Test
    public void testSchemaConsistency() throws Exception {
        ResultSet rs;
        String db = TempDb.INSTANCE.getUrl();
        Connection c1 = DriverManager.getConnection(db, "", "");
        Statement stmt1 = c1.createStatement();
        stmt1.execute("create table table1(id varchar(10) not null primary key, field1 varchar(10))");
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        DataSource ds = JdbcSchema.dataSource((String)db, (String)"org.hsqldb.jdbcDriver", (String)"", (String)"");
        rootSchema.add("DB", (Schema)JdbcSchema.create((SchemaPlus)rootSchema, (String)"DB", (DataSource)ds, null, null));
        Statement stmt3 = connection.createStatement();
        try {
            rs = stmt3.executeQuery("select * from db.table2");
            Assert.fail((String)("expected error, got " + rs));
        }
        catch (SQLException e) {
            Assert.assertThat((Object)e.getCause().getCause().getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Object 'TABLE2' not found within 'DB'"));
        }
        stmt1.execute("create table table2(id varchar(10) not null primary key, field1 varchar(10))");
        stmt1.execute("insert into table2 values('a', 'aaaa')");
        PreparedStatement stmt2 = connection.prepareStatement("select * from db.table2");
        stmt1.execute("alter table table2 add column field2 varchar(10)");
        rs = stmt2.executeQuery();
        Assert.assertThat((Object)CalciteAssert.toString(rs), (Matcher)CoreMatchers.equalTo((Object)"ID=a; FIELD1=aaaa\n"));
        rs = stmt3.executeQuery("select * from db.table2");
        Assert.assertThat((Object)CalciteAssert.toString(rs), (Matcher)CoreMatchers.equalTo((Object)"ID=a; FIELD1=aaaa; FIELD2=null\n"));
        c1.close();
    }

    static class TempDb {
        public static final TempDb INSTANCE = new TempDb();
        private final AtomicInteger id = new AtomicInteger(1);

        TempDb() {
        }

        public String getUrl() {
            return "jdbc:hsqldb:mem:db" + this.id.getAndIncrement();
        }
    }
}

