/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.plan.volcano;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.hive.druid.org.apache.calcite.plan.Convention;
import org.apache.hive.druid.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptListener;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.plan.RelTrait;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitDef;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.PlannerTests;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.hive.druid.org.apache.calcite.rel.convert.ConverterRule;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class VolcanoPlannerTest {
    @Test
    public void testTransformLeaf() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRule((RelOptRule)new PlannerTests.PhysLeafRule());
        RelOptCluster cluster = PlannerTests.newCluster(planner);
        PlannerTests.NoneLeafRel leafRel = new PlannerTests.NoneLeafRel(cluster, "a");
        RelNode convertedRel = planner.changeTraits((RelNode)leafRel, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PlannerTests.PhysLeafRel));
    }

    @Test
    public void testTransformSingleGood() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRule((RelOptRule)new PlannerTests.PhysLeafRule());
        planner.addRule((RelOptRule)new PlannerTests.GoodSingleRule());
        RelOptCluster cluster = PlannerTests.newCluster(planner);
        PlannerTests.NoneLeafRel leafRel = new PlannerTests.NoneLeafRel(cluster, "a");
        PlannerTests.NoneSingleRel singleRel = new PlannerTests.NoneSingleRel(cluster, (RelNode)leafRel);
        RelNode convertedRel = planner.changeTraits((RelNode)singleRel, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PlannerTests.PhysSingleRel));
    }

    @Test
    public void testSubsetRule() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRule((RelOptRule)new PlannerTests.PhysLeafRule());
        planner.addRule((RelOptRule)new PlannerTests.GoodSingleRule());
        ArrayList<String> buf = new ArrayList<String>();
        planner.addRule((RelOptRule)new SubsetRule(buf));
        RelOptCluster cluster = PlannerTests.newCluster(planner);
        PlannerTests.NoneLeafRel leafRel = new PlannerTests.NoneLeafRel(cluster, "a");
        PlannerTests.NoneSingleRel singleRel = new PlannerTests.NoneSingleRel(cluster, (RelNode)leafRel);
        RelNode convertedRel = planner.changeTraits((RelNode)singleRel, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PlannerTests.PhysSingleRel));
        Assert.assertThat(VolcanoPlannerTest.sort(buf), (Matcher)CoreMatchers.equalTo((Object)VolcanoPlannerTest.sort((Comparable[])new String[]{"NoneSingleRel:Subset#0.NONE", "PhysSingleRel:Subset#0.NONE", "PhysSingleRel:Subset#0.PHYS"})));
    }

    private static <E extends Comparable> List<E> sort(List<E> list) {
        ArrayList<E> list2 = new ArrayList<E>(list);
        Collections.sort(list2);
        return list2;
    }

    private static <E extends Comparable> List<E> sort(E ... es) {
        return VolcanoPlannerTest.sort(Arrays.asList(es));
    }

    @Ignore
    @Test
    public void testTransformSingleReformed() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRule((RelOptRule)new PlannerTests.PhysLeafRule());
        planner.addRule((RelOptRule)new ReformedSingleRule());
        RelOptCluster cluster = PlannerTests.newCluster(planner);
        PlannerTests.NoneLeafRel leafRel = new PlannerTests.NoneLeafRel(cluster, "a");
        PlannerTests.NoneSingleRel singleRel = new PlannerTests.NoneSingleRel(cluster, (RelNode)leafRel);
        RelNode convertedRel = planner.changeTraits((RelNode)singleRel, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PlannerTests.PhysSingleRel));
    }

    private void removeTrivialProject(boolean useRule) {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.ambitious = true;
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        if (useRule) {
            planner.addRule((RelOptRule)ProjectRemoveRule.INSTANCE);
        }
        planner.addRule((RelOptRule)new PlannerTests.PhysLeafRule());
        planner.addRule((RelOptRule)new PlannerTests.GoodSingleRule());
        planner.addRule((RelOptRule)new PhysProjectRule());
        planner.addRule((RelOptRule)new ConverterRule(RelNode.class, (RelTrait)PlannerTests.PHYS_CALLING_CONVENTION, (RelTrait)EnumerableConvention.INSTANCE, "PhysToIteratorRule"){

            public RelNode convert(RelNode rel) {
                return new PhysToIteratorConverter(rel.getCluster(), rel);
            }
        });
        RelOptCluster cluster = PlannerTests.newCluster(planner);
        PlannerTests.PhysLeafRel leafRel = new PlannerTests.PhysLeafRel(cluster, "a");
        RexInputRef inputRef = RexInputRef.of((int)0, (RelDataType)leafRel.getRowType());
        RelNode projectRel = RelOptUtil.createProject((RelNode)leafRel, (List)ImmutableList.of((Object)inputRef), (List)ImmutableList.of((Object)"this"));
        PlannerTests.NoneSingleRel singleRel = new PlannerTests.NoneSingleRel(cluster, projectRel);
        RelNode convertedRel = planner.changeTraits((RelNode)singleRel, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PhysToIteratorConverter));
    }

    @Test
    public void testWithRemoveTrivialProject() {
        this.removeTrivialProject(true);
    }

    @Test
    public void testWithoutRemoveTrivialProject() {
        this.removeTrivialProject(false);
    }

    @Ignore
    @Test
    public void testRemoveSingleReformed() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.ambitious = true;
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRule((RelOptRule)new PlannerTests.PhysLeafRule());
        planner.addRule((RelOptRule)new ReformedRemoveSingleRule());
        RelOptCluster cluster = PlannerTests.newCluster(planner);
        PlannerTests.NoneLeafRel leafRel = new PlannerTests.NoneLeafRel(cluster, "a");
        PlannerTests.NoneSingleRel singleRel = new PlannerTests.NoneSingleRel(cluster, (RelNode)leafRel);
        RelNode convertedRel = planner.changeTraits((RelNode)singleRel, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PlannerTests.PhysLeafRel));
        PlannerTests.PhysLeafRel resultLeaf = (PlannerTests.PhysLeafRel)result;
        Assert.assertEquals((Object)"c", (Object)resultLeaf.label);
    }

    @Test
    public void testRemoveSingleGood() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.ambitious = true;
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRule((RelOptRule)new PlannerTests.PhysLeafRule());
        planner.addRule((RelOptRule)new PlannerTests.GoodSingleRule());
        planner.addRule((RelOptRule)new GoodRemoveSingleRule());
        RelOptCluster cluster = PlannerTests.newCluster(planner);
        PlannerTests.NoneLeafRel leafRel = new PlannerTests.NoneLeafRel(cluster, "a");
        PlannerTests.NoneSingleRel singleRel = new PlannerTests.NoneSingleRel(cluster, (RelNode)leafRel);
        RelNode convertedRel = planner.changeTraits((RelNode)singleRel, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PlannerTests.PhysLeafRel));
        PlannerTests.PhysLeafRel resultLeaf = (PlannerTests.PhysLeafRel)result;
        Assert.assertEquals((Object)"c", (Object)resultLeaf.label);
    }

    @Ignore
    @Test
    public void testListener() {
        TestListener listener = new TestListener();
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addListener((RelOptListener)listener);
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRule((RelOptRule)new PlannerTests.PhysLeafRule());
        RelOptCluster cluster = PlannerTests.newCluster(planner);
        PlannerTests.NoneLeafRel leafRel = new PlannerTests.NoneLeafRel(cluster, "a");
        RelNode convertedRel = planner.changeTraits((RelNode)leafRel, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PlannerTests.PhysLeafRel));
        List<RelOptListener.RelEvent> eventList = listener.getEventList();
        this.checkEvent(eventList, 0, RelOptListener.RelEquivalenceEvent.class, (RelNode)leafRel, null);
        this.checkEvent(eventList, 1, RelOptListener.RelEquivalenceEvent.class, null, null);
        this.checkEvent(eventList, 2, RelOptListener.RuleAttemptedEvent.class, (RelNode)leafRel, PlannerTests.PhysLeafRule.class);
        this.checkEvent(eventList, 3, RelOptListener.RuleProductionEvent.class, result, PlannerTests.PhysLeafRule.class);
        this.checkEvent(eventList, 4, RelOptListener.RelEquivalenceEvent.class, result, null);
        this.checkEvent(eventList, 5, RelOptListener.RuleProductionEvent.class, result, PlannerTests.PhysLeafRule.class);
        this.checkEvent(eventList, 6, RelOptListener.RuleAttemptedEvent.class, (RelNode)leafRel, PlannerTests.PhysLeafRule.class);
        this.checkEvent(eventList, 7, RelOptListener.RelChosenEvent.class, result, null);
        this.checkEvent(eventList, 8, RelOptListener.RelChosenEvent.class, null, null);
    }

    private void checkEvent(List<RelOptListener.RelEvent> eventList, int iEvent, Class expectedEventClass, RelNode expectedRel, Class<? extends RelOptRule> expectedRuleClass) {
        Assert.assertTrue((iEvent < eventList.size() ? 1 : 0) != 0);
        RelOptListener.RelEvent event = eventList.get(iEvent);
        Assert.assertSame((Object)expectedEventClass, event.getClass());
        if (expectedRel != null) {
            Assert.assertSame((Object)expectedRel, (Object)event.getRel());
        }
        if (expectedRuleClass != null) {
            RelOptListener.RuleEvent ruleEvent = (RelOptListener.RuleEvent)event;
            Assert.assertSame(expectedRuleClass, ruleEvent.getRuleCall().getRule().getClass());
        }
    }

    private static class TestListener
    implements RelOptListener {
        private List<RelOptListener.RelEvent> eventList = new ArrayList<RelOptListener.RelEvent>();

        TestListener() {
        }

        List<RelOptListener.RelEvent> getEventList() {
            return this.eventList;
        }

        private void recordEvent(RelOptListener.RelEvent event) {
            this.eventList.add(event);
        }

        public void relChosen(RelOptListener.RelChosenEvent event) {
            this.recordEvent((RelOptListener.RelEvent)event);
        }

        public void relDiscarded(RelOptListener.RelDiscardedEvent event) {
            throw new AssertionError(event);
        }

        public void relEquivalenceFound(RelOptListener.RelEquivalenceEvent event) {
            if (!event.isPhysical()) {
                return;
            }
            this.recordEvent((RelOptListener.RelEvent)event);
        }

        public void ruleAttempted(RelOptListener.RuleAttemptedEvent event) {
            this.recordEvent((RelOptListener.RelEvent)event);
        }

        public void ruleProductionSucceeded(RelOptListener.RuleProductionEvent event) {
            this.recordEvent((RelOptListener.RelEvent)event);
        }
    }

    private static class ReformedRemoveSingleRule
    extends RelOptRule {
        ReformedRemoveSingleRule() {
            super(ReformedRemoveSingleRule.operand(PlannerTests.NoneSingleRel.class, (RelOptRuleOperand)ReformedRemoveSingleRule.operand(PlannerTests.PhysLeafRel.class, (RelOptRuleOperandChildren)ReformedRemoveSingleRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public Convention getOutConvention() {
            return PlannerTests.PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            PlannerTests.NoneSingleRel singleRel = (PlannerTests.NoneSingleRel)call.rel(0);
            PlannerTests.PhysLeafRel leafRel = (PlannerTests.PhysLeafRel)call.rel(1);
            call.transformTo((RelNode)new PlannerTests.PhysLeafRel(singleRel.getCluster(), "c"));
        }
    }

    private static class GoodRemoveSingleRule
    extends RelOptRule {
        GoodRemoveSingleRule() {
            super(GoodRemoveSingleRule.operand(PlannerTests.PhysSingleRel.class, (RelOptRuleOperand)GoodRemoveSingleRule.operand(PlannerTests.PhysLeafRel.class, (RelOptRuleOperandChildren)GoodRemoveSingleRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public Convention getOutConvention() {
            return PlannerTests.PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            PlannerTests.PhysSingleRel singleRel = (PlannerTests.PhysSingleRel)call.rel(0);
            PlannerTests.PhysLeafRel leafRel = (PlannerTests.PhysLeafRel)call.rel(1);
            call.transformTo((RelNode)new PlannerTests.PhysLeafRel(singleRel.getCluster(), "c"));
        }
    }

    private static class PhysProjectRule
    extends RelOptRule {
        PhysProjectRule() {
            super(PhysProjectRule.operand(LogicalProject.class, (RelOptRuleOperandChildren)PhysProjectRule.any()));
        }

        public Convention getOutConvention() {
            return PlannerTests.PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            LogicalProject project = (LogicalProject)call.rel(0);
            RelNode childRel = project.getInput();
            call.transformTo((RelNode)new PlannerTests.PhysLeafRel(childRel.getCluster(), "b"));
        }
    }

    private static class ReformedSingleRule
    extends RelOptRule {
        ReformedSingleRule() {
            super(ReformedSingleRule.operand(PlannerTests.NoneSingleRel.class, (RelOptRuleOperand)ReformedSingleRule.operand(PlannerTests.PhysLeafRel.class, (RelOptRuleOperandChildren)ReformedSingleRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public Convention getOutConvention() {
            return PlannerTests.PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            PlannerTests.NoneSingleRel singleRel = (PlannerTests.NoneSingleRel)call.rel(0);
            RelNode childRel = call.rel(1);
            RelNode physInput = ReformedSingleRule.convert((RelNode)childRel, (RelTraitSet)singleRel.getTraitSet().replace((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
            call.transformTo((RelNode)new PlannerTests.PhysSingleRel(singleRel.getCluster(), physInput));
        }
    }

    private static class SubsetRule
    extends RelOptRule {
        private final List<String> buf;

        SubsetRule(List<String> buf) {
            super(SubsetRule.operand(PlannerTests.TestSingleRel.class, (RelOptRuleOperand)SubsetRule.operand(RelSubset.class, (RelOptRuleOperandChildren)SubsetRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
            this.buf = buf;
        }

        public Convention getOutConvention() {
            return PlannerTests.PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            PlannerTests.TestSingleRel singleRel = (PlannerTests.TestSingleRel)call.rel(0);
            RelSubset childRel = (RelSubset)call.rel(1);
            Assert.assertThat((Object)call.rels.length, (Matcher)CoreMatchers.equalTo((Object)2));
            this.buf.add(((Object)((Object)singleRel)).getClass().getSimpleName() + ":" + childRel.getDigest());
        }
    }

    class PhysToIteratorConverter
    extends ConverterImpl {
        PhysToIteratorConverter(RelOptCluster cluster, RelNode child) {
            super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE), child);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{EnumerableConvention.INSTANCE}));
            return new PhysToIteratorConverter(this.getCluster(), (RelNode)PhysToIteratorConverter.sole(inputs));
        }
    }
}

