/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.examples;

import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinRelType;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.test.RelBuilderTest;
import org.apache.hive.druid.org.apache.calcite.tools.FrameworkConfig;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;

public class RelBuilderExample {
    private final boolean verbose;

    public RelBuilderExample(boolean verbose) {
        this.verbose = verbose;
    }

    public static void main(String[] args) {
        new RelBuilderExample(true).runAllExamples();
    }

    public void runAllExamples() {
        FrameworkConfig config = RelBuilderTest.config().build();
        RelBuilder builder = RelBuilder.create((FrameworkConfig)config);
        for (int i = 0; i < 4; ++i) {
            this.doExample(builder, i);
            RelNode node = builder.build();
            if (!this.verbose) continue;
            System.out.println(RelOptUtil.toString((RelNode)node));
        }
    }

    private RelBuilder doExample(RelBuilder builder, int i) {
        switch (i) {
            case 0: {
                return this.example0(builder);
            }
            case 1: {
                return this.example1(builder);
            }
            case 2: {
                return this.example2(builder);
            }
            case 3: {
                return this.example3(builder);
            }
            case 4: {
                return this.example4(builder);
            }
        }
        throw new AssertionError((Object)("unknown example " + i));
    }

    private RelBuilder example0(RelBuilder builder) {
        return builder.values(new String[]{"a", "b"}, new Object[]{1, true, null, false});
    }

    private RelBuilder example1(RelBuilder builder) {
        return builder.scan(new String[]{"EMP"});
    }

    private RelBuilder example2(RelBuilder builder) {
        return builder.scan(new String[]{"EMP"}).project(new RexNode[]{builder.field("DEPTNO"), builder.field("ENAME")});
    }

    private RelBuilder example3(RelBuilder builder) {
        return builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(new String[]{"DEPTNO"}), new RelBuilder.AggCall[]{builder.count(false, "C", new RexNode[0]), builder.sum(false, "S", (RexNode)builder.field("SAL"))}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{builder.field("C"), builder.literal((Object)10)})});
    }

    private RelBuilder example4(RelBuilder builder) {
        RelNode left = builder.scan(new String[]{"CUSTOMERS"}).scan(new String[]{"ORDERS"}).join(JoinRelType.INNER, new String[]{"ORDER_ID"}).build();
        RelNode right = builder.scan(new String[]{"LINE_ITEMS"}).scan(new String[]{"PRODUCTS"}).join(JoinRelType.INNER, new String[]{"PRODUCT_ID"}).build();
        return builder.push(left).push(right).join(JoinRelType.INNER, new String[]{"ORDER_ID"});
    }
}

