/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.resolver.dns;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.dns.DnsServer;
import org.apache.directory.server.dns.io.decoder.DnsMessageDecoder;
import org.apache.directory.server.dns.io.encoder.DnsMessageEncoder;
import org.apache.directory.server.dns.io.encoder.ResourceRecordEncoder;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResourceRecordImpl;
import org.apache.directory.server.dns.messages.ResourceRecordModifier;
import org.apache.directory.server.dns.protocol.DnsProtocolHandler;
import org.apache.directory.server.dns.protocol.DnsUdpEncoder;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.hive.druid.io.netty.util.NetUtil;
import org.apache.hive.druid.io.netty.util.internal.PlatformDependent;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.transport.socket.DatagramAcceptor;
import org.apache.mina.transport.socket.DatagramSessionConfig;

class TestDnsServer
extends DnsServer {
    private static final Map<String, byte[]> BYTES = new HashMap<String, byte[]>();
    private static final String[] IPV6_ADDRESSES;
    private final RecordStore store;

    TestDnsServer(Set<String> domains) {
        this(new TestRecordStore(domains));
    }

    TestDnsServer(RecordStore store) {
        this.store = store;
    }

    public void start() throws IOException {
        this.start(null);
    }

    public void start(RecordType dropRecordType) throws IOException {
        this.start(dropRecordType, new InetSocketAddress(NetUtil.LOCALHOST4, 0));
    }

    public void start(final RecordType dropRecordType, InetSocketAddress address) throws IOException {
        UdpTransport transport = new UdpTransport(address.getHostName(), address.getPort());
        this.setTransports(new Transport[]{transport});
        DatagramAcceptor acceptor = transport.getAcceptor();
        acceptor.setHandler((IoHandler)new DnsProtocolHandler(this, this.store){

            public void sessionCreated(IoSession session) {
                session.getFilterChain().addFirst("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new TestDnsProtocolUdpCodecFactory(dropRecordType)));
            }
        });
        ((DatagramSessionConfig)acceptor.getSessionConfig()).setReuseAddress(true);
        acceptor.bind();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)this.getTransports()[0].getAcceptor().getLocalAddress();
    }

    protected DnsMessage filterMessage(DnsMessage message) {
        return message;
    }

    protected static ResourceRecord newARecord(String name, String ipAddress) {
        return TestDnsServer.newAddressRecord(name, RecordType.A, ipAddress);
    }

    protected static ResourceRecord newNsRecord(String dnsname, String domainName) {
        ResourceRecordModifier rm = new ResourceRecordModifier();
        rm.setDnsClass(RecordClass.IN);
        rm.setDnsName(dnsname);
        rm.setDnsTtl(100);
        rm.setDnsType(RecordType.NS);
        rm.put("apacheDnsDomainName", domainName);
        return rm.getEntry();
    }

    protected static ResourceRecord newAddressRecord(String name, RecordType type, String address) {
        ResourceRecordModifier rm = new ResourceRecordModifier();
        rm.setDnsClass(RecordClass.IN);
        rm.setDnsName(name);
        rm.setDnsTtl(100);
        rm.setDnsType(type);
        rm.put("apacheDnsIpAddress", address);
        return rm.getEntry();
    }

    static {
        BYTES.put("::1", new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
        BYTES.put("0:0:0:0:0:0:1:1", new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1});
        BYTES.put("0:0:0:0:0:1:1:1", new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1});
        BYTES.put("0:0:0:0:1:1:1:1", new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1});
        BYTES.put("0:0:0:1:1:1:1:1", new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1});
        BYTES.put("0:0:1:1:1:1:1:1", new byte[]{0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1});
        BYTES.put("0:1:1:1:1:1:1:1", new byte[]{0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1});
        BYTES.put("1:1:1:1:1:1:1:1", new byte[]{0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1});
        IPV6_ADDRESSES = BYTES.keySet().toArray(new String[0]);
    }

    static final class TestResourceRecord
    extends ResourceRecordImpl {
        TestResourceRecord(String domainName, RecordType recordType, Map<String, Object> attributes) {
            super(domainName, recordType, RecordClass.IN, 100, attributes);
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return o == this;
        }
    }

    private static final class TestRecordStore
    implements RecordStore {
        private static final int[] NUMBERS;
        private static final char[] CHARS;
        private final Set<String> domains;

        private static int index(int arrayLength) {
            return Math.abs(PlatformDependent.threadLocalRandom().nextInt()) % arrayLength;
        }

        private static String nextDomain() {
            return CHARS[TestRecordStore.index(CHARS.length)] + ".netty.io";
        }

        private static String nextIp() {
            return TestRecordStore.ipPart() + "." + TestRecordStore.ipPart() + '.' + TestRecordStore.ipPart() + '.' + TestRecordStore.ipPart();
        }

        private static int ipPart() {
            return NUMBERS[TestRecordStore.index(NUMBERS.length)];
        }

        private static String nextIp6() {
            return IPV6_ADDRESSES[TestRecordStore.index(IPV6_ADDRESSES.length)];
        }

        private TestRecordStore(Set<String> domains) {
            this.domains = domains;
        }

        public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) {
            String name = questionRecord.getDomainName();
            if (this.domains.contains(name)) {
                HashMap<String, Object> attr = new HashMap<String, Object>();
                switch (questionRecord.getRecordType()) {
                    case A: {
                        do {
                            attr.put("apacheDnsIpAddress".toLowerCase(Locale.US), TestRecordStore.nextIp());
                        } while (PlatformDependent.threadLocalRandom().nextBoolean());
                        break;
                    }
                    case AAAA: {
                        do {
                            attr.put("apacheDnsIpAddress".toLowerCase(Locale.US), TestRecordStore.nextIp6());
                        } while (PlatformDependent.threadLocalRandom().nextBoolean());
                        break;
                    }
                    case MX: {
                        int priority = 0;
                        do {
                            attr.put("apacheDnsDomainName".toLowerCase(Locale.US), TestRecordStore.nextDomain());
                            attr.put("apacheDnsMxPreference".toLowerCase(Locale.US), String.valueOf(++priority));
                        } while (PlatformDependent.threadLocalRandom().nextBoolean());
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return Collections.singleton(new TestResourceRecord(name, questionRecord.getRecordType(), attr));
            }
            return null;
        }

        static {
            int i;
            NUMBERS = new int[254];
            CHARS = new char[26];
            for (i = 0; i < NUMBERS.length; ++i) {
                TestRecordStore.NUMBERS[i] = i + 1;
            }
            for (i = 0; i < CHARS.length; ++i) {
                TestRecordStore.CHARS[i] = (char)(97 + i);
            }
        }
    }

    static final class MapRecordStoreA
    implements RecordStore {
        private final Map<String, List<String>> domainMap;

        MapRecordStoreA(Set<String> domains, int length) {
            this.domainMap = new HashMap<String, List<String>>(domains.size());
            for (String domain : domains) {
                ArrayList<String> addresses = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    addresses.add(TestRecordStore.nextIp());
                }
                this.domainMap.put(domain, addresses);
            }
        }

        MapRecordStoreA(Set<String> domains) {
            this(domains, 1);
        }

        public String getAddress(String domain) {
            return this.domainMap.get(domain).get(0);
        }

        public List<String> getAddresses(String domain) {
            return this.domainMap.get(domain);
        }

        public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) {
            String name = questionRecord.getDomainName();
            List<String> addresses = this.domainMap.get(name);
            if (addresses != null && questionRecord.getRecordType() == RecordType.A) {
                LinkedHashSet<ResourceRecord> records = new LinkedHashSet<ResourceRecord>();
                for (String address : addresses) {
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    attributes.put("apacheDnsIpAddress".toLowerCase(), address);
                    records.add((ResourceRecord)new TestResourceRecord(name, questionRecord.getRecordType(), attributes));
                }
                return records;
            }
            return null;
        }
    }

    private final class TestDnsProtocolUdpCodecFactory
    implements ProtocolCodecFactory {
        private final DnsMessageEncoder encoder = new DnsMessageEncoder();
        private final TestAAAARecordEncoder recordEncoder = new TestAAAARecordEncoder();
        private final RecordType dropRecordType;

        TestDnsProtocolUdpCodecFactory(RecordType dropRecordType) {
            this.dropRecordType = dropRecordType;
        }

        public ProtocolEncoder getEncoder(IoSession session) {
            return new DnsUdpEncoder(){

                public void encode(IoSession session, Object message, ProtocolEncoderOutput out) {
                    IoBuffer buf = IoBuffer.allocate((int)1024);
                    DnsMessage dnsMessage = TestDnsServer.this.filterMessage((DnsMessage)message);
                    if (dnsMessage != null) {
                        TestDnsProtocolUdpCodecFactory.this.encoder.encode(buf, dnsMessage);
                        for (ResourceRecord record : dnsMessage.getAnswerRecords()) {
                            if (record.getRecordType() != RecordType.AAAA) continue;
                            try {
                                TestDnsProtocolUdpCodecFactory.this.recordEncoder.put(buf, record);
                            }
                            catch (IOException e) {
                                throw new IllegalStateException(e);
                            }
                        }
                        buf.flip();
                        out.write((Object)buf);
                    }
                }
            };
        }

        public ProtocolDecoder getDecoder(IoSession session) {
            return new ProtocolDecoderAdapter(){
                private final DnsMessageDecoder decoder = new DnsMessageDecoder();

                public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws IOException {
                    DnsMessage message = this.decoder.decode(in);
                    if (TestDnsProtocolUdpCodecFactory.this.dropRecordType != null) {
                        for (QuestionRecord record : message.getQuestionRecords()) {
                            if (record.getRecordType() != TestDnsProtocolUdpCodecFactory.this.dropRecordType) continue;
                            return;
                        }
                    }
                    out.write((Object)message);
                }
            };
        }

        private final class TestAAAARecordEncoder
        extends ResourceRecordEncoder {
            private TestAAAARecordEncoder() {
            }

            protected void putResourceRecordData(IoBuffer ioBuffer, ResourceRecord resourceRecord) {
                byte[] bytes = (byte[])BYTES.get(resourceRecord.get("apacheDnsIpAddress"));
                if (bytes == null) {
                    throw new IllegalStateException(resourceRecord.get("apacheDnsIpAddress"));
                }
                ioBuffer.put(bytes);
            }
        }
    }
}

