/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.socks;

import java.net.IDN;
import java.nio.CharBuffer;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksAddressType;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksCmdResponse;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksCmdStatus;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksProtocolVersion;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class SocksCmdResponseTest {
    @Test
    public void testConstructorParamsAreNotNull() {
        try {
            new SocksCmdResponse(null, SocksAddressType.UNKNOWN);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof NullPointerException));
        }
        try {
            new SocksCmdResponse(SocksCmdStatus.UNASSIGNED, null);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof NullPointerException));
        }
    }

    @Test
    public void testEmptyDomain() {
        SocksCmdResponse socksCmdResponse = new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.DOMAIN);
        Assertions.assertNull((Object)socksCmdResponse.host());
        Assertions.assertEquals((int)0, (int)socksCmdResponse.port());
        ByteBuf buffer = Unpooled.buffer((int)20);
        socksCmdResponse.encodeAsByteBuf(buffer);
        byte[] expected = new byte[]{5, 0, 0, 3, 1, 0, 0, 0};
        SocksCmdResponseTest.assertByteBufEquals(expected, buffer);
    }

    @Test
    public void testIPv4Host() {
        SocksCmdResponse socksCmdResponse = new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.IPv4, "127.0.0.1", 80);
        Assertions.assertEquals((Object)"127.0.0.1", (Object)socksCmdResponse.host());
        Assertions.assertEquals((int)80, (int)socksCmdResponse.port());
        ByteBuf buffer = Unpooled.buffer((int)20);
        socksCmdResponse.encodeAsByteBuf(buffer);
        byte[] expected = new byte[]{5, 0, 0, 1, 127, 0, 0, 1, 0, 80};
        SocksCmdResponseTest.assertByteBufEquals(expected, buffer);
    }

    @Test
    public void testEmptyBoundAddress() {
        SocksCmdResponse socksCmdResponse = new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.DOMAIN, "", 80);
        Assertions.assertEquals((Object)"", (Object)socksCmdResponse.host());
        Assertions.assertEquals((int)80, (int)socksCmdResponse.port());
        ByteBuf buffer = Unpooled.buffer((int)20);
        socksCmdResponse.encodeAsByteBuf(buffer);
        byte[] expected = new byte[]{5, 0, 0, 3, 0, 0, 80};
        SocksCmdResponseTest.assertByteBufEquals(expected, buffer);
    }

    @Test
    public void testHostNotEncodedForUnknown() {
        String asciiHost = "xn--e1aybc.xn--p1ai";
        int port = 10000;
        SocksCmdResponse rs = new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.UNKNOWN, asciiHost, port);
        Assertions.assertEquals((Object)asciiHost, (Object)rs.host());
        ByteBuf buffer = Unpooled.buffer((int)16);
        rs.encodeAsByteBuf(buffer);
        buffer.resetReaderIndex();
        Assertions.assertEquals((byte)SocksProtocolVersion.SOCKS5.byteValue(), (byte)buffer.readByte());
        Assertions.assertEquals((byte)SocksCmdStatus.SUCCESS.byteValue(), (byte)buffer.readByte());
        Assertions.assertEquals((byte)0, (byte)buffer.readByte());
        Assertions.assertEquals((byte)SocksAddressType.UNKNOWN.byteValue(), (byte)buffer.readByte());
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
    }

    @Test
    public void testIDNEncodeToAsciiForDomain() {
        String host = "\u0442\u0435\u0441\u0442.\u0440\u0444";
        CharBuffer asciiHost = CharBuffer.wrap(IDN.toASCII(host));
        int port = 10000;
        SocksCmdResponse rs = new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.DOMAIN, host, port);
        Assertions.assertEquals((Object)host, (Object)rs.host());
        ByteBuf buffer = Unpooled.buffer((int)24);
        rs.encodeAsByteBuf(buffer);
        buffer.resetReaderIndex();
        Assertions.assertEquals((byte)SocksProtocolVersion.SOCKS5.byteValue(), (byte)buffer.readByte());
        Assertions.assertEquals((byte)SocksCmdStatus.SUCCESS.byteValue(), (byte)buffer.readByte());
        Assertions.assertEquals((byte)0, (byte)buffer.readByte());
        Assertions.assertEquals((byte)SocksAddressType.DOMAIN.byteValue(), (byte)buffer.readByte());
        Assertions.assertEquals((short)((byte)asciiHost.length()), (short)buffer.readUnsignedByte());
        Assertions.assertEquals((Object)asciiHost, (Object)CharBuffer.wrap(buffer.readCharSequence(asciiHost.length(), CharsetUtil.US_ASCII)));
        Assertions.assertEquals((int)port, (int)buffer.readUnsignedShort());
        buffer.release();
    }

    @Test
    public void testInvalidBoundAddress() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.IPv4, "127.0.0", 1000);
            }
        });
    }

    private static void assertByteBufEquals(byte[] expected, ByteBuf actual) {
        byte[] actualBytes = new byte[actual.readableBytes()];
        actual.readBytes(actualBytes);
        Assertions.assertEquals((int)expected.length, (int)actualBytes.length, (String)"Generated response has incorrect length");
        Assertions.assertArrayEquals((byte[])expected, (byte[])actualBytes, (String)"Generated response differs from expected");
    }

    @Test
    public void testValidPortRange() {
        try {
            new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.IPv4, "127.0.0", 0);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        try {
            new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.IPv4, "127.0.0", 65536);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }
}

