/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.mqtt;

import java.util.Collections;
import org.apache.hive.druid.io.netty.handler.codec.mqtt.MqttConnectPayload;
import org.apache.hive.druid.io.netty.handler.codec.mqtt.MqttMessageBuilders;
import org.apache.hive.druid.io.netty.handler.codec.mqtt.MqttProperties;
import org.apache.hive.druid.io.netty.handler.codec.mqtt.MqttSubscribePayload;
import org.apache.hive.druid.io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MqttConnectPayloadTest {
    @Test
    public void testNullWillMessage() throws Exception {
        String clientIdentifier = "clientIdentifier";
        String willTopic = "willTopic";
        byte[] willMessage = null;
        String userName = "userName";
        byte[] password = "password".getBytes(CharsetUtil.UTF_8);
        MqttConnectPayload mqttConnectPayload = new MqttConnectPayload(clientIdentifier, MqttProperties.NO_PROPERTIES, willTopic, willMessage, userName, password);
        Assertions.assertNull((Object)mqttConnectPayload.willMessageInBytes());
        Assertions.assertNull((Object)mqttConnectPayload.willMessage());
    }

    @Test
    public void testNullPassword() throws Exception {
        String clientIdentifier = "clientIdentifier";
        String willTopic = "willTopic";
        byte[] willMessage = "willMessage".getBytes(CharsetUtil.UTF_8);
        String userName = "userName";
        byte[] password = null;
        MqttConnectPayload mqttConnectPayload = new MqttConnectPayload(clientIdentifier, MqttProperties.NO_PROPERTIES, willTopic, willMessage, userName, password);
        Assertions.assertNull((Object)mqttConnectPayload.passwordInBytes());
        Assertions.assertNull((Object)mqttConnectPayload.password());
    }

    @Test
    public void testBuilderNullPassword() throws Exception {
        MqttMessageBuilders.ConnectBuilder builder = new MqttMessageBuilders.ConnectBuilder();
        builder.password((String)null);
        MqttConnectPayload mqttConnectPayload = builder.build().payload();
        Assertions.assertNull((Object)mqttConnectPayload.passwordInBytes());
        Assertions.assertNull((Object)mqttConnectPayload.password());
        builder = new MqttMessageBuilders.ConnectBuilder();
        builder.password((byte[])null);
        mqttConnectPayload = builder.build().payload();
        Assertions.assertNull((Object)mqttConnectPayload.passwordInBytes());
        Assertions.assertNull((Object)mqttConnectPayload.password());
    }

    @Test
    public void testBuilderNullWillMessage() throws Exception {
        MqttMessageBuilders.ConnectBuilder builder = new MqttMessageBuilders.ConnectBuilder();
        builder.willMessage((String)null);
        MqttConnectPayload mqttConnectPayload = builder.build().payload();
        Assertions.assertNull((Object)mqttConnectPayload.willMessageInBytes());
        Assertions.assertNull((Object)mqttConnectPayload.willMessage());
        builder = new MqttMessageBuilders.ConnectBuilder();
        builder.willMessage((byte[])null);
        mqttConnectPayload = builder.build().payload();
        Assertions.assertNull((Object)mqttConnectPayload.willMessageInBytes());
        Assertions.assertNull((Object)mqttConnectPayload.willMessage());
    }

    @Test
    public void testEmptyTopicsToString() {
        new MqttSubscribePayload(Collections.emptyList()).toString();
        new MqttUnsubscribePayload(Collections.emptyList()).toString();
    }
}

