/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.memcache.binary;

import java.nio.charset.Charset;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.memcache.LastMemcacheContent;
import org.apache.hive.druid.io.netty.handler.codec.memcache.MemcacheContent;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.BinaryMemcacheRequest;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.BinaryMemcacheRequestDecoder;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.BinaryMemcacheRequestEncoder;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.BinaryMemcacheResponse;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.BinaryMemcacheResponseDecoder;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.apache.hive.druid.io.netty.util.ReferenceCounted;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BinaryMemcacheDecoderTest {
    private static final byte[] GET_REQUEST = new byte[]{-128, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102, 111, 111};
    private static final byte[] SET_REQUEST_WITH_CONTENT = new byte[]{-128, 1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102, 111, 111, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final byte[] GET_RESPONSE_CHUNK_1 = new byte[]{-127, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 78, 111, 116, 32, 102, 111, 117, 110, 100, -127, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 78, 111, 116, 32, 102, 111, 117};
    private static final byte[] GET_RESPONSE_CHUNK_2 = new byte[]{110, 100, -127, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 78, 111, 116, 32, 102, 111, 117, 110, 100};
    private EmbeddedChannel channel;

    @BeforeEach
    public void setup() throws Exception {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new BinaryMemcacheRequestDecoder()});
    }

    @AfterEach
    public void teardown() throws Exception {
        this.channel.finishAndReleaseAll();
    }

    @Test
    public void shouldDecodeRequestWithSimpleValue() {
        ByteBuf incoming = Unpooled.buffer();
        incoming.writeBytes(GET_REQUEST);
        this.channel.writeInbound(new Object[]{incoming});
        BinaryMemcacheRequest request = (BinaryMemcacheRequest)this.channel.readInbound();
        MatcherAssert.assertThat((Object)request, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)request.key(), (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)request.extras(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)request.keyLength(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)request.extrasLength(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)request.totalBodyLength(), (Matcher)CoreMatchers.is((Object)3));
        request.release();
        MatcherAssert.assertThat((Object)this.channel.readInbound(), (Matcher)CoreMatchers.instanceOf(LastMemcacheContent.class));
    }

    @Test
    public void shouldDecodeRequestWithChunkedContent() {
        int smallBatchSize = 2;
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new BinaryMemcacheRequestDecoder(smallBatchSize)});
        ByteBuf incoming = Unpooled.buffer();
        incoming.writeBytes(SET_REQUEST_WITH_CONTENT);
        this.channel.writeInbound(new Object[]{incoming});
        BinaryMemcacheRequest request = (BinaryMemcacheRequest)this.channel.readInbound();
        MatcherAssert.assertThat((Object)request, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)request.key(), (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)request.extras(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)request.keyLength(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)request.extrasLength(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)request.totalBodyLength(), (Matcher)CoreMatchers.is((Object)11));
        request.release();
        int expectedContentChunks = 4;
        for (int i = 1; i <= expectedContentChunks; ++i) {
            MemcacheContent content = (MemcacheContent)this.channel.readInbound();
            if (i < expectedContentChunks) {
                MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.instanceOf(MemcacheContent.class));
            } else {
                MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.instanceOf(LastMemcacheContent.class));
            }
            MatcherAssert.assertThat((Object)content.content().readableBytes(), (Matcher)CoreMatchers.is((Object)2));
            content.release();
        }
        MatcherAssert.assertThat((Object)this.channel.readInbound(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldHandleNonUniformNetworkBatches() {
        ByteBuf incoming = Unpooled.copiedBuffer((byte[])SET_REQUEST_WITH_CONTENT);
        while (incoming.isReadable()) {
            this.channel.writeInbound(new Object[]{incoming.readBytes(5)});
        }
        incoming.release();
        BinaryMemcacheRequest request = (BinaryMemcacheRequest)this.channel.readInbound();
        MatcherAssert.assertThat((Object)request, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)request.key(), (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)request.extras(), (Matcher)IsNull.nullValue());
        request.release();
        MemcacheContent content1 = (MemcacheContent)this.channel.readInbound();
        MemcacheContent content2 = (MemcacheContent)this.channel.readInbound();
        MatcherAssert.assertThat((Object)content1, (Matcher)CoreMatchers.instanceOf(MemcacheContent.class));
        MatcherAssert.assertThat((Object)content2, (Matcher)CoreMatchers.instanceOf(LastMemcacheContent.class));
        MatcherAssert.assertThat((Object)content1.content().readableBytes(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)content2.content().readableBytes(), (Matcher)CoreMatchers.is((Object)5));
        content1.release();
        content2.release();
    }

    @Test
    public void shouldHandleTwoMessagesInOneBatch() {
        this.channel.writeInbound(new Object[]{Unpooled.buffer().writeBytes(GET_REQUEST).writeBytes(GET_REQUEST)});
        BinaryMemcacheRequest request = (BinaryMemcacheRequest)this.channel.readInbound();
        MatcherAssert.assertThat((Object)request, (Matcher)CoreMatchers.instanceOf(BinaryMemcacheRequest.class));
        MatcherAssert.assertThat((Object)request, (Matcher)IsNull.notNullValue());
        request.release();
        Object lastContent = this.channel.readInbound();
        MatcherAssert.assertThat((Object)lastContent, (Matcher)CoreMatchers.instanceOf(LastMemcacheContent.class));
        ((ReferenceCounted)lastContent).release();
        request = (BinaryMemcacheRequest)this.channel.readInbound();
        MatcherAssert.assertThat((Object)request, (Matcher)CoreMatchers.instanceOf(BinaryMemcacheRequest.class));
        MatcherAssert.assertThat((Object)request, (Matcher)IsNull.notNullValue());
        request.release();
        lastContent = this.channel.readInbound();
        MatcherAssert.assertThat((Object)lastContent, (Matcher)CoreMatchers.instanceOf(LastMemcacheContent.class));
        ((ReferenceCounted)lastContent).release();
    }

    @Test
    public void shouldDecodeSeparatedValues() {
        String msgBody = "Not found";
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new BinaryMemcacheResponseDecoder()});
        this.channel.writeInbound(new Object[]{Unpooled.buffer().writeBytes(GET_RESPONSE_CHUNK_1)});
        this.channel.writeInbound(new Object[]{Unpooled.buffer().writeBytes(GET_RESPONSE_CHUNK_2)});
        BinaryMemcacheResponse response = (BinaryMemcacheResponse)this.channel.readInbound();
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)response.totalBodyLength(), (Matcher)CoreMatchers.is((Object)msgBody.length()));
        response.release();
        MemcacheContent content = (MemcacheContent)this.channel.readInbound();
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.instanceOf(LastMemcacheContent.class));
        MatcherAssert.assertThat((Object)content.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)msgBody));
        content.release();
        response = (BinaryMemcacheResponse)this.channel.readInbound();
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)response.totalBodyLength(), (Matcher)CoreMatchers.is((Object)msgBody.length()));
        response.release();
        content = (MemcacheContent)this.channel.readInbound();
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.instanceOf(MemcacheContent.class));
        MatcherAssert.assertThat((Object)content.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)msgBody.substring(0, 7)));
        content.release();
        content = (MemcacheContent)this.channel.readInbound();
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.instanceOf(LastMemcacheContent.class));
        MatcherAssert.assertThat((Object)content.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)msgBody.substring(7, 9)));
        content.release();
        response = (BinaryMemcacheResponse)this.channel.readInbound();
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)response.totalBodyLength(), (Matcher)CoreMatchers.is((Object)msgBody.length()));
        response.release();
        content = (MemcacheContent)this.channel.readInbound();
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.instanceOf(LastMemcacheContent.class));
        MatcherAssert.assertThat((Object)content.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)msgBody));
        content.release();
    }

    @Test
    public void shouldRetainCurrentMessageWhenSendingItOut() {
        ByteBuf buffer;
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new BinaryMemcacheRequestEncoder(), new BinaryMemcacheRequestDecoder()});
        ByteBuf key = Unpooled.copiedBuffer((CharSequence)"Netty", (Charset)CharsetUtil.UTF_8);
        ByteBuf extras = Unpooled.copiedBuffer((CharSequence)"extras", (Charset)CharsetUtil.UTF_8);
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key, extras);
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{request}));
        while ((buffer = (ByteBuf)this.channel.readOutbound()) != null) {
            this.channel.writeInbound(new Object[]{buffer});
        }
        BinaryMemcacheRequest read = (BinaryMemcacheRequest)this.channel.readInbound();
        read.release();
    }
}

