/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.ByteBufAllocator;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelConfig;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelInitializer;
import org.apache.hive.druid.io.netty.channel.RecvByteBufAllocator;
import org.apache.hive.druid.io.netty.util.UncheckedBooleanSupplier;

@ChannelHandler.Sharable
public class TestChannelInitializer
extends ChannelInitializer<Channel> {
    ChannelHandler handler;
    AtomicInteger maxReads;

    public void initChannel(Channel channel) {
        if (this.handler != null) {
            channel.pipeline().addLast(new ChannelHandler[]{this.handler});
            this.handler = null;
        }
        if (this.maxReads != null) {
            channel.config().setRecvByteBufAllocator((RecvByteBufAllocator)new TestNumReadsRecvByteBufAllocator(this.maxReads));
        }
    }

    static final class TestNumReadsRecvByteBufAllocator
    implements RecvByteBufAllocator {
        private final AtomicInteger numReads;

        private TestNumReadsRecvByteBufAllocator(AtomicInteger numReads) {
            this.numReads = numReads;
        }

        public RecvByteBufAllocator.ExtendedHandle newHandle() {
            return new RecvByteBufAllocator.ExtendedHandle(){
                private int attemptedBytesRead;
                private int lastBytesRead;
                private int numMessagesRead;

                public ByteBuf allocate(ByteBufAllocator alloc) {
                    return alloc.ioBuffer(this.guess(), this.guess());
                }

                public int guess() {
                    return 1;
                }

                public void reset(ChannelConfig config) {
                    this.numMessagesRead = 0;
                }

                public void incMessagesRead(int numMessages) {
                    this.numMessagesRead += numMessages;
                }

                public void lastBytesRead(int bytes) {
                    this.lastBytesRead = bytes;
                }

                public int lastBytesRead() {
                    return this.lastBytesRead;
                }

                public void attemptedBytesRead(int bytes) {
                    this.attemptedBytesRead = bytes;
                }

                public int attemptedBytesRead() {
                    return this.attemptedBytesRead;
                }

                public boolean continueReading() {
                    return this.numMessagesRead < TestNumReadsRecvByteBufAllocator.this.numReads.get();
                }

                public boolean continueReading(UncheckedBooleanSupplier maybeMoreDataSupplier) {
                    return this.continueReading();
                }

                public void readComplete() {
                }
            };
        }
    }
}

