/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.apache.hive.druid.io.netty.buffer.ByteBufAllocator;
import org.apache.hive.druid.io.netty.buffer.UnpooledByteBufAllocator;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2SecurityUtil;
import org.apache.hive.druid.io.netty.handler.ssl.CipherSuiteFilter;
import org.apache.hive.druid.io.netty.handler.ssl.SslContext;
import org.apache.hive.druid.io.netty.handler.ssl.SslContextBuilder;
import org.apache.hive.druid.io.netty.handler.ssl.SslProvider;
import org.apache.hive.druid.io.netty.handler.ssl.SupportedCipherSuiteFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class Http2SecurityUtilTest {
    @Test
    public void testTLSv13CiphersIncluded() throws SSLException {
        Assumptions.assumeTrue((boolean)SslProvider.isTlsv13Supported((SslProvider)SslProvider.JDK));
        Http2SecurityUtilTest.testCiphersIncluded("TLSv1.3");
    }

    @Test
    public void testTLSv12CiphersIncluded() throws SSLException {
        Http2SecurityUtilTest.testCiphersIncluded("TLSv1.2");
    }

    private static void testCiphersIncluded(String protocol) throws SSLException {
        SslContext context = SslContextBuilder.forClient().sslProvider(SslProvider.JDK).protocols(new String[]{protocol}).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).build();
        SSLEngine engine = context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertTrue((engine.getEnabledCipherSuites().length > 0 ? 1 : 0) != 0, (String)("No " + protocol + " ciphers found"));
    }
}

