/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Exception;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameCodec;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Stream;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2StreamChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public abstract class Http2MultiplexClientUpgradeTest<C extends Http2FrameCodec> {
    protected abstract C newCodec(ChannelHandler var1);

    protected abstract ChannelHandler newMultiplexer(ChannelHandler var1);

    @Test
    public void upgradeHandlerGetsActivated() throws Exception {
        UpgradeHandler upgradeHandler = new UpgradeHandler();
        C codec = this.newCodec((ChannelHandler)upgradeHandler);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{codec, this.newMultiplexer((ChannelHandler)upgradeHandler)});
        codec.onHttpClientUpgrade();
        Assertions.assertFalse((boolean)upgradeHandler.stateOnActive.localSideOpen());
        Assertions.assertTrue((boolean)upgradeHandler.stateOnActive.remoteSideOpen());
        Assertions.assertNotNull((Object)codec.connection().stream(1).getProperty(((Http2FrameCodec)codec).streamKey));
        Assertions.assertEquals((int)1, (int)upgradeHandler.streamId);
        Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
        Assertions.assertTrue((boolean)upgradeHandler.channelInactiveCalled);
    }

    @Test
    public void clientUpgradeWithoutUpgradeHandlerThrowsHttp2Exception() throws Http2Exception {
        C codec = this.newCodec(null);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{codec, this.newMultiplexer(null)});
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable((Http2FrameCodec)codec, ch){
            final /* synthetic */ Http2FrameCodec val$codec;
            final /* synthetic */ EmbeddedChannel val$ch;
            {
                this.val$codec = http2FrameCodec;
                this.val$ch = embeddedChannel;
            }

            public void execute() throws Http2Exception {
                try {
                    this.val$codec.onHttpClientUpgrade();
                }
                finally {
                    this.val$ch.finishAndReleaseAll();
                }
            }
        });
    }

    private static final class UpgradeHandler
    extends ChannelInboundHandlerAdapter {
        Http2Stream.State stateOnActive;
        int streamId;
        boolean channelInactiveCalled;

        private UpgradeHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            Http2StreamChannel ch = (Http2StreamChannel)ctx.channel();
            this.stateOnActive = ch.stream().state();
            this.streamId = ch.stream().id();
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.channelInactiveCalled = true;
            super.channelInactive(ctx);
        }
    }

    @ChannelHandler.Sharable
    static final class NoopHandler
    extends ChannelInboundHandlerAdapter {
        NoopHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ctx.channel().close();
        }
    }
}

