/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import java.util.Random;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.handler.codec.http2.HpackHuffmanDecoder;
import org.apache.hive.druid.io.netty.handler.codec.http2.HpackHuffmanEncoder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Exception;
import org.apache.hive.druid.io.netty.util.AsciiString;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class HpackHuffmanTest {
    @Test
    public void testHuffman() throws Http2Exception {
        String s = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        for (int i = 0; i < s.length(); ++i) {
            HpackHuffmanTest.roundTrip(s.substring(0, i));
        }
        Random random = new Random(123456789L);
        byte[] buf = new byte[4096];
        random.nextBytes(buf);
        HpackHuffmanTest.roundTrip(buf);
    }

    @Test
    public void testDecodeEOS() throws Http2Exception {
        final byte[] buf = new byte[4];
        for (int i = 0; i < 4; ++i) {
            buf[i] = -1;
        }
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackHuffmanTest.decode(buf);
            }
        });
    }

    @Test
    public void testDecodeIllegalPadding() throws Http2Exception {
        final byte[] buf = new byte[]{0};
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackHuffmanTest.decode(buf);
            }
        });
    }

    @Test
    public void testDecodeExtraPadding() throws Http2Exception {
        final byte[] buf = HpackHuffmanTest.makeBuf(15, 255);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackHuffmanTest.decode(buf);
            }
        });
    }

    @Test
    public void testDecodeExtraPadding1byte() throws Http2Exception {
        final byte[] buf = HpackHuffmanTest.makeBuf(255);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackHuffmanTest.decode(buf);
            }
        });
    }

    @Test
    public void testDecodeExtraPadding2byte() throws Http2Exception {
        final byte[] buf = HpackHuffmanTest.makeBuf(31, 255);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackHuffmanTest.decode(buf);
            }
        });
    }

    @Test
    public void testDecodeExtraPadding3byte() throws Http2Exception {
        final byte[] buf = HpackHuffmanTest.makeBuf(31, 255, 255);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackHuffmanTest.decode(buf);
            }
        });
    }

    @Test
    public void testDecodeExtraPadding4byte() throws Http2Exception {
        final byte[] buf = HpackHuffmanTest.makeBuf(31, 255, 255, 255);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackHuffmanTest.decode(buf);
            }
        });
    }

    @Test
    public void testDecodeExtraPadding29bit() throws Http2Exception {
        final byte[] buf = HpackHuffmanTest.makeBuf(255, 159, 255, 255, 255);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackHuffmanTest.decode(buf);
            }
        });
    }

    @Test
    public void testDecodePartialSymbol() throws Http2Exception {
        final byte[] buf = HpackHuffmanTest.makeBuf(82, 188, 48, 255, 255, 255, 255);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackHuffmanTest.decode(buf);
            }
        });
    }

    private static byte[] makeBuf(int ... bytes) {
        byte[] buf = new byte[bytes.length];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (byte)bytes[i];
        }
        return buf;
    }

    private static void roundTrip(String s) throws Http2Exception {
        HpackHuffmanTest.roundTrip(new HpackHuffmanEncoder(), s);
    }

    private static void roundTrip(HpackHuffmanEncoder encoder, String s) throws Http2Exception {
        HpackHuffmanTest.roundTrip(encoder, s.getBytes());
    }

    private static void roundTrip(byte[] buf) throws Http2Exception {
        HpackHuffmanTest.roundTrip(new HpackHuffmanEncoder(), buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void roundTrip(HpackHuffmanEncoder encoder, byte[] buf) throws Http2Exception {
        ByteBuf buffer = Unpooled.buffer();
        try {
            encoder.encode(buffer, (CharSequence)new AsciiString(buf, false));
            byte[] bytes = new byte[buffer.readableBytes()];
            buffer.readBytes(bytes);
            byte[] actualBytes = HpackHuffmanTest.decode(bytes);
            Assertions.assertArrayEquals((byte[])buf, (byte[])actualBytes);
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] decode(byte[] bytes) throws Http2Exception {
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])bytes);
        try {
            AsciiString decoded = new HpackHuffmanDecoder().decode(buffer, buffer.readableBytes());
            Assertions.assertFalse((boolean)buffer.isReadable());
            byte[] byArray = decoded.toByteArray();
            return byArray;
        }
        finally {
            buffer.release();
        }
    }
}

