/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelConfig;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelPromise;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2Connection;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Connection;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Error;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Exception;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FlowController;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2RemoteFlowController;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Stream;
import org.apache.hive.druid.io.netty.handler.codec.http2.StreamByteDistributor;
import org.apache.hive.druid.io.netty.util.concurrent.EventExecutor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.opentest4j.AssertionFailedError;

public abstract class DefaultHttp2RemoteFlowControllerTest {
    private static final int STREAM_A = 1;
    private static final int STREAM_B = 3;
    private static final int STREAM_C = 5;
    private static final int STREAM_D = 7;
    private DefaultHttp2RemoteFlowController controller;
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private Channel channel;
    @Mock
    private ChannelConfig config;
    @Mock
    private EventExecutor executor;
    @Mock
    private ChannelPromise promise;
    @Mock
    private Http2RemoteFlowController.Listener listener;
    private DefaultHttp2Connection connection;

    @BeforeEach
    public void setup() throws Http2Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.ctx.newPromise()).thenReturn((Object)this.promise);
        Mockito.when((Object)this.ctx.flush()).thenThrow(new Throwable[]{new AssertionFailedError("forbidden")});
        this.setChannelWritability(true);
        Mockito.when((Object)this.channel.config()).thenReturn((Object)this.config);
        Mockito.when((Object)this.executor.inEventLoop()).thenReturn((Object)true);
        this.initConnectionAndController();
        this.resetCtx();
        this.controller.channelHandlerContext(this.ctx);
        this.assertWritabilityChanged(1, true);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
    }

    protected abstract StreamByteDistributor newDistributor(Http2Connection var1);

    private void initConnectionAndController() throws Http2Exception {
        this.connection = new DefaultHttp2Connection(false);
        this.controller = new DefaultHttp2RemoteFlowController((Http2Connection)this.connection, this.newDistributor((Http2Connection)this.connection), this.listener);
        this.connection.remote().flowController((Http2FlowController)this.controller);
        this.connection.local().createStream(1, false);
        this.connection.local().createStream(3, false);
        Http2Stream streamC = this.connection.local().createStream(5, false);
        Http2Stream streamD = this.connection.local().createStream(7, false);
        this.controller.updateDependencyTree(streamC.id(), 1, (short)16, false);
        this.controller.updateDependencyTree(streamD.id(), 1, (short)16, false);
    }

    @Test
    public void initialWindowSizeShouldOnlyChangeStreams() throws Http2Exception {
        this.controller.initialWindowSize(0);
        Assertions.assertEquals((int)65535, (int)this.window(0));
        Assertions.assertEquals((int)0, (int)this.window(1));
        Assertions.assertEquals((int)0, (int)this.window(3));
        Assertions.assertEquals((int)0, (int)this.window(5));
        Assertions.assertEquals((int)0, (int)this.window(7));
        this.assertWritabilityChanged(1, false);
    }

    @Test
    public void windowUpdateShouldChangeConnectionWindow() throws Http2Exception {
        this.incrementWindowSize(0, 100);
        Assertions.assertEquals((int)65635, (int)this.window(0));
        Assertions.assertEquals((int)65535, (int)this.window(1));
        Assertions.assertEquals((int)65535, (int)this.window(3));
        Assertions.assertEquals((int)65535, (int)this.window(5));
        Assertions.assertEquals((int)65535, (int)this.window(7));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void windowUpdateShouldChangeStreamWindow() throws Http2Exception {
        this.incrementWindowSize(1, 100);
        Assertions.assertEquals((int)65535, (int)this.window(0));
        Assertions.assertEquals((int)65635, (int)this.window(1));
        Assertions.assertEquals((int)65535, (int)this.window(3));
        Assertions.assertEquals((int)65535, (int)this.window(5));
        Assertions.assertEquals((int)65535, (int)this.window(7));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void payloadSmallerThanWindowShouldBeWrittenImmediately() throws Http2Exception {
        FakeFlowControlled data = new FakeFlowControlled(5);
        this.sendData(1, data);
        data.assertNotWritten();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.listener});
        this.controller.writePendingBytes();
        data.assertFullyWritten();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void emptyPayloadShouldBeWrittenImmediately() throws Http2Exception {
        FakeFlowControlled data = new FakeFlowControlled(0);
        this.sendData(1, data);
        data.assertNotWritten();
        this.controller.writePendingBytes();
        data.assertFullyWritten();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void unflushedPayloadsShouldBeDroppedOnCancel() throws Http2Exception {
        FakeFlowControlled data = new FakeFlowControlled(5);
        Http2Stream streamA = this.stream(1);
        this.sendData(1, data);
        streamA.close();
        this.controller.writePendingBytes();
        data.assertNotWritten();
        this.controller.writePendingBytes();
        data.assertNotWritten();
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(streamA);
        Assertions.assertFalse((boolean)this.controller.isWritable(streamA));
    }

    @Test
    public void payloadsShouldMerge() throws Http2Exception {
        this.controller.initialWindowSize(15);
        FakeFlowControlled data1 = new FakeFlowControlled(5, true);
        FakeFlowControlled data2 = new FakeFlowControlled(10, true);
        this.sendData(1, data1);
        this.sendData(1, data2);
        data1.assertNotWritten();
        data1.assertNotWritten();
        data2.assertMerged();
        this.controller.writePendingBytes();
        data1.assertFullyWritten();
        data2.assertNotWritten();
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(this.stream(1));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
    }

    @Test
    public void flowControllerCorrectlyAccountsForBytesWithMerge() throws Http2Exception {
        this.controller.initialWindowSize(112);
        FakeFlowControlled data1 = new FakeFlowControlled(5, 2, true);
        FakeFlowControlled data2 = new FakeFlowControlled(5, 100, true);
        this.sendData(1, data1);
        this.sendData(1, data2);
        data1.assertNotWritten();
        data1.assertNotWritten();
        data2.assertMerged();
        this.controller.writePendingBytes();
        data1.assertFullyWritten();
        data2.assertNotWritten();
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(1));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(1)));
    }

    @Test
    public void stalledStreamShouldQueuePayloads() throws Http2Exception {
        this.controller.initialWindowSize(0);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(this.stream(1));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        FakeFlowControlled data = new FakeFlowControlled(15);
        FakeFlowControlled moreData = new FakeFlowControlled(0);
        this.sendData(1, data);
        this.controller.writePendingBytes();
        data.assertNotWritten();
        this.sendData(1, moreData);
        this.controller.writePendingBytes();
        moreData.assertNotWritten();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void queuedPayloadsReceiveErrorOnStreamClose() throws Http2Exception {
        this.controller.initialWindowSize(0);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(this.stream(1));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        FakeFlowControlled data = new FakeFlowControlled(15);
        FakeFlowControlled moreData = new FakeFlowControlled(0);
        this.sendData(1, data);
        this.controller.writePendingBytes();
        data.assertNotWritten();
        this.sendData(1, moreData);
        this.controller.writePendingBytes();
        moreData.assertNotWritten();
        this.connection.stream(1).close();
        data.assertError(Http2Error.STREAM_CLOSED);
        moreData.assertError(Http2Error.STREAM_CLOSED);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void payloadLargerThanWindowShouldWritePartial() throws Http2Exception {
        this.controller.initialWindowSize(5);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(1));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(1)));
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        FakeFlowControlled data = new FakeFlowControlled(10);
        this.sendData(1, data);
        this.controller.writePendingBytes();
        data.assertPartiallyWritten(5);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(this.stream(1));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void windowUpdateAndFlushShouldTriggerWrite() throws Http2Exception {
        this.controller.initialWindowSize(10);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(1));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(1)));
        FakeFlowControlled data = new FakeFlowControlled(20);
        FakeFlowControlled moreData = new FakeFlowControlled(10);
        this.sendData(1, data);
        this.sendData(1, moreData);
        this.controller.writePendingBytes();
        data.assertPartiallyWritten(10);
        moreData.assertNotWritten();
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(this.stream(1));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        this.resetCtx();
        this.incrementWindowSize(1, 15);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(1));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        this.controller.writePendingBytes();
        data.assertFullyWritten();
        moreData.assertPartiallyWritten(5);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(1));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Assertions.assertEquals((int)65510, (int)this.window(0));
        Assertions.assertEquals((int)0, (int)this.window(1));
        Assertions.assertEquals((int)10, (int)this.window(3));
        Assertions.assertEquals((int)10, (int)this.window(5));
        Assertions.assertEquals((int)10, (int)this.window(7));
    }

    @Test
    public void initialWindowUpdateShouldSendPayload() throws Http2Exception {
        this.incrementWindowSize(0, -this.window(0) + 10);
        this.assertWritabilityChanged(0, true);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        this.controller.initialWindowSize(0);
        this.assertWritabilityChanged(1, false);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        FakeFlowControlled data = new FakeFlowControlled(10);
        this.sendData(1, data);
        this.controller.writePendingBytes();
        data.assertNotWritten();
        this.controller.initialWindowSize(10);
        data.assertFullyWritten();
        this.assertWritabilityChanged(0, false);
    }

    @Test
    public void successiveSendsShouldNotInteract() throws Http2Exception {
        this.incrementWindowSize(0, -this.window(0));
        Assertions.assertEquals((int)0, (int)this.window(0));
        this.assertWritabilityChanged(1, false);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        FakeFlowControlled dataA = new FakeFlowControlled(10);
        this.sendData(1, dataA);
        this.controller.writePendingBytes();
        dataA.assertNotWritten();
        this.incrementWindowSize(0, 8);
        this.assertWritabilityChanged(0, false);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        this.controller.writePendingBytes();
        dataA.assertPartiallyWritten(8);
        Assertions.assertEquals((int)65527, (int)this.window(1));
        Assertions.assertEquals((int)0, (int)this.window(0));
        this.assertWritabilityChanged(0, false);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        FakeFlowControlled dataB = new FakeFlowControlled(10);
        this.sendData(3, dataB);
        this.controller.writePendingBytes();
        dataB.assertNotWritten();
        this.incrementWindowSize(0, 12);
        this.assertWritabilityChanged(0, false);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        this.controller.writePendingBytes();
        Assertions.assertEquals((int)0, (int)this.window(0));
        this.assertWritabilityChanged(0, false);
        dataA.assertFullyWritten();
        Assertions.assertEquals((int)65525, (int)this.window(1));
        dataB.assertFullyWritten();
        Assertions.assertEquals((int)65525, (int)this.window(3));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void negativeWindowShouldNotThrowException() throws Http2Exception {
        int initWindow = 20;
        int secondWindowSize = 10;
        this.controller.initialWindowSize(20);
        this.assertWritabilityChanged(0, true);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        FakeFlowControlled data1 = new FakeFlowControlled(20);
        FakeFlowControlled data2 = new FakeFlowControlled(5);
        this.sendData(1, data1);
        this.controller.writePendingBytes();
        data1.assertFullyWritten();
        Assertions.assertTrue((this.window(0) > 0 ? 1 : 0) != 0);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(this.stream(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        this.controller.initialWindowSize(10);
        Assertions.assertEquals((int)-10, (int)this.window(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        this.sendData(1, data2);
        this.controller.writePendingBytes();
        data2.assertNotWritten();
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        this.incrementWindowSize(1, 5);
        this.controller.writePendingBytes();
        Assertions.assertEquals((int)-5, (int)this.window(1));
        data2.assertNotWritten();
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        this.incrementWindowSize(1, 5);
        this.controller.writePendingBytes();
        Assertions.assertEquals((int)0, (int)this.window(1));
        data2.assertNotWritten();
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        this.incrementWindowSize(1, 5);
        this.controller.writePendingBytes();
        data2.assertFullyWritten();
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
    }

    @Test
    public void initialWindowUpdateShouldSendEmptyFrame() throws Http2Exception {
        this.controller.initialWindowSize(0);
        this.assertWritabilityChanged(1, false);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        FakeFlowControlled data = new FakeFlowControlled(10, false);
        this.sendData(1, data);
        this.controller.writePendingBytes();
        data.assertNotWritten();
        FakeFlowControlled data2 = new FakeFlowControlled(0, false);
        this.sendData(1, data2);
        this.controller.writePendingBytes();
        data2.assertNotWritten();
        this.controller.initialWindowSize(10);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
        data.assertFullyWritten();
        data2.assertFullyWritten();
    }

    @Test
    public void initialWindowUpdateShouldSendPartialFrame() throws Http2Exception {
        this.controller.initialWindowSize(0);
        this.assertWritabilityChanged(1, false);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        FakeFlowControlled data = new FakeFlowControlled(10);
        this.sendData(1, data);
        this.controller.writePendingBytes();
        data.assertNotWritten();
        this.controller.initialWindowSize(5);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
        data.assertPartiallyWritten(5);
    }

    @Test
    public void connectionWindowUpdateShouldSendFrame() throws Http2Exception {
        this.exhaustStreamWindow(0);
        this.assertWritabilityChanged(1, false);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        FakeFlowControlled data = new FakeFlowControlled(10);
        this.sendData(1, data);
        this.controller.writePendingBytes();
        data.assertNotWritten();
        this.assertWritabilityChanged(0, false);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        this.incrementWindowSize(0, 10);
        this.assertWritabilityChanged(0, false);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        data.assertNotWritten();
        this.controller.writePendingBytes();
        data.assertFullyWritten();
        this.assertWritabilityChanged(0, false);
        Assertions.assertEquals((int)0, (int)this.window(0));
        Assertions.assertEquals((int)65525, (int)this.window(1));
        Assertions.assertEquals((int)65535, (int)this.window(3));
        Assertions.assertEquals((int)65535, (int)this.window(5));
        Assertions.assertEquals((int)65535, (int)this.window(7));
    }

    @Test
    public void connectionWindowUpdateShouldSendPartialFrame() throws Http2Exception {
        this.exhaustStreamWindow(0);
        this.assertWritabilityChanged(1, false);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        FakeFlowControlled data = new FakeFlowControlled(10);
        this.sendData(1, data);
        this.controller.writePendingBytes();
        data.assertNotWritten();
        this.incrementWindowSize(0, 5);
        data.assertNotWritten();
        this.assertWritabilityChanged(0, false);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        this.controller.writePendingBytes();
        data.assertPartiallyWritten(5);
        this.assertWritabilityChanged(0, false);
        Assertions.assertEquals((int)0, (int)this.window(0));
        Assertions.assertEquals((int)65530, (int)this.window(1));
        Assertions.assertEquals((int)65535, (int)this.window(3));
        Assertions.assertEquals((int)65535, (int)this.window(5));
        Assertions.assertEquals((int)65535, (int)this.window(7));
    }

    @Test
    public void streamWindowUpdateShouldSendFrame() throws Http2Exception {
        this.exhaustStreamWindow(1);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(this.stream(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        FakeFlowControlled data = new FakeFlowControlled(10);
        this.sendData(1, data);
        this.controller.writePendingBytes();
        data.assertNotWritten();
        this.incrementWindowSize(1, 10);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        data.assertNotWritten();
        this.controller.writePendingBytes();
        data.assertFullyWritten();
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
        Assertions.assertEquals((int)65525, (int)this.window(0));
        Assertions.assertEquals((int)0, (int)this.window(1));
        Assertions.assertEquals((int)65535, (int)this.window(3));
        Assertions.assertEquals((int)65535, (int)this.window(5));
        Assertions.assertEquals((int)65535, (int)this.window(7));
    }

    @Test
    public void streamWindowUpdateShouldSendPartialFrame() throws Http2Exception {
        this.exhaustStreamWindow(1);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(this.stream(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        FakeFlowControlled data = new FakeFlowControlled(10);
        this.sendData(1, data);
        this.controller.writePendingBytes();
        data.assertNotWritten();
        this.incrementWindowSize(1, 5);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        data.assertNotWritten();
        this.controller.writePendingBytes();
        data.assertPartiallyWritten(5);
        Assertions.assertEquals((int)65530, (int)this.window(0));
        Assertions.assertEquals((int)0, (int)this.window(1));
        Assertions.assertEquals((int)65535, (int)this.window(3));
        Assertions.assertEquals((int)65535, (int)this.window(5));
        Assertions.assertEquals((int)65535, (int)this.window(7));
    }

    @Test
    public void flowControlledWriteThrowsAnException() throws Exception {
        Http2RemoteFlowController.FlowControlled flowControlled = DefaultHttp2RemoteFlowControllerTest.mockedFlowControlledThatThrowsOnWrite();
        final Http2Stream stream = this.stream(1);
        ((Http2RemoteFlowController.FlowControlled)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) {
                stream.closeLocalSide();
                return null;
            }
        }).when((Object)flowControlled)).error((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), (Throwable)Mockito.any(Throwable.class));
        int windowBefore = this.window(1);
        this.controller.addFlowControlled(stream, flowControlled);
        this.controller.writePendingBytes();
        ((Http2RemoteFlowController.FlowControlled)Mockito.verify((Object)flowControlled, (VerificationMode)Mockito.atLeastOnce())).write((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt());
        ((Http2RemoteFlowController.FlowControlled)Mockito.verify((Object)flowControlled)).error((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), (Throwable)Mockito.any(Throwable.class));
        ((Http2RemoteFlowController.FlowControlled)Mockito.verify((Object)flowControlled, (VerificationMode)Mockito.never())).writeComplete();
        Assertions.assertEquals((int)90, (int)(windowBefore - this.window(1)));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(this.stream(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
    }

    @Test
    public void flowControlledWriteAndErrorThrowAnException() throws Exception {
        final Http2RemoteFlowController.FlowControlled flowControlled = DefaultHttp2RemoteFlowControllerTest.mockedFlowControlledThatThrowsOnWrite();
        final Http2Stream stream = this.stream(1);
        final RuntimeException fakeException = new RuntimeException("error failed");
        ((Http2RemoteFlowController.FlowControlled)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) {
                throw fakeException;
            }
        }).when((Object)flowControlled)).error((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), (Throwable)Mockito.any(Throwable.class));
        int windowBefore = this.window(1);
        Http2Exception e = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2RemoteFlowControllerTest.this.controller.addFlowControlled(stream, flowControlled);
                DefaultHttp2RemoteFlowControllerTest.this.controller.writePendingBytes();
            }
        });
        Assertions.assertSame((Object)fakeException, (Object)e.getCause());
        ((Http2RemoteFlowController.FlowControlled)Mockito.verify((Object)flowControlled, (VerificationMode)Mockito.atLeastOnce())).write((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt());
        ((Http2RemoteFlowController.FlowControlled)Mockito.verify((Object)flowControlled)).error((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), (Throwable)Mockito.any(Throwable.class));
        ((Http2RemoteFlowController.FlowControlled)Mockito.verify((Object)flowControlled, (VerificationMode)Mockito.never())).writeComplete();
        Assertions.assertEquals((int)90, (int)(windowBefore - this.window(1)));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void flowControlledWriteCompleteThrowsAnException() throws Exception {
        Http2RemoteFlowController.FlowControlled flowControlled = (Http2RemoteFlowController.FlowControlled)Mockito.mock(Http2RemoteFlowController.FlowControlled.class);
        Http2Stream streamA = this.stream(1);
        final AtomicInteger size = new AtomicInteger(150);
        ((Http2RemoteFlowController.FlowControlled)Mockito.doAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocationOnMock) throws Throwable {
                return size.get();
            }
        }).when((Object)flowControlled)).size();
        ((Http2RemoteFlowController.FlowControlled)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                size.addAndGet(-50);
                return null;
            }
        }).when((Object)flowControlled)).write((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt());
        Http2Stream stream = this.stream(1);
        ((Http2RemoteFlowController.FlowControlled)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) {
                throw new RuntimeException("writeComplete failed");
            }
        }).when((Object)flowControlled)).writeComplete();
        int windowBefore = this.window(1);
        this.controller.addFlowControlled(stream, flowControlled);
        this.controller.writePendingBytes();
        ((Http2RemoteFlowController.FlowControlled)Mockito.verify((Object)flowControlled, (VerificationMode)Mockito.times((int)3))).write((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt());
        ((Http2RemoteFlowController.FlowControlled)Mockito.verify((Object)flowControlled, (VerificationMode)Mockito.never())).error((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), (Throwable)Mockito.any(Throwable.class));
        ((Http2RemoteFlowController.FlowControlled)Mockito.verify((Object)flowControlled)).writeComplete();
        Assertions.assertEquals((int)150, (int)(windowBefore - this.window(1)));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(streamA);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(streamA));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
    }

    @Test
    public void closeStreamInFlowControlledError() throws Exception {
        Http2RemoteFlowController.FlowControlled flowControlled = (Http2RemoteFlowController.FlowControlled)Mockito.mock(Http2RemoteFlowController.FlowControlled.class);
        final Http2Stream stream = this.stream(1);
        Mockito.when((Object)flowControlled.size()).thenReturn((Object)100);
        ((Http2RemoteFlowController.FlowControlled)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("write failed")}).when((Object)flowControlled)).write((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt());
        ((Http2RemoteFlowController.FlowControlled)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) {
                stream.close();
                return null;
            }
        }).when((Object)flowControlled)).error((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), (Throwable)Mockito.any(Throwable.class));
        this.controller.addFlowControlled(stream, flowControlled);
        this.controller.writePendingBytes();
        ((Http2RemoteFlowController.FlowControlled)Mockito.verify((Object)flowControlled)).write((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt());
        ((Http2RemoteFlowController.FlowControlled)Mockito.verify((Object)flowControlled)).error((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), (Throwable)Mockito.any(Throwable.class));
        ((Http2RemoteFlowController.FlowControlled)Mockito.verify((Object)flowControlled, (VerificationMode)Mockito.never())).writeComplete();
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).writabilityChanged(stream);
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).writabilityChanged(this.stream(7));
        Assertions.assertFalse((boolean)this.controller.isWritable(stream));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
        Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
    }

    @Test
    public void nonWritableChannelDoesNotAttemptToWrite() throws Exception {
        this.setChannelWritability(false);
        this.assertWritabilityChanged(1, false);
        Mockito.reset((Object[])new Http2RemoteFlowController.Listener[]{this.listener});
        FakeFlowControlled dataA = new FakeFlowControlled(1);
        FakeFlowControlled dataB = new FakeFlowControlled(1);
        Http2Stream stream = this.stream(1);
        this.controller.addFlowControlled(stream, (Http2RemoteFlowController.FlowControlled)dataA);
        this.controller.writePendingBytes();
        dataA.assertNotWritten();
        this.controller.incrementWindowSize(stream, 100);
        this.controller.writePendingBytes();
        dataA.assertNotWritten();
        this.controller.addFlowControlled(stream, (Http2RemoteFlowController.FlowControlled)dataB);
        this.controller.writePendingBytes();
        dataA.assertNotWritten();
        dataB.assertNotWritten();
        this.assertWritabilityChanged(0, false);
        this.setChannelWritability(true);
        this.assertWritabilityChanged(1, true);
        this.controller.writePendingBytes();
        dataA.assertFullyWritten();
        dataB.assertFullyWritten();
    }

    @Test
    public void contextShouldSendQueuedFramesWhenSet() throws Exception {
        this.initConnectionAndController();
        FakeFlowControlled dataA = new FakeFlowControlled(1);
        Http2Stream stream = this.stream(1);
        this.controller.addFlowControlled(stream, (Http2RemoteFlowController.FlowControlled)dataA);
        dataA.assertNotWritten();
        this.controller.incrementWindowSize(stream, 100);
        dataA.assertNotWritten();
        this.assertWritabilityChanged(0, false);
        this.controller.channelHandlerContext(this.ctx);
        dataA.assertFullyWritten();
        this.assertWritabilityChanged(1, true);
    }

    @Test
    public void initialWindowSizeWithNoContextShouldNotThrow() throws Exception {
        this.initConnectionAndController();
        this.controller.initialWindowSize(102400);
        FakeFlowControlled dataA = new FakeFlowControlled(1);
        Http2Stream stream = this.stream(1);
        this.controller.addFlowControlled(stream, (Http2RemoteFlowController.FlowControlled)dataA);
        dataA.assertNotWritten();
        this.controller.channelHandlerContext(this.ctx);
        dataA.assertFullyWritten();
    }

    @Test
    public void invalidParentStreamIdThrows() {
        Assertions.assertThrows(AssertionError.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2RemoteFlowControllerTest.this.controller.updateDependencyTree(7, -1, (short)16, true);
            }
        });
    }

    @Test
    public void invalidChildStreamIdThrows() {
        Assertions.assertThrows(AssertionError.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2RemoteFlowControllerTest.this.controller.updateDependencyTree(-1, 7, (short)16, true);
            }
        });
    }

    @Test
    public void connectionChildStreamIdThrows() {
        Assertions.assertThrows(AssertionError.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2RemoteFlowControllerTest.this.controller.updateDependencyTree(0, 7, (short)16, true);
            }
        });
    }

    @Test
    public void invalidWeightTooSmallThrows() {
        Assertions.assertThrows(AssertionError.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2RemoteFlowControllerTest.this.controller.updateDependencyTree(1, 7, (short)0, true);
            }
        });
    }

    @Test
    public void invalidWeightTooBigThrows() {
        Assertions.assertThrows(AssertionError.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2RemoteFlowControllerTest.this.controller.updateDependencyTree(1, 7, (short)257, true);
            }
        });
    }

    @Test
    public void dependencyOnSelfThrows() {
        Assertions.assertThrows(AssertionError.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2RemoteFlowControllerTest.this.controller.updateDependencyTree(1, 1, (short)16, true);
            }
        });
    }

    private void assertWritabilityChanged(int amt, boolean writable) {
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)amt))).writabilityChanged(this.stream(1));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)amt))).writabilityChanged(this.stream(3));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)amt))).writabilityChanged(this.stream(5));
        ((Http2RemoteFlowController.Listener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)amt))).writabilityChanged(this.stream(7));
        if (writable) {
            Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(1)));
            Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(3)));
            Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(5)));
            Assertions.assertTrue((boolean)this.controller.isWritable(this.stream(7)));
        } else {
            Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(1)));
            Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(3)));
            Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(5)));
            Assertions.assertFalse((boolean)this.controller.isWritable(this.stream(7)));
        }
    }

    private static Http2RemoteFlowController.FlowControlled mockedFlowControlledThatThrowsOnWrite() throws Exception {
        final Http2RemoteFlowController.FlowControlled flowControlled = (Http2RemoteFlowController.FlowControlled)Mockito.mock(Http2RemoteFlowController.FlowControlled.class);
        Mockito.when((Object)flowControlled.size()).thenReturn((Object)100);
        ((Http2RemoteFlowController.FlowControlled)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock in) throws Throwable {
                Mockito.when((Object)flowControlled.size()).thenReturn((Object)10);
                throw new RuntimeException("Write failed");
            }
        }).when((Object)flowControlled)).write((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt());
        return flowControlled;
    }

    private void sendData(int streamId, FakeFlowControlled data) {
        Http2Stream stream = this.stream(streamId);
        this.controller.addFlowControlled(stream, (Http2RemoteFlowController.FlowControlled)data);
    }

    private void exhaustStreamWindow(int streamId) throws Http2Exception {
        this.incrementWindowSize(streamId, -this.window(streamId));
    }

    private int window(int streamId) {
        return this.controller.windowSize(this.stream(streamId));
    }

    private void incrementWindowSize(int streamId, int delta) throws Http2Exception {
        this.controller.incrementWindowSize(this.stream(streamId), delta);
    }

    private Http2Stream stream(int streamId) {
        return this.connection.stream(streamId);
    }

    private void resetCtx() {
        Mockito.reset((Object[])new ChannelHandlerContext[]{this.ctx});
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.ctx.executor()).thenReturn((Object)this.executor);
    }

    private void setChannelWritability(boolean isWritable) throws Http2Exception {
        Mockito.when((Object)this.channel.bytesBeforeUnwritable()).thenReturn((Object)(isWritable ? Long.MAX_VALUE : 0L));
        Mockito.when((Object)this.channel.isWritable()).thenReturn((Object)isWritable);
        if (this.controller != null) {
            this.controller.channelWritabilityChanged();
        }
    }

    private static final class FakeFlowControlled
    implements Http2RemoteFlowController.FlowControlled {
        private int currentPadding;
        private int currentPayloadSize;
        private int originalPayloadSize;
        private int originalPadding;
        private boolean writeCalled;
        private final boolean mergeable;
        private boolean merged;
        private Throwable t;

        private FakeFlowControlled(int size) {
            this(size, false);
        }

        private FakeFlowControlled(int size, boolean mergeable) {
            this(size, 0, mergeable);
        }

        private FakeFlowControlled(int payloadSize, int padding, boolean mergeable) {
            this.currentPayloadSize = this.originalPayloadSize = payloadSize;
            this.currentPadding = this.originalPadding = padding;
            this.mergeable = mergeable;
        }

        public int size() {
            return this.currentPayloadSize + this.currentPadding;
        }

        private int originalSize() {
            return this.originalPayloadSize + this.originalPadding;
        }

        public void error(ChannelHandlerContext ctx, Throwable t) {
            this.t = t;
        }

        public void writeComplete() {
        }

        public void write(ChannelHandlerContext ctx, int allowedBytes) {
            if (allowedBytes <= 0 && this.size() != 0) {
                return;
            }
            this.writeCalled = true;
            int written = Math.min(this.size(), allowedBytes);
            if (written > this.currentPayloadSize) {
                this.currentPayloadSize = 0;
                this.currentPadding -= (written -= this.currentPayloadSize);
            } else {
                this.currentPayloadSize -= written;
            }
        }

        public boolean merge(ChannelHandlerContext ctx, Http2RemoteFlowController.FlowControlled next) {
            if (this.mergeable && next instanceof FakeFlowControlled) {
                FakeFlowControlled ffcNext = (FakeFlowControlled)next;
                this.originalPayloadSize += ffcNext.originalPayloadSize;
                this.currentPayloadSize += ffcNext.originalPayloadSize;
                this.currentPadding = this.originalPadding = Math.max(this.originalPadding, ffcNext.originalPadding);
                ffcNext.merged = true;
                return true;
            }
            return false;
        }

        public int written() {
            return this.originalSize() - this.size();
        }

        public void assertNotWritten() {
            Assertions.assertFalse((boolean)this.writeCalled);
        }

        public void assertPartiallyWritten(int expectedWritten) {
            this.assertPartiallyWritten(expectedWritten, 0);
        }

        public void assertPartiallyWritten(int expectedWritten, int delta) {
            Assertions.assertTrue((boolean)this.writeCalled);
            Assertions.assertEquals((float)expectedWritten, (float)this.written(), (float)delta);
        }

        public void assertFullyWritten() {
            Assertions.assertTrue((boolean)this.writeCalled);
            Assertions.assertEquals((int)0, (int)this.currentPayloadSize);
            Assertions.assertEquals((int)0, (int)this.currentPadding);
        }

        public boolean assertMerged() {
            return this.merged;
        }

        public void assertError(Http2Error error) {
            Assertions.assertNotNull((Object)this.t);
            if (error != null) {
                Assertions.assertSame((Object)error, (Object)((Http2Exception)this.t).error());
            }
        }
    }
}

