/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.dns;

import java.net.InetAddress;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.socket.InternetProtocolFamily;
import org.apache.hive.druid.io.netty.handler.codec.dns.DefaultDnsOptEcsRecord;
import org.apache.hive.druid.io.netty.handler.codec.dns.DefaultDnsRecordEncoder;
import org.apache.hive.druid.io.netty.handler.codec.dns.DnsRecord;
import org.apache.hive.druid.io.netty.handler.codec.dns.DnsRecordType;
import org.apache.hive.druid.io.netty.util.internal.PlatformDependent;
import org.apache.hive.druid.io.netty.util.internal.SocketUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultDnsRecordEncoderTest {
    @Test
    public void testEncodeName() throws Exception {
        DefaultDnsRecordEncoderTest.testEncodeName(new byte[]{5, 110, 101, 116, 116, 121, 2, 105, 111, 0}, "netty.io.");
    }

    @Test
    public void testEncodeNameWithoutTerminator() throws Exception {
        DefaultDnsRecordEncoderTest.testEncodeName(new byte[]{5, 110, 101, 116, 116, 121, 2, 105, 111, 0}, "netty.io");
    }

    @Test
    public void testEncodeNameWithExtraTerminator() throws Exception {
        DefaultDnsRecordEncoderTest.testEncodeName(new byte[]{5, 110, 101, 116, 116, 121, 2, 105, 111, 0}, "netty.io..");
    }

    @Test
    public void testEncodeEmptyName() throws Exception {
        DefaultDnsRecordEncoderTest.testEncodeName(new byte[]{0}, "");
    }

    @Test
    public void testEncodeRootName() throws Exception {
        DefaultDnsRecordEncoderTest.testEncodeName(new byte[]{0}, ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testEncodeName(byte[] expected, String name) throws Exception {
        DefaultDnsRecordEncoder encoder = new DefaultDnsRecordEncoder();
        ByteBuf out = Unpooled.buffer();
        ByteBuf expectedBuf = Unpooled.wrappedBuffer((byte[])expected);
        try {
            encoder.encodeName(name, out);
            Assertions.assertEquals((Object)expectedBuf, (Object)out);
        }
        finally {
            out.release();
            expectedBuf.release();
        }
    }

    @Test
    public void testOptEcsRecordIpv4() throws Exception {
        DefaultDnsRecordEncoderTest.testOptEcsRecordIp(SocketUtils.addressByName((String)"1.2.3.4"));
        DefaultDnsRecordEncoderTest.testOptEcsRecordIp(SocketUtils.addressByName((String)"1.2.3.255"));
    }

    @Test
    public void testOptEcsRecordIpv6() throws Exception {
        DefaultDnsRecordEncoderTest.testOptEcsRecordIp(SocketUtils.addressByName((String)"::0"));
        DefaultDnsRecordEncoderTest.testOptEcsRecordIp(SocketUtils.addressByName((String)"::FF"));
    }

    private static void testOptEcsRecordIp(InetAddress address) throws Exception {
        int addressBits = address.getAddress().length * 8;
        for (int i = 0; i <= addressBits; ++i) {
            DefaultDnsRecordEncoderTest.testIp(address, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testIp(InetAddress address, int prefix) throws Exception {
        int lowOrderBitsToPreserve = prefix % 8;
        ByteBuf addressPart = Unpooled.wrappedBuffer((byte[])address.getAddress(), (int)0, (int)DefaultDnsRecordEncoder.calculateEcsAddressLength((int)prefix, (int)lowOrderBitsToPreserve));
        if (lowOrderBitsToPreserve > 0) {
            int idx = addressPart.writerIndex() - 1;
            byte lastByte = addressPart.getByte(idx);
            int paddingMask = -1 << 8 - lowOrderBitsToPreserve;
            addressPart.setByte(idx, lastByte & paddingMask);
        }
        int payloadSize = DefaultDnsRecordEncoderTest.nextInt(Short.MAX_VALUE);
        int extendedRcode = DefaultDnsRecordEncoderTest.nextInt(254);
        int version = DefaultDnsRecordEncoderTest.nextInt(254);
        DefaultDnsRecordEncoder encoder = new DefaultDnsRecordEncoder();
        ByteBuf out = Unpooled.buffer();
        try {
            DefaultDnsOptEcsRecord record = new DefaultDnsOptEcsRecord(payloadSize, extendedRcode, version, prefix, address.getAddress());
            encoder.encodeRecord((DnsRecord)record, out);
            Assertions.assertEquals((int)0, (int)out.readByte());
            Assertions.assertEquals((int)DnsRecordType.OPT.intValue(), (int)out.readUnsignedShort());
            Assertions.assertEquals((int)payloadSize, (int)out.readUnsignedShort());
            Assertions.assertEquals((long)record.timeToLive(), (long)out.getUnsignedInt(out.readerIndex()));
            Assertions.assertEquals((int)extendedRcode, (int)out.readUnsignedByte());
            Assertions.assertEquals((int)version, (int)out.readUnsignedByte());
            Assertions.assertEquals((int)extendedRcode, (int)record.extendedRcode());
            Assertions.assertEquals((int)version, (int)record.version());
            Assertions.assertEquals((int)0, (int)record.flags());
            Assertions.assertEquals((int)0, (int)out.readShort());
            int payloadLength = out.readUnsignedShort();
            Assertions.assertEquals((int)payloadLength, (int)out.readableBytes());
            Assertions.assertEquals((int)8, (int)out.readShort());
            int rdataLength = out.readUnsignedShort();
            Assertions.assertEquals((int)rdataLength, (int)out.readableBytes());
            Assertions.assertEquals((short)((short)InternetProtocolFamily.of((InetAddress)address).addressNumber()), (short)out.readShort());
            Assertions.assertEquals((int)prefix, (int)out.readUnsignedByte());
            Assertions.assertEquals((int)0, (int)out.readUnsignedByte());
            Assertions.assertEquals((Object)addressPart, (Object)out);
        }
        finally {
            addressPart.release();
            out.release();
        }
    }

    private static int nextInt(int max) {
        return PlatformDependent.threadLocalRandom().nextInt(max);
    }
}

