/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.kqueue;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.hive.druid.io.netty.channel.kqueue.BsdSocket;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueue;
import org.apache.hive.druid.io.netty.channel.unix.DomainSocketAddress;
import org.apache.hive.druid.io.netty.channel.unix.PeerCredentials;
import org.apache.hive.druid.io.netty.channel.unix.tests.SocketTest;
import org.apache.hive.druid.io.netty.channel.unix.tests.UnixTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KQueueSocketTest
extends SocketTest<BsdSocket> {
    @BeforeAll
    public static void loadJNI() {
        KQueue.ensureAvailability();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeerCreds() throws IOException {
        BsdSocket s1 = BsdSocket.newSocketDomain();
        BsdSocket s2 = BsdSocket.newSocketDomain();
        try {
            DomainSocketAddress dsa = UnixTestUtils.newDomainSocketAddress();
            s1.bind((SocketAddress)dsa);
            s1.listen(1);
            Assertions.assertTrue((boolean)s2.connect((SocketAddress)dsa));
            byte[] addr = new byte[64];
            s1.accept(addr);
            PeerCredentials pc = s1.getPeerCredentials();
            Assertions.assertNotEquals((int)pc.uid(), (int)-1);
        }
        finally {
            s1.close();
            s2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeerPID() throws IOException {
        BsdSocket s1 = BsdSocket.newSocketDomain();
        BsdSocket s2 = BsdSocket.newSocketDomain();
        try {
            DomainSocketAddress dsa = UnixTestUtils.newDomainSocketAddress();
            s1.bind((SocketAddress)dsa);
            s1.listen(1);
            Assertions.assertEquals((int)0, (int)s2.getPeerCredentials().pid());
            Assertions.assertTrue((boolean)s2.connect((SocketAddress)dsa));
            byte[] addr = new byte[64];
            int clientFd = s1.accept(addr);
            Assertions.assertNotEquals((int)-1, (int)clientFd);
            PeerCredentials pc = new BsdSocket(clientFd).getPeerCredentials();
            Assertions.assertNotEquals((int)0, (int)pc.pid());
            Assertions.assertNotEquals((int)0, (int)s2.getPeerCredentials().pid());
            Assertions.assertEquals((int)0, (int)s1.getPeerCredentials().pid());
        }
        finally {
            s1.close();
            s2.close();
        }
    }

    protected BsdSocket newSocket() {
        return BsdSocket.newSocketStream();
    }

    protected int level() {
        return 65535;
    }

    protected int optname() {
        return 4;
    }
}

