/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.shard;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.timeline.partition.SingleDimensionShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class SingleDimensionShardSpecTest {
    @Test
    public void testIsInChunk() throws Exception {
        ImmutableMap tests = ImmutableMap.builder().put((Object)this.makeSpec(null, null), this.makeList(true, null, true, "a", true, "h", true, "p", true, "y")).put((Object)this.makeSpec(null, "m"), this.makeList(true, null, true, "a", true, "h", false, "p", false, "y")).put((Object)this.makeSpec("a", "h"), this.makeList(false, null, true, "a", false, "h", false, "p", false, "y")).put((Object)this.makeSpec("d", "u"), this.makeList(false, null, false, "a", true, "h", true, "p", false, "y")).put((Object)this.makeSpec("h", null), this.makeList(false, null, false, "a", true, "h", true, "p", true, "y")).build();
        for (Map.Entry entry : tests.entrySet()) {
            SingleDimensionShardSpec spec = (SingleDimensionShardSpec)entry.getKey();
            for (Pair pair : (List)entry.getValue()) {
                MapBasedInputRow inputRow = new MapBasedInputRow(0L, (List)ImmutableList.of((Object)"billy"), Maps.transformValues((Map)((Map)pair.rhs), input -> input));
                Assert.assertEquals((String)StringUtils.format((String)"spec[%s], row[%s]", (Object[])new Object[]{spec, inputRow}), (Object)pair.lhs, (Object)spec.isInChunk(inputRow.getTimestampFromEpoch(), (InputRow)inputRow));
            }
        }
    }

    private SingleDimensionShardSpec makeSpec(String start, String end) {
        return new SingleDimensionShardSpec("billy", start, end, 0);
    }

    private Map<String, String> makeMap(String value) {
        return value == null ? ImmutableMap.of() : ImmutableMap.of((Object)"billy", (Object)value);
    }

    private List<Pair<Boolean, Map<String, String>>> makeList(Object ... arguments) {
        Preconditions.checkState((arguments.length % 2 == 0 ? 1 : 0) != 0);
        ArrayList retVal = Lists.newArrayList();
        for (int i = 0; i < arguments.length; i += 2) {
            retVal.add(Pair.of((Object)((Boolean)arguments[i]), this.makeMap((String)arguments[i + 1])));
        }
        return retVal;
    }
}

