/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.router;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.js.JavaScriptConfig;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryBuilder;
import org.apache.hive.druid.io.druid.server.router.JavaScriptTieredBrokerSelectorStrategy;
import org.apache.hive.druid.io.druid.server.router.TieredBrokerConfig;
import org.apache.hive.druid.io.druid.server.router.TieredBrokerSelectorStrategy;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JavaScriptTieredBrokerSelectorStrategyTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final TieredBrokerSelectorStrategy STRATEGY = new JavaScriptTieredBrokerSelectorStrategy("function (config, query) { if (query.getAggregatorSpecs && query.getDimensionSpec && query.getDimensionSpec().getDimension() == 'bigdim' && query.getAggregatorSpecs().size() >= 3) { var size = config.getTierToBrokerMap().values().size(); if (size > 0) { return config.getTierToBrokerMap().values().toArray()[size-1] } else { return config.getDefaultBrokerServiceName() } } else { return null } }", JavaScriptConfig.getEnabledInstance());

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(JavaScriptConfig.class, (Object)JavaScriptConfig.getEnabledInstance()));
        Assert.assertEquals((Object)this.STRATEGY, (Object)mapper.readValue(mapper.writeValueAsString((Object)this.STRATEGY), JavaScriptTieredBrokerSelectorStrategy.class));
    }

    @Test
    public void testDisabled() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(JavaScriptConfig.class, (Object)new JavaScriptConfig(false)));
        String strategyString = mapper.writeValueAsString((Object)this.STRATEGY);
        this.expectedException.expect(JsonMappingException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(IllegalStateException.class));
        this.expectedException.expectMessage("JavaScript is disabled");
        mapper.readValue(strategyString, JavaScriptTieredBrokerSelectorStrategy.class);
    }

    @Test
    public void testGetBrokerServiceName() throws Exception {
        final LinkedHashMap<String, String> tierBrokerMap = new LinkedHashMap<String, String>();
        tierBrokerMap.put("fast", "druid/fastBroker");
        tierBrokerMap.put("fast", "druid/broker");
        tierBrokerMap.put("slow", "druid/slowBroker");
        TieredBrokerConfig tieredBrokerConfig = new TieredBrokerConfig(){

            public String getDefaultBrokerServiceName() {
                return "druid/broker";
            }

            public LinkedHashMap<String, String> getTierToBrokerMap() {
                return tierBrokerMap;
            }
        };
        TopNQueryBuilder queryBuilder = new TopNQueryBuilder().dataSource("test").intervals("2014/2015").dimension("bigdim").metric("count").threshold(1).aggregators((List)ImmutableList.of((Object)new CountAggregatorFactory("count")));
        Assert.assertEquals((Object)Optional.absent(), (Object)this.STRATEGY.getBrokerServiceName(tieredBrokerConfig, (Query)queryBuilder.build()));
        Assert.assertEquals((Object)Optional.absent(), (Object)this.STRATEGY.getBrokerServiceName(tieredBrokerConfig, (Query)Druids.newTimeBoundaryQueryBuilder().dataSource("test").bound("maxTime").build()));
        Assert.assertEquals((Object)Optional.of((Object)"druid/slowBroker"), (Object)this.STRATEGY.getBrokerServiceName(tieredBrokerConfig, (Query)queryBuilder.aggregators((List)ImmutableList.of((Object)new CountAggregatorFactory("count"), (Object)new LongSumAggregatorFactory("longSum", "a"), (Object)new DoubleSumAggregatorFactory("doubleSum", "b"))).build()));
        tierBrokerMap.clear();
        Assert.assertEquals((Object)Optional.of((Object)"druid/broker"), (Object)this.STRATEGY.getBrokerServiceName(tieredBrokerConfig, (Query)queryBuilder.aggregators((List)ImmutableList.of((Object)new CountAggregatorFactory("count"), (Object)new LongSumAggregatorFactory("longSum", "a"), (Object)new DoubleSumAggregatorFactory("doubleSum", "b"))).build()));
    }
}

