/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.initialization;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.commons.io.IOUtils;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.io.druid.guice.GuiceInjectors;
import org.apache.hive.druid.io.druid.guice.Jerseys;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.LifecycleModule;
import org.apache.hive.druid.io.druid.guice.annotations.Self;
import org.apache.hive.druid.io.druid.initialization.Initialization;
import org.apache.hive.druid.io.druid.java.util.http.client.Request;
import org.apache.hive.druid.io.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.io.druid.java.util.http.client.response.InputStreamResponseHandler;
import org.apache.hive.druid.io.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.hive.druid.io.druid.server.DruidNode;
import org.apache.hive.druid.io.druid.server.initialization.BaseJettyTest;
import org.apache.hive.druid.io.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.hive.druid.io.druid.server.initialization.jetty.ServletFilterHolder;
import org.apache.hive.druid.io.druid.server.security.AuthTestUtils;
import org.apache.hive.druid.io.druid.server.security.AuthorizerMapper;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.eclipse.jetty.server.Server;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class JettyTest
extends BaseJettyTest {
    @Override
    protected Injector setupInjector() {
        return Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("test", "localhost", null, null, true, false));
                binder.bind(JettyServerInitializer.class).to(BaseJettyTest.JettyServerInit.class).in(LazySingleton.class);
                Multibinder multibinder = Multibinder.newSetBinder((Binder)binder, ServletFilterHolder.class);
                multibinder.addBinding().toInstance((Object)new ServletFilterHolder(){

                    public String getPath() {
                        return "/*";
                    }

                    public Map<String, String> getInitParameters() {
                        return null;
                    }

                    public Class<? extends Filter> getFilterClass() {
                        return BaseJettyTest.DummyAuthFilter.class;
                    }

                    public Filter getFilter() {
                        return null;
                    }

                    public EnumSet<DispatcherType> getDispatcherType() {
                        return null;
                    }
                });
                Jerseys.addResource((Binder)binder, BaseJettyTest.SlowResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.ExceptionResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.DefaultResource.class);
                binder.bind(AuthorizerMapper.class).toInstance((Object)AuthTestUtils.TEST_AUTHORIZER_MAPPER);
                LifecycleModule.register((Binder)binder, Server.class);
            }
        }));
    }

    @Test
    @Ignore
    public void testTimeouts() throws Exception {
        final ExecutorService executor = Executors.newFixedThreadPool(100);
        final AtomicLong count = new AtomicLong(0L);
        final CountDownLatch latch = new CountDownLatch(1000);
        for (int i = 0; i < 10000; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            long startTime = System.currentTimeMillis();
                            long startTime2 = 0L;
                            try {
                                ListenableFuture go = JettyTest.this.client.go(new Request(HttpMethod.GET, new URL("http://localhost:" + JettyTest.this.port + "/slow/hello")), (HttpResponseHandler)new StatusResponseHandler(Charset.defaultCharset()));
                                startTime2 = System.currentTimeMillis();
                                go.get();
                            }
                            catch (Exception e) {
                                try {
                                    e.printStackTrace();
                                }
                                catch (Throwable throwable) {
                                    System.out.printf(Locale.ENGLISH, "Response time client%dtime taken for getting future%dCounter %d%n", System.currentTimeMillis() - startTime, System.currentTimeMillis() - startTime2, count.incrementAndGet());
                                    latch.countDown();
                                    throw throwable;
                                }
                                System.out.printf(Locale.ENGLISH, "Response time client%dtime taken for getting future%dCounter %d%n", System.currentTimeMillis() - startTime, System.currentTimeMillis() - startTime2, count.incrementAndGet());
                                latch.countDown();
                            }
                            System.out.printf(Locale.ENGLISH, "Response time client%dtime taken for getting future%dCounter %d%n", System.currentTimeMillis() - startTime, System.currentTimeMillis() - startTime2, count.incrementAndGet());
                            latch.countDown();
                        }
                    });
                }
            });
        }
        latch.await();
    }

    @Test
    public void testGzipCompression() throws Exception {
        URL url = new URL("http://localhost:" + this.port + "/default");
        HttpURLConnection get = (HttpURLConnection)url.openConnection();
        get.setRequestProperty("Accept-Encoding", "gzip");
        Assert.assertEquals((Object)"gzip", (Object)get.getContentEncoding());
        HttpURLConnection post = (HttpURLConnection)url.openConnection();
        post.setRequestProperty("Accept-Encoding", "gzip");
        post.setRequestMethod("POST");
        Assert.assertEquals((Object)"gzip", (Object)post.getContentEncoding());
        HttpURLConnection getNoGzip = (HttpURLConnection)url.openConnection();
        Assert.assertNotEquals((Object)"gzip", (Object)getNoGzip.getContentEncoding());
        HttpURLConnection postNoGzip = (HttpURLConnection)url.openConnection();
        postNoGzip.setRequestMethod("POST");
        Assert.assertNotEquals((Object)"gzip", (Object)postNoGzip.getContentEncoding());
    }

    @Test
    @Ignore
    public void testChunkNotFinalized() throws Exception {
        ListenableFuture go = this.client.go(new Request(HttpMethod.GET, new URL("http://localhost:" + this.port + "/exception/exception")), (HttpResponseHandler)new InputStreamResponseHandler());
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)((InputStream)go.get()), (Writer)writer, (String)"utf-8");
            Assert.fail((String)"Should have thrown Exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testThreadNotStuckOnException() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ListenableFuture go = JettyTest.this.client.go(new Request(HttpMethod.GET, new URL("http://localhost:" + JettyTest.this.port + "/exception/exception")), (HttpResponseHandler)new InputStreamResponseHandler());
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)((InputStream)go.get()), (Writer)writer, (String)"utf-8");
                }
                catch (IOException go) {
                }
                catch (Throwable t) {
                    Throwables.propagate((Throwable)t);
                }
                latch.countDown();
            }
        });
        latch.await(5L, TimeUnit.SECONDS);
    }

    @Test
    public void testExtensionAuthFilter() throws Exception {
        URL url = new URL("http://localhost:" + this.port + "/default");
        HttpURLConnection get = (HttpURLConnection)url.openConnection();
        get.setRequestProperty("secretUser", "bob");
        Assert.assertEquals((long)200L, (long)get.getResponseCode());
        get = (HttpURLConnection)url.openConnection();
        get.setRequestProperty("secretUser", "hacker");
        Assert.assertEquals((long)401L, (long)get.getResponseCode());
    }
}

