/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.Properties;
import org.apache.hive.druid.io.druid.java.util.common.config.Config;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorConfig;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.skife.config.ConfigurationObjectFactory;

public class DruidCoordinatorConfigTest {
    @Test
    public void testDeserialization() throws Exception {
        ConfigurationObjectFactory factory = Config.createFactory((Properties)new Properties());
        DruidCoordinatorConfig config = (DruidCoordinatorConfig)factory.build(DruidCoordinatorConfig.class);
        Assert.assertEquals((Object)new Duration((Object)"PT300s"), (Object)config.getCoordinatorStartDelay());
        Assert.assertEquals((Object)new Duration((Object)"PT60s"), (Object)config.getCoordinatorPeriod());
        Assert.assertEquals((Object)new Duration((Object)"PT1800s"), (Object)config.getCoordinatorIndexingPeriod());
        Assert.assertFalse((boolean)config.isMergeSegments());
        Assert.assertFalse((boolean)config.isConvertSegments());
        Assert.assertFalse((boolean)config.isKillSegments());
        Assert.assertFalse((boolean)config.isKillPendingSegments());
        Assert.assertEquals((long)86400000L, (long)config.getCoordinatorKillPeriod().getMillis());
        Assert.assertEquals((long)-1000L, (long)config.getCoordinatorKillDurationToRetain().getMillis());
        Assert.assertEquals((long)0L, (long)config.getCoordinatorKillMaxSegments());
        Assert.assertEquals((Object)new Duration(900000L), (Object)config.getLoadTimeoutDelay());
        Assert.assertNull((Object)config.getConsoleStatic());
        Assert.assertEquals((Object)Duration.millis((long)50L), (Object)config.getLoadQueuePeonRepeatDelay());
        Properties props = new Properties();
        props.setProperty("druid.coordinator.startDelay", "PT1s");
        props.setProperty("druid.coordinator.period", "PT1s");
        props.setProperty("druid.coordinator.period.indexingPeriod", "PT1s");
        props.setProperty("druid.coordinator.merge.on", "true");
        props.setProperty("druid.coordinator.conversion.on", "true");
        props.setProperty("druid.coordinator.kill.on", "true");
        props.setProperty("druid.coordinator.kill.period", "PT1s");
        props.setProperty("druid.coordinator.kill.durationToRetain", "PT1s");
        props.setProperty("druid.coordinator.kill.maxSegments", "10000");
        props.setProperty("druid.coordinator.kill.pendingSegments.on", "true");
        props.setProperty("druid.coordinator.load.timeout", "PT1s");
        props.setProperty("druid.coordinator.console.static", "test");
        props.setProperty("druid.coordinator.loadqueuepeon.repeatDelay", "PT0.100s");
        factory = Config.createFactory((Properties)props);
        config = (DruidCoordinatorConfig)factory.build(DruidCoordinatorConfig.class);
        Assert.assertEquals((Object)new Duration((Object)"PT1s"), (Object)config.getCoordinatorStartDelay());
        Assert.assertEquals((Object)new Duration((Object)"PT1s"), (Object)config.getCoordinatorPeriod());
        Assert.assertEquals((Object)new Duration((Object)"PT1s"), (Object)config.getCoordinatorIndexingPeriod());
        Assert.assertTrue((boolean)config.isMergeSegments());
        Assert.assertTrue((boolean)config.isConvertSegments());
        Assert.assertTrue((boolean)config.isKillSegments());
        Assert.assertTrue((boolean)config.isKillPendingSegments());
        Assert.assertEquals((Object)new Duration((Object)"PT1s"), (Object)config.getCoordinatorKillPeriod());
        Assert.assertEquals((Object)new Duration((Object)"PT1s"), (Object)config.getCoordinatorKillDurationToRetain());
        Assert.assertEquals((long)10000L, (long)config.getCoordinatorKillMaxSegments());
        Assert.assertEquals((Object)new Duration((Object)"PT1s"), (Object)config.getLoadTimeoutDelay());
        Assert.assertEquals((Object)"test", (Object)config.getConsoleStatic());
        Assert.assertEquals((Object)Duration.millis((long)100L), (Object)config.getLoadQueuePeonRepeatDelay());
    }
}

