/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.net.HostAndPort;
import org.apache.hive.druid.io.druid.client.selector.Server;
import org.apache.hive.druid.io.druid.common.utils.SocketUtil;
import org.apache.hive.druid.io.druid.guice.GuiceInjectors;
import org.apache.hive.druid.io.druid.guice.Jerseys;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.LifecycleModule;
import org.apache.hive.druid.io.druid.guice.annotations.Self;
import org.apache.hive.druid.io.druid.guice.annotations.Smile;
import org.apache.hive.druid.io.druid.guice.http.DruidHttpClientConfig;
import org.apache.hive.druid.io.druid.initialization.Initialization;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.io.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.GenericQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.MapQueryToolChestWarehouse;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryToolChestWarehouse;
import org.apache.hive.druid.io.druid.server.AsyncQueryForwardingServlet;
import org.apache.hive.druid.io.druid.server.DruidNode;
import org.apache.hive.druid.io.druid.server.RequestLogLine;
import org.apache.hive.druid.io.druid.server.initialization.BaseJettyTest;
import org.apache.hive.druid.io.druid.server.initialization.jetty.JettyServerInitUtils;
import org.apache.hive.druid.io.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.hive.druid.io.druid.server.log.RequestLogger;
import org.apache.hive.druid.io.druid.server.metrics.NoopServiceEmitter;
import org.apache.hive.druid.io.druid.server.router.AvaticaConnectionBalancer;
import org.apache.hive.druid.io.druid.server.router.QueryHostFinder;
import org.apache.hive.druid.io.druid.server.router.RendezvousHashAvaticaConnectionBalancer;
import org.apache.hive.druid.io.druid.server.security.AllowAllAuthorizer;
import org.apache.hive.druid.io.druid.server.security.Authorizer;
import org.apache.hive.druid.io.druid.server.security.AuthorizerMapper;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AsyncQueryForwardingServletTest
extends BaseJettyTest {
    private static int port1;
    private static int port2;

    @Override
    @Before
    public void setup() throws Exception {
        AsyncQueryForwardingServletTest.setProperties();
        Injector injector = this.setupInjector();
        DruidNode node = (DruidNode)injector.getInstance(Key.get(DruidNode.class, Self.class));
        this.port = node.getPlaintextPort();
        port1 = SocketUtil.findOpenPortFrom((int)(this.port + 1));
        port2 = SocketUtil.findOpenPortFrom((int)(port1 + 1));
        this.lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
        this.lifecycle.start();
        BaseJettyTest.ClientHolder holder = (BaseJettyTest.ClientHolder)injector.getInstance(BaseJettyTest.ClientHolder.class);
        this.client = holder.getClient();
    }

    @Override
    protected Injector setupInjector() {
        return Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("test", "localhost", null, null, true, false));
                binder.bind(JettyServerInitializer.class).to(ProxyJettyServerInit.class).in(LazySingleton.class);
                binder.bind(AuthorizerMapper.class).toInstance((Object)new AuthorizerMapper(null){

                    public Authorizer getAuthorizer(String name) {
                        return new AllowAllAuthorizer();
                    }
                });
                Jerseys.addResource((Binder)binder, BaseJettyTest.SlowResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.ExceptionResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.DefaultResource.class);
                LifecycleModule.register((Binder)binder, org.eclipse.jetty.server.Server.class);
            }
        }));
    }

    @Test
    public void testProxyGzipCompression() throws Exception {
        URL url = new URL("http://localhost:" + this.port + "/proxy/default");
        HttpURLConnection get = (HttpURLConnection)url.openConnection();
        get.setRequestProperty("Accept-Encoding", "gzip");
        Assert.assertEquals((Object)"gzip", (Object)get.getContentEncoding());
        HttpURLConnection post = (HttpURLConnection)url.openConnection();
        post.setRequestProperty("Accept-Encoding", "gzip");
        post.setRequestMethod("POST");
        Assert.assertEquals((Object)"gzip", (Object)post.getContentEncoding());
        HttpURLConnection getNoGzip = (HttpURLConnection)url.openConnection();
        Assert.assertNotEquals((Object)"gzip", (Object)getNoGzip.getContentEncoding());
        HttpURLConnection postNoGzip = (HttpURLConnection)url.openConnection();
        postNoGzip.setRequestMethod("POST");
        Assert.assertNotEquals((Object)"gzip", (Object)postNoGzip.getContentEncoding());
    }

    @Test(timeout=60000L)
    public void testDeleteBroadcast() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        AsyncQueryForwardingServletTest.makeTestDeleteServer(port1, latch).start();
        AsyncQueryForwardingServletTest.makeTestDeleteServer(port2, latch).start();
        URL url = new URL("http://localhost:" + this.port + "/druid/v2/abc123");
        HttpURLConnection post = (HttpURLConnection)url.openConnection();
        post.setRequestMethod("DELETE");
        int code = post.getResponseCode();
        Assert.assertEquals((long)200L, (long)code);
        latch.await();
    }

    private static org.eclipse.jetty.server.Server makeTestDeleteServer(int port, final CountDownLatch latch) {
        org.eclipse.jetty.server.Server server = new org.eclipse.jetty.server.Server(port);
        ServletHandler handler = new ServletHandler();
        handler.addServletWithMapping(new ServletHolder((Servlet)new HttpServlet(){

            protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                latch.countDown();
                resp.setStatus(200);
            }
        }), "/default/*");
        server.setHandler((Handler)handler);
        return server;
    }

    @Test
    public void testRewriteURI() throws Exception {
        Assert.assertEquals((Object)new URI("http://localhost:1234/some/path?param=1"), (Object)AsyncQueryForwardingServlet.makeURI((String)"http", (String)"localhost:1234", (String)"/some/path", (String)"param=1"));
        Assert.assertEquals((Object)"http://[2a00:1450:4007:805::1007]:1234/some/path?param=1&param2=%E2%82%AC", (Object)AsyncQueryForwardingServlet.makeURI((String)"http", (String)HostAndPort.fromParts((String)"2a00:1450:4007:805::1007", (int)1234).toString(), (String)"/some/path", (String)"param=1&param2=%E2%82%AC").toASCIIString());
        Assert.assertEquals((Object)new URI("http://localhost/"), (Object)AsyncQueryForwardingServlet.makeURI((String)"http", (String)"localhost", (String)"/", null));
        Assert.assertEquals((Object)new URI("http://localhost:1234/some/path?intervals=1900-01-01T00%3A00%3A00.000%2B01%3A00%2F3000-01-01T00%3A00%3A00.000%2B01%3A00"), (Object)AsyncQueryForwardingServlet.makeURI((String)"http", (String)"localhost:1234", (String)"/some/path", (String)"intervals=1900-01-01T00%3A00%3A00.000%2B01%3A00%2F3000-01-01T00%3A00%3A00.000%2B01%3A00"));
    }

    private static class TestServer
    implements Server {
        private final String scheme;
        private final String address;
        private final int port;

        public TestServer(String scheme, String address, int port) {
            this.scheme = scheme;
            this.address = address;
            this.port = port;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getHost() {
            return this.address + ":" + this.port;
        }

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }
    }

    public static class ProxyJettyServerInit
    implements JettyServerInitializer {
        private final DruidNode node;

        @Inject
        public ProxyJettyServerInit(@Self DruidNode node) {
            this.node = node;
        }

        public void initialize(org.eclipse.jetty.server.Server server, Injector injector) {
            ServletContextHandler root = new ServletContextHandler(1);
            root.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
            QueryHostFinder hostFinder = new QueryHostFinder(null, (AvaticaConnectionBalancer)new RendezvousHashAvaticaConnectionBalancer()){

                public Server getServer(Query query) {
                    return new TestServer("http", "localhost", node.getPlaintextPort());
                }

                public Server getDefaultServer() {
                    return new TestServer("http", "localhost", node.getPlaintextPort());
                }

                public Collection<Server> getAllServers() {
                    return ImmutableList.of((Object)new TestServer("http", "localhost", node.getPlaintextPort()), (Object)new TestServer("http", "localhost", port1), (Object)new TestServer("http", "localhost", port2));
                }
            };
            ObjectMapper jsonMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
            ServletHolder holder = new ServletHolder((Servlet)new AsyncQueryForwardingServlet((QueryToolChestWarehouse)new MapQueryToolChestWarehouse((Map)ImmutableMap.of()), jsonMapper, (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Smile.class)), hostFinder, injector.getProvider(HttpClient.class), (DruidHttpClientConfig)injector.getInstance(DruidHttpClientConfig.class), new NoopServiceEmitter(), new RequestLogger(){

                public void log(RequestLogLine requestLogLine) throws IOException {
                }
            }, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(jsonMapper)){

                protected URI rewriteURI(HttpServletRequest request, String scheme, String host) {
                    String uri = super.rewriteURI(request, scheme, host).toString();
                    if (uri.contains("/druid/v2")) {
                        return URI.create(uri.replace("/druid/v2", "/default"));
                    }
                    return URI.create(uri.replace("/proxy", ""));
                }
            });
            holder.setInitParameter("maxThreads", "256");
            root.addServlet(holder, "/proxy/*");
            root.addServlet(holder, "/druid/v2/*");
            JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
            root.addFilter(GuiceFilter.class, "/slow/*", null);
            root.addFilter(GuiceFilter.class, "/default/*", null);
            root.addFilter(GuiceFilter.class, "/exception/*", null);
            HandlerList handlerList = new HandlerList();
            handlerList.setHandlers(new Handler[]{JettyServerInitUtils.wrapWithDefaultGzipHandler((Handler)root)});
            server.setHandler((Handler)handlerList);
        }
    }
}

