/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.plumber;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Assert;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.client.ImmutableSegmentLoadInfo;
import org.apache.hive.druid.io.druid.client.coordinator.CoordinatorClient;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.CoordinatorBasedSegmentHandoffNotifier;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.CoordinatorBasedSegmentHandoffNotifierConfig;
import org.apache.hive.druid.io.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.junit.Test;

public class CoordinatorBasedSegmentHandoffNotifierTest {
    private final CoordinatorBasedSegmentHandoffNotifierConfig notifierConfig = new CoordinatorBasedSegmentHandoffNotifierConfig(){

        public Duration getPollDuration() {
            return Duration.millis((long)10L);
        }
    };

    @Test
    public void testHandoffCallbackNotCalled() throws IOException, InterruptedException {
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        SegmentDescriptor descriptor = new SegmentDescriptor(interval, "v1", 2);
        DataSegment segment = new DataSegment("test_ds", interval, "v1", null, null, null, (ShardSpec)new NumberedShardSpec(2, 3), Integer.valueOf(0), 0L);
        CoordinatorClient coordinatorClient = (CoordinatorClient)EasyMock.createMock(CoordinatorClient.class);
        EasyMock.expect((Object)coordinatorClient.fetchServerView("test_ds", interval, true)).andReturn((Object)Lists.newArrayList((Object[])new ImmutableSegmentLoadInfo[]{new ImmutableSegmentLoadInfo(segment, (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createRealtimeServerMetadata("a1")}))})).anyTimes();
        EasyMock.replay((Object[])new Object[]{coordinatorClient});
        CoordinatorBasedSegmentHandoffNotifier notifier = new CoordinatorBasedSegmentHandoffNotifier("test_ds", coordinatorClient, this.notifierConfig);
        final AtomicBoolean callbackCalled = new AtomicBoolean(false);
        notifier.registerSegmentHandoffCallback(descriptor, (Executor)MoreExecutors.sameThreadExecutor(), new Runnable(){

            @Override
            public void run() {
                callbackCalled.set(true);
            }
        });
        notifier.checkForSegmentHandoffs();
        Assert.assertEquals((int)1, (int)notifier.getHandOffCallbacks().size());
        Assert.assertTrue((boolean)notifier.getHandOffCallbacks().containsKey(descriptor));
        Assert.assertFalse((boolean)callbackCalled.get());
        EasyMock.verify((Object[])new Object[]{coordinatorClient});
    }

    @Test
    public void testHandoffCallbackCalled() throws IOException, InterruptedException {
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        SegmentDescriptor descriptor = new SegmentDescriptor(interval, "v1", 2);
        DataSegment segment = new DataSegment("test_ds", interval, "v1", null, null, null, (ShardSpec)new NumberedShardSpec(2, 3), Integer.valueOf(0), 0L);
        final AtomicBoolean callbackCalled = new AtomicBoolean(false);
        CoordinatorClient coordinatorClient = (CoordinatorClient)EasyMock.createMock(CoordinatorClient.class);
        EasyMock.expect((Object)coordinatorClient.fetchServerView("test_ds", interval, true)).andReturn((Object)Lists.newArrayList((Object[])new ImmutableSegmentLoadInfo[]{new ImmutableSegmentLoadInfo(segment, (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a1")}))})).anyTimes();
        EasyMock.replay((Object[])new Object[]{coordinatorClient});
        CoordinatorBasedSegmentHandoffNotifier notifier = new CoordinatorBasedSegmentHandoffNotifier("test_ds", coordinatorClient, this.notifierConfig);
        notifier.registerSegmentHandoffCallback(descriptor, (Executor)MoreExecutors.sameThreadExecutor(), new Runnable(){

            @Override
            public void run() {
                callbackCalled.set(true);
            }
        });
        Assert.assertEquals((int)1, (int)notifier.getHandOffCallbacks().size());
        Assert.assertTrue((boolean)notifier.getHandOffCallbacks().containsKey(descriptor));
        notifier.checkForSegmentHandoffs();
        Assert.assertTrue((boolean)notifier.getHandOffCallbacks().isEmpty());
        Assert.assertTrue((boolean)callbackCalled.get());
        EasyMock.verify((Object[])new Object[]{coordinatorClient});
    }

    @Test
    public void testHandoffChecksForVersion() {
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        Assert.assertFalse((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete((List)Lists.newArrayList((Object[])new ImmutableSegmentLoadInfo[]{new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 2), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))}), (SegmentDescriptor)new SegmentDescriptor(interval, "v2", 2)));
        Assert.assertTrue((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete((List)Lists.newArrayList((Object[])new ImmutableSegmentLoadInfo[]{new ImmutableSegmentLoadInfo(this.createSegment(interval, "v2", 2), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))}), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 2)));
        Assert.assertTrue((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete((List)Lists.newArrayList((Object[])new ImmutableSegmentLoadInfo[]{new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 2), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))}), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 2)));
    }

    @Test
    public void testHandoffChecksForAssignableServer() {
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        Assert.assertTrue((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete((List)Lists.newArrayList((Object[])new ImmutableSegmentLoadInfo[]{new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 2), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))}), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 2)));
        Assert.assertFalse((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete((List)Lists.newArrayList((Object[])new ImmutableSegmentLoadInfo[]{new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 2), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createRealtimeServerMetadata("a")}))}), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 2)));
    }

    @Test
    public void testHandoffChecksForPartitionNumber() {
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        Assert.assertTrue((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete((List)Lists.newArrayList((Object[])new ImmutableSegmentLoadInfo[]{new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 1), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))}), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 1)));
        Assert.assertFalse((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete((List)Lists.newArrayList((Object[])new ImmutableSegmentLoadInfo[]{new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 1), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))}), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 2)));
    }

    @Test
    public void testHandoffChecksForInterval() {
        Assert.assertFalse((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete((List)Lists.newArrayList((Object[])new ImmutableSegmentLoadInfo[]{new ImmutableSegmentLoadInfo(this.createSegment(Intervals.of((String)"2011-04-01/2011-04-02"), "v1", 1), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))}), (SegmentDescriptor)new SegmentDescriptor(Intervals.of((String)"2011-04-01/2011-04-03"), "v1", 1)));
        Assert.assertTrue((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete((List)Lists.newArrayList((Object[])new ImmutableSegmentLoadInfo[]{new ImmutableSegmentLoadInfo(this.createSegment(Intervals.of((String)"2011-04-01/2011-04-04"), "v1", 1), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))}), (SegmentDescriptor)new SegmentDescriptor(Intervals.of((String)"2011-04-02/2011-04-03"), "v1", 1)));
    }

    private DruidServerMetadata createRealtimeServerMetadata(String name) {
        return this.createServerMetadata(name, ServerType.REALTIME);
    }

    private DruidServerMetadata createHistoricalServerMetadata(String name) {
        return this.createServerMetadata(name, ServerType.HISTORICAL);
    }

    private DruidServerMetadata createServerMetadata(String name, ServerType type) {
        return new DruidServerMetadata(name, name, null, 10000L, type, "tier", 1);
    }

    private DataSegment createSegment(Interval interval, String version, int partitionNumber) {
        return new DataSegment("test_ds", interval, version, null, null, null, (ShardSpec)new NumberedShardSpec(partitionNumber, 100), Integer.valueOf(0), 0L);
    }
}

