/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.indexing.granularity;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.hive.druid.io.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.hive.druid.io.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.chrono.ISOChronology;
import org.junit.Assert;
import org.junit.Test;

public class UniformGranularityTest {
    private static final ObjectMapper jsonMapper = new DefaultObjectMapper();

    @Test
    public void testSimple() {
        UniformGranularitySpec spec = new UniformGranularitySpec(Granularities.DAY, null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")}));
        Assert.assertTrue((boolean)spec.isRollup());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-01T00Z/P1D"), Intervals.of((String)"2012-01-02T00Z/P1D"), Intervals.of((String)"2012-01-03T00Z/P1D"), Intervals.of((String)"2012-01-07T00Z/P1D"), Intervals.of((String)"2012-01-08T00Z/P1D"), Intervals.of((String)"2012-01-09T00Z/P1D"), Intervals.of((String)"2012-01-10T00Z/P1D")}), (Object)Lists.newArrayList((Iterable)((Iterable)spec.bucketIntervals().get())));
        Assert.assertEquals((String)"2012-01-03T00Z", (Object)Optional.of((Object)Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-03T00Z")));
        Assert.assertEquals((String)"2012-01-03T01Z", (Object)Optional.of((Object)Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-03T01Z")));
        Assert.assertEquals((String)"2012-01-04T01Z", (Object)Optional.absent(), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-04T01Z")));
        Assert.assertEquals((String)"2012-01-07T23:59:59.999Z", (Object)Optional.of((Object)Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-07T23:59:59.999Z")));
        Assert.assertEquals((String)"2012-01-08T01Z", (Object)Optional.of((Object)Intervals.of((String)"2012-01-08T00Z/2012-01-09T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-08T01Z")));
    }

    @Test
    public void testRollupSetting() {
        ArrayList intervals = Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")});
        UniformGranularitySpec spec = new UniformGranularitySpec(Granularities.DAY, Granularities.NONE, Boolean.valueOf(false), (List)intervals);
        Assert.assertFalse((boolean)spec.isRollup());
    }

    @Test
    public void testJson() {
        UniformGranularitySpec spec = new UniformGranularitySpec(Granularities.DAY, null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")}));
        try {
            GranularitySpec rtSpec = (GranularitySpec)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)spec), GranularitySpec.class);
            Assert.assertEquals((String)"Round-trip bucketIntervals", (Object)spec.bucketIntervals(), (Object)rtSpec.bucketIntervals());
            Assert.assertEquals((String)"Round-trip granularity", (Object)spec.getSegmentGranularity(), (Object)rtSpec.getSegmentGranularity());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Test
    public void testEquals() {
        UniformGranularitySpec spec = new UniformGranularitySpec(Granularities.DAY, null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")}));
        this.equalsCheck((GranularitySpec)spec, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")})));
    }

    public void equalsCheck(GranularitySpec spec1, GranularitySpec spec2) {
        Assert.assertEquals((Object)spec1, (Object)spec2);
        Assert.assertEquals((long)spec1.hashCode(), (long)spec2.hashCode());
    }

    @Test
    public void testNotEquals() {
        UniformGranularitySpec spec = new UniformGranularitySpec(Granularities.DAY, null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")}));
        this.notEqualsCheck((GranularitySpec)spec, (GranularitySpec)new UniformGranularitySpec(Granularities.YEAR, null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")})));
        this.notEqualsCheck((GranularitySpec)spec, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-12T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")})));
        this.notEqualsCheck((GranularitySpec)spec, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.ALL, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")})));
    }

    @Test
    public void testPeriodSegmentGranularity() {
        UniformGranularitySpec spec = new UniformGranularitySpec((Granularity)new PeriodGranularity(new Period((Object)"P1D"), null, DateTimeZone.forID((String)"America/Los_Angeles")), null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00-08:00/2012-01-11T00-08:00"), Intervals.of((String)"2012-01-07T00-08:00/2012-01-08T00-08:00"), Intervals.of((String)"2012-01-03T00-08:00/2012-01-04T00-08:00"), Intervals.of((String)"2012-01-01T00-08:00/2012-01-03T00-08:00"), Intervals.of((String)"2012-09-01T00-07:00/2012-09-03T00-07:00")}));
        Assert.assertTrue((boolean)spec.bucketIntervals().isPresent());
        Optional sortedSetOptional = spec.bucketIntervals();
        SortedSet intervals = (SortedSet)sortedSetOptional.get();
        ArrayList<Long> actualIntervals = new ArrayList<Long>();
        for (Interval interval : intervals) {
            actualIntervals.add(interval.toDurationMillis());
        }
        ISOChronology chrono = ISOChronology.getInstance((DateTimeZone)DateTimeZone.forID((String)"America/Los_Angeles"));
        ArrayList expectedIntervals = Lists.newArrayList((Object[])new Long[]{new Interval((Object)"2012-01-01/2012-01-02", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-01-02/2012-01-03", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-01-03/2012-01-04", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-01-07/2012-01-08", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-01-08/2012-01-09", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-01-09/2012-01-10", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-01-10/2012-01-11", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-09-01/2012-09-02", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-09-02/2012-09-03", (Chronology)chrono).toDurationMillis()});
        Assert.assertEquals((Object)expectedIntervals, actualIntervals);
    }

    private void notEqualsCheck(GranularitySpec spec1, GranularitySpec spec2) {
        Assert.assertNotEquals((Object)spec1, (Object)spec2);
        Assert.assertNotEquals((long)spec1.hashCode(), (long)spec2.hashCode());
    }
}

