/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.incremental;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.collections.StupidPool;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.FloatDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.LongDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.StringDimensionSchema;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ParseException;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.io.druid.segment.CloserRule;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.segment.incremental.IndexSizeExceededException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IncrementalIndexTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public final CloserRule closer = new CloserRule(false);
    private final IndexCreator indexCreator;

    public IncrementalIndexTest(IndexCreator IndexCreator2) {
        this.indexCreator = IndexCreator2;
    }

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        DimensionsSpec dimensions = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("string"), new FloatDimensionSchema("float"), new LongDimensionSchema("long"), new DoubleDimensionSchema("double")), null, null);
        AggregatorFactory[] metrics = new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("cnt"), (DimFilter)new SelectorDimFilter("billy", "A", null))};
        final IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withQueryGranularity(Granularities.MINUTE).withDimensionsSpec(dimensions).withMetrics(metrics).build();
        ArrayList constructors = Lists.newArrayList();
        for (final Boolean sortFacts : ImmutableList.of((Object)false, (Object)true)) {
            constructors.add(new Object[]{new IndexCreator(){

                @Override
                public IncrementalIndex createIndex() {
                    return new IncrementalIndex.Builder().setIndexSchema(schema).setDeserializeComplexMetrics(false).setSortFacts(sortFacts.booleanValue()).setMaxRowCount(1000).buildOnheap();
                }
            }});
            constructors.add(new Object[]{new IndexCreator(){

                @Override
                public IncrementalIndex createIndex() {
                    return new IncrementalIndex.Builder().setIndexSchema(schema).setSortFacts(sortFacts.booleanValue()).setMaxRowCount(1000000).buildOffheap((NonBlockingPool)new StupidPool("OffheapIncrementalIndex-bufferPool", (Supplier)new Supplier<ByteBuffer>(){

                        public ByteBuffer get() {
                            return ByteBuffer.allocate(262144);
                        }
                    }));
                }
            }});
        }
        return constructors;
    }

    @Test(expected=ISE.class)
    public void testDuplicateDimensions() throws IndexSizeExceededException {
        IncrementalIndex index = this.closer.closeLater(this.indexCreator.createIndex());
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
    }

    @Test(expected=ISE.class)
    public void testDuplicateDimensionsFirstOccurrence() throws IndexSizeExceededException {
        IncrementalIndex index = this.closer.closeLater(this.indexCreator.createIndex());
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
    }

    @Test
    public void controlTest() throws IndexSizeExceededException {
        IncrementalIndex index = this.closer.closeLater(this.indexCreator.createIndex());
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"C", (Object)"joe", (Object)"B")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
    }

    @Test
    public void testUnparseableNumerics() throws IndexSizeExceededException {
        IncrementalIndex index = this.closer.closeLater(this.indexCreator.createIndex());
        this.expectedException.expect(ParseException.class);
        this.expectedException.expectMessage("could not convert value [asdj] to long");
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"string", "float", "long", "double"}), (Map)ImmutableMap.of((Object)"string", (Object)"A", (Object)"float", (Object)"19.0", (Object)"long", (Object)"asdj", (Object)"double", (Object)21.0)));
        this.expectedException.expect(ParseException.class);
        this.expectedException.expectMessage("could not convert value [aaa] to float");
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"string", "float", "long", "double"}), (Map)ImmutableMap.of((Object)"string", (Object)"A", (Object)"float", (Object)"aaa", (Object)"long", (Object)20, (Object)"double", (Object)21.0)));
        this.expectedException.expect(ParseException.class);
        this.expectedException.expectMessage("could not convert value [] to double");
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"string", "float", "long", "double"}), (Map)ImmutableMap.of((Object)"string", (Object)"A", (Object)"float", (Object)19.0, (Object)"long", (Object)20, (Object)"double", (Object)"")));
    }

    @Test
    public void sameRow() throws IndexSizeExceededException {
        MapBasedInputRow row = new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B"));
        IncrementalIndex index = this.closer.closeLater(this.indexCreator.createIndex());
        index.add((InputRow)row);
        index.add((InputRow)row);
        index.add((InputRow)row);
        Assert.assertEquals((long)1L, (long)index.size());
    }

    static interface IndexCreator {
        public IncrementalIndex createIndex();
    }
}

