/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.js.JavaScriptConfig;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.InDimFilter;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.segment.IndexBuilder;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.filter.BaseFilterTest;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InFilterTest
extends BaseFilterTest {
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "iso", DateTimes.of((String)"2000")), new DimensionsSpec(null, null, null)));
    private static final List<InputRow> ROWS = ImmutableList.of(PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"a", (Object)"dim1", (Object)"", (Object)"dim2", (Object)ImmutableList.of((Object)"a", (Object)"b"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"b", (Object)"dim1", (Object)"10", (Object)"dim2", (Object)ImmutableList.of())).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"c", (Object)"dim1", (Object)"2", (Object)"dim2", (Object)ImmutableList.of((Object)""))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"d", (Object)"dim1", (Object)"1", (Object)"dim2", (Object)ImmutableList.of((Object)"a"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"e", (Object)"dim1", (Object)"def", (Object)"dim2", (Object)ImmutableList.of((Object)"c"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"f", (Object)"dim1", (Object)"abc")).get(0));

    public InFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(InFilterTest.class.getName());
    }

    @Test
    public void testSingleValueStringColumnWithoutNulls() {
        this.assertFilterMatches(this.toInFilter("dim0", null, new String[0]), (List<String>)ImmutableList.of());
        this.assertFilterMatches(this.toInFilter("dim0", "", ""), (List<String>)ImmutableList.of());
        this.assertFilterMatches(this.toInFilter("dim0", "a", "c"), (List<String>)ImmutableList.of((Object)"a", (Object)"c"));
        this.assertFilterMatches(this.toInFilter("dim0", "e", "x"), (List<String>)ImmutableList.of((Object)"e"));
    }

    @Test
    public void testSingleValueStringColumnWithNulls() {
        this.assertFilterMatches(this.toInFilter("dim1", null, ""), (List<String>)ImmutableList.of((Object)"a"));
        this.assertFilterMatches(this.toInFilter("dim1", "", new String[0]), (List<String>)ImmutableList.of((Object)"a"));
        this.assertFilterMatches(this.toInFilter("dim1", null, "10", "abc"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"f"));
        this.assertFilterMatches(this.toInFilter("dim1", "-1", "ab", "de"), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMultiValueStringColumn() {
        this.assertFilterMatches(this.toInFilter("dim2", null, new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"f"));
        this.assertFilterMatches(this.toInFilter("dim2", "", new String[]{null}), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"f"));
        this.assertFilterMatches(this.toInFilter("dim2", null, "a"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"f"));
        this.assertFilterMatches(this.toInFilter("dim2", null, "b"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"f"));
        this.assertFilterMatches(this.toInFilter("dim2", "c", new String[0]), (List<String>)ImmutableList.of((Object)"e"));
        this.assertFilterMatches(this.toInFilter("dim2", "d", new String[0]), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumn() {
        this.assertFilterMatches(this.toInFilter("dim3", null, new String[]{null}), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
        this.assertFilterMatches(this.toInFilter("dim3", "", new String[0]), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
        this.assertFilterMatches(this.toInFilter("dim3", null, "a"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
        this.assertFilterMatches(this.toInFilter("dim3", "a", new String[0]), (List<String>)ImmutableList.of());
        this.assertFilterMatches(this.toInFilter("dim3", "b", new String[0]), (List<String>)ImmutableList.of());
        this.assertFilterMatches(this.toInFilter("dim3", "c", new String[0]), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMatchWithExtractionFn() {
        String extractionJsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn superFn = new JavaScriptExtractionFn(extractionJsFn, false, JavaScriptConfig.getEnabledInstance());
        String nullJsFn = "function(str) { if (str === null) { return 'YES'; } else { return 'NO';} }";
        JavaScriptExtractionFn yesNullFn = new JavaScriptExtractionFn(nullJsFn, false, JavaScriptConfig.getEnabledInstance());
        this.assertFilterMatches(this.toInFilterWithFn("dim2", (ExtractionFn)superFn, "super-null", "super-a", "super-b"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"f"));
        this.assertFilterMatches(this.toInFilterWithFn("dim2", (ExtractionFn)yesNullFn, "YES", new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"f"));
        this.assertFilterMatches(this.toInFilterWithFn("dim1", (ExtractionFn)superFn, "super-null", "super-10", "super-def"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"e"));
        this.assertFilterMatches(this.toInFilterWithFn("dim3", (ExtractionFn)yesNullFn, "NO", new String[0]), (List<String>)ImmutableList.of());
        this.assertFilterMatches(this.toInFilterWithFn("dim3", (ExtractionFn)yesNullFn, "YES", new String[0]), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
        this.assertFilterMatches(this.toInFilterWithFn("dim1", (ExtractionFn)yesNullFn, "NO", new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
    }

    @Test
    public void testMatchWithLookupExtractionFn() {
        ImmutableMap stringMap = ImmutableMap.of((Object)"a", (Object)"HELLO", (Object)"10", (Object)"HELLO", (Object)"def", (Object)"HELLO", (Object)"c", (Object)"BYE");
        MapLookupExtractor mapExtractor = new MapLookupExtractor((Map)stringMap, false);
        LookupExtractionFn lookupFn = new LookupExtractionFn((LookupExtractor)mapExtractor, false, "UNKNOWN", false, Boolean.valueOf(true));
        this.assertFilterMatches(this.toInFilterWithFn("dim0", (ExtractionFn)lookupFn, null, "HELLO"), (List<String>)ImmutableList.of((Object)"a"));
        this.assertFilterMatches(this.toInFilterWithFn("dim0", (ExtractionFn)lookupFn, "HELLO", "BYE"), (List<String>)ImmutableList.of((Object)"a", (Object)"c"));
        this.assertFilterMatches(this.toInFilterWithFn("dim0", (ExtractionFn)lookupFn, "UNKNOWN", new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"d", (Object)"e", (Object)"f"));
        this.assertFilterMatches(this.toInFilterWithFn("dim1", (ExtractionFn)lookupFn, "HELLO", new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"e"));
        this.assertFilterMatches(this.toInFilterWithFn("dim1", (ExtractionFn)lookupFn, "N/A", new String[0]), (List<String>)ImmutableList.of());
        this.assertFilterMatches(this.toInFilterWithFn("dim2", (ExtractionFn)lookupFn, "a", new String[0]), (List<String>)ImmutableList.of());
        this.assertFilterMatches(this.toInFilterWithFn("dim2", (ExtractionFn)lookupFn, "HELLO", new String[0]), (List<String>)ImmutableList.of((Object)"a", (Object)"d"));
        this.assertFilterMatches(this.toInFilterWithFn("dim2", (ExtractionFn)lookupFn, "HELLO", "BYE", "UNKNOWN"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
        ImmutableMap stringMap2 = ImmutableMap.of((Object)"a", (Object)"e");
        MapLookupExtractor mapExtractor2 = new MapLookupExtractor((Map)stringMap2, false);
        LookupExtractionFn lookupFn2 = new LookupExtractionFn((LookupExtractor)mapExtractor2, true, null, false, Boolean.valueOf(true));
        this.assertFilterMatches(this.toInFilterWithFn("dim0", (ExtractionFn)lookupFn2, null, "e"), (List<String>)ImmutableList.of((Object)"a", (Object)"e"));
        this.assertFilterMatches(this.toInFilterWithFn("dim0", (ExtractionFn)lookupFn2, "a", new String[0]), (List<String>)ImmutableList.of());
        ImmutableMap stringMap3 = ImmutableMap.of((Object)"c", (Object)"500", (Object)"100", (Object)"e");
        MapLookupExtractor mapExtractor3 = new MapLookupExtractor((Map)stringMap3, false);
        LookupExtractionFn lookupFn3 = new LookupExtractionFn((LookupExtractor)mapExtractor3, false, null, false, Boolean.valueOf(true));
        this.assertFilterMatches(this.toInFilterWithFn("dim0", (ExtractionFn)lookupFn3, null, "c"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"d", (Object)"e", (Object)"f"));
        this.assertFilterMatches(this.toInFilterWithFn("dim0", (ExtractionFn)lookupFn3, "e", new String[0]), (List<String>)ImmutableList.of());
    }

    private DimFilter toInFilter(String dim, String value, String ... values) {
        return new InDimFilter(dim, (Collection)Lists.asList((Object)value, (Object[])values), null);
    }

    private DimFilter toInFilterWithFn(String dim, ExtractionFn fn, String value, String ... values) {
        return new InDimFilter(dim, (Collection)Lists.asList((Object)value, (Object[])values), fn);
    }
}

