/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.java.util.common.io.Closer;
import org.apache.hive.druid.io.druid.segment.data.ColumnarInts;
import org.apache.hive.druid.io.druid.segment.data.CompressedColumnarIntsSupplier;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategyTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompressedColumnarIntsSupplierTest
extends CompressionStrategyTest {
    private Closer closer;
    private ColumnarInts columnarInts;
    private CompressedColumnarIntsSupplier supplier;
    private int[] vals;

    public CompressedColumnarIntsSupplierTest(CompressionStrategy compressionStrategy) {
        super(compressionStrategy);
    }

    @Before
    public void setUp() throws Exception {
        this.closer = Closer.create();
        CloseQuietly.close((Closeable)this.columnarInts);
        this.columnarInts = null;
        this.supplier = null;
        this.vals = null;
    }

    @After
    public void tearDown() throws Exception {
        this.closer.close();
        CloseQuietly.close((Closeable)this.columnarInts);
    }

    private void setupSimple(int chunkSize) {
        CloseQuietly.close((Closeable)this.columnarInts);
        this.vals = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16};
        this.supplier = CompressedColumnarIntsSupplier.fromIntBuffer((IntBuffer)IntBuffer.wrap(this.vals), (int)chunkSize, (ByteOrder)ByteOrder.nativeOrder(), (CompressionStrategy)this.compressionStrategy, (Closer)this.closer);
        this.columnarInts = this.supplier.get();
    }

    private void setupSimpleWithSerde(int chunkSize) throws IOException {
        this.vals = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16};
        this.makeWithSerde(chunkSize);
    }

    private void makeWithSerde(int chunkSize) throws IOException {
        CloseQuietly.close((Closeable)this.columnarInts);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompressedColumnarIntsSupplier theSupplier = CompressedColumnarIntsSupplier.fromIntBuffer((IntBuffer)IntBuffer.wrap(this.vals), (int)chunkSize, (ByteOrder)ByteOrder.nativeOrder(), (CompressionStrategy)this.compressionStrategy, (Closer)this.closer);
        theSupplier.writeTo(Channels.newChannel(baos), null);
        byte[] bytes = baos.toByteArray();
        Assert.assertEquals((long)theSupplier.getSerializedSize(), (long)bytes.length);
        this.supplier = CompressedColumnarIntsSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytes), (ByteOrder)ByteOrder.nativeOrder());
        this.columnarInts = this.supplier.get();
    }

    private void setupLargeChunks(int chunkSize, int totalSize) throws IOException {
        this.vals = new int[totalSize];
        Random rand = new Random(0L);
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = rand.nextInt();
        }
        this.makeWithSerde(chunkSize);
    }

    @Test
    public void testSanity() throws Exception {
        this.setupSimple(5);
        Assert.assertEquals((long)4L, (long)this.supplier.getBaseIntBuffers().size());
        this.assertIndexMatchesVals();
        this.setupSimple(4);
        Assert.assertEquals((long)4L, (long)this.supplier.getBaseIntBuffers().size());
        this.assertIndexMatchesVals();
        this.setupSimple(32);
        Assert.assertEquals((long)1L, (long)this.supplier.getBaseIntBuffers().size());
        this.assertIndexMatchesVals();
    }

    @Test
    public void testLargeChunks() throws Exception {
        int maxChunkSize = 8192;
        this.setupLargeChunks(8192, 81920);
        Assert.assertEquals((long)10L, (long)this.supplier.getBaseIntBuffers().size());
        this.assertIndexMatchesVals();
        this.setupLargeChunks(8192, 81921);
        Assert.assertEquals((long)11L, (long)this.supplier.getBaseIntBuffers().size());
        this.assertIndexMatchesVals();
        this.setupLargeChunks(8191, 81911);
        Assert.assertEquals((long)11L, (long)this.supplier.getBaseIntBuffers().size());
        this.assertIndexMatchesVals();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChunkTooBig() throws Exception {
        int maxChunkSize = 16384;
        this.setupLargeChunks(16385, 163850);
    }

    @Test
    public void testSanityWithSerde() throws Exception {
        this.setupSimpleWithSerde(5);
        Assert.assertEquals((long)4L, (long)this.supplier.getBaseIntBuffers().size());
        this.assertIndexMatchesVals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentThreadReads() throws Exception {
        this.setupSimple(5);
        final AtomicReference<String> reason = new AtomicReference<String>("none");
        int numRuns = 1000;
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch stopLatch = new CountDownLatch(2);
        final AtomicBoolean failureHappened = new AtomicBoolean(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    startLatch.await();
                }
                catch (InterruptedException e) {
                    failureHappened.set(true);
                    reason.set("interrupt.");
                    stopLatch.countDown();
                    return;
                }
                try {
                    for (int i = 0; i < 1000; ++i) {
                        for (int j = 0; j < CompressedColumnarIntsSupplierTest.this.columnarInts.size(); ++j) {
                            long indexedVal;
                            long val = CompressedColumnarIntsSupplierTest.this.vals[j];
                            if (Longs.compare((long)val, (long)(indexedVal = (long)CompressedColumnarIntsSupplierTest.this.columnarInts.get(j))) == 0) continue;
                            failureHappened.set(true);
                            reason.set(StringUtils.format((String)"Thread1[%d]: %d != %d", (Object[])new Object[]{j, val, indexedVal}));
                            stopLatch.countDown();
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    failureHappened.set(true);
                    reason.set(e.getMessage());
                }
                stopLatch.countDown();
            }
        }).start();
        final ColumnarInts columnarInts2 = this.supplier.get();
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        startLatch.await();
                    }
                    catch (InterruptedException e) {
                        stopLatch.countDown();
                        return;
                    }
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            for (int j = columnarInts2.size() - 1; j >= 0; --j) {
                                long indexedVal;
                                long val = CompressedColumnarIntsSupplierTest.this.vals[j];
                                if (Longs.compare((long)val, (long)(indexedVal = (long)columnarInts2.get(j))) == 0) continue;
                                failureHappened.set(true);
                                reason.set(StringUtils.format((String)"Thread2[%d]: %d != %d", (Object[])new Object[]{j, val, indexedVal}));
                                stopLatch.countDown();
                                return;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        reason.set(e.getMessage());
                        failureHappened.set(true);
                    }
                    stopLatch.countDown();
                }
            }).start();
            startLatch.countDown();
            stopLatch.await();
        }
        finally {
            CloseQuietly.close((Closeable)columnarInts2);
        }
        if (failureHappened.get()) {
            Assert.fail((String)("Failure happened.  Reason: " + reason.get()));
        }
    }

    private void assertIndexMatchesVals() {
        Assert.assertEquals((long)this.vals.length, (long)this.columnarInts.size());
        int[] indices = new int[this.vals.length];
        for (int i = 0; i < this.columnarInts.size(); ++i) {
            Assert.assertEquals((double)this.vals[i], (double)this.columnarInts.get(i), (double)0.0);
            indices[i] = i;
        }
        IntArrays.shuffle((int[])indices, (Random)ThreadLocalRandom.current());
        int limit = Math.min(this.columnarInts.size(), 1000);
        for (int i = 0; i < limit; ++i) {
            int k = indices[i];
            Assert.assertEquals((double)this.vals[k], (double)this.columnarInts.get(k), (double)0.0);
        }
    }
}

