/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.segment.Metadata;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class MetadataTest {
    @Test
    public void testSerde() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        Metadata metadata = new Metadata();
        metadata.put("k", (Object)"v");
        AggregatorFactory[] aggregators = new AggregatorFactory[]{new LongSumAggregatorFactory("out", "in")};
        metadata.setAggregators(aggregators);
        metadata.setQueryGranularity(Granularities.ALL);
        metadata.setRollup(Boolean.FALSE);
        Metadata other = (Metadata)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)metadata), Metadata.class);
        Assert.assertEquals((Object)metadata, (Object)other);
    }

    @Test
    public void testMerge() {
        Assert.assertNull((Object)Metadata.merge(null, null));
        Assert.assertNull((Object)Metadata.merge((List)ImmutableList.of(), null));
        ArrayList<Metadata> metadataToBeMerged = new ArrayList<Metadata>();
        metadataToBeMerged.add(null);
        Assert.assertNull((Object)Metadata.merge(metadataToBeMerged, null));
        AggregatorFactory[] aggs = new AggregatorFactory[]{new LongMaxAggregatorFactory("n", "f")};
        Metadata m1 = new Metadata();
        m1.put("k", (Object)"v");
        m1.setAggregators(aggs);
        m1.setTimestampSpec(new TimestampSpec("ds", "auto", null));
        m1.setQueryGranularity(Granularities.ALL);
        m1.setRollup(Boolean.FALSE);
        Metadata m2 = new Metadata();
        m2.put("k", (Object)"v");
        m2.setAggregators(aggs);
        m2.setTimestampSpec(new TimestampSpec("ds", "auto", null));
        m2.setQueryGranularity(Granularities.ALL);
        m2.setRollup(Boolean.FALSE);
        Metadata merged = new Metadata();
        merged.put("k", (Object)"v");
        merged.setAggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("n", "n")});
        merged.setTimestampSpec(new TimestampSpec("ds", "auto", null));
        merged.setRollup(Boolean.FALSE);
        merged.setQueryGranularity(Granularities.ALL);
        Assert.assertEquals((Object)merged, (Object)Metadata.merge((List)ImmutableList.of((Object)m1, (Object)m2), null));
        metadataToBeMerged.clear();
        metadataToBeMerged.add(m1);
        metadataToBeMerged.add(m2);
        metadataToBeMerged.add(null);
        merged.setAggregators(null);
        merged.setTimestampSpec(null);
        merged.setQueryGranularity(null);
        merged.setRollup(null);
        Assert.assertEquals((Object)merged, (Object)Metadata.merge(metadataToBeMerged, null));
        AggregatorFactory[] explicitAggs = new AggregatorFactory[]{new DoubleMaxAggregatorFactory("x", "y")};
        merged.setAggregators(explicitAggs);
        Assert.assertEquals((Object)merged, (Object)Metadata.merge(metadataToBeMerged, (AggregatorFactory[])explicitAggs));
        merged.setTimestampSpec(new TimestampSpec("ds", "auto", null));
        merged.setQueryGranularity(Granularities.ALL);
        m1.setRollup(Boolean.TRUE);
        Assert.assertEquals((Object)merged, (Object)Metadata.merge((List)ImmutableList.of((Object)m1, (Object)m2), (AggregatorFactory[])explicitAggs));
    }
}

