/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.segment.IntIteratorUtils;
import org.junit.Assert;
import org.junit.Test;

public class MergeIntIteratorTest {
    @Test(expected=NoSuchElementException.class)
    public void testNoIterators() {
        IntIterator it = IntIteratorUtils.mergeAscending(Collections.emptyList());
        MergeIntIteratorTest.assertEmpty(it);
    }

    @Test(expected=NoSuchElementException.class)
    public void testMergeEmptyIterators() {
        IntIterator it = IntIteratorUtils.mergeAscending(Arrays.asList(IntIterators.EMPTY_ITERATOR, IntIterators.EMPTY_ITERATOR));
        MergeIntIteratorTest.assertEmpty(it);
    }

    private static void assertEmpty(IntIterator it) {
        Assert.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assert.fail((String)"expected NoSuchElementException on it.next() after it.hasNext() = false");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        it.nextInt();
    }

    @Test
    public void testOverflow() {
        ArrayList lists = Lists.newArrayList((Object[])new IntList[]{IntLists.singleton((int)Integer.MIN_VALUE), IntLists.singleton((int)Integer.MIN_VALUE), IntLists.singleton((int)-1), IntLists.singleton((int)0), IntLists.singleton((int)Integer.MAX_VALUE)});
        for (int i = 0; i < lists.size() + 1; ++i) {
            MergeIntIteratorTest.assertAscending(IntIteratorUtils.mergeAscending(MergeIntIteratorTest.iteratorsFromLists(lists)));
            Collections.rotate(lists, 1);
        }
        Collections.shuffle(lists);
        MergeIntIteratorTest.assertAscending(IntIteratorUtils.mergeAscending(MergeIntIteratorTest.iteratorsFromLists(lists)));
    }

    private static List<IntIterator> iteratorsFromLists(List<IntList> lists) {
        ArrayList<IntIterator> r = new ArrayList<IntIterator>();
        for (IntList list : lists) {
            r.add((IntIterator)list.iterator());
        }
        return r;
    }

    @Test
    public void smokeTest() {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        for (int i = 0; i < 1000; ++i) {
            int j;
            int numIterators = r.nextInt(1, 11);
            ArrayList<IntList> lists = new ArrayList<IntList>(numIterators);
            for (j = 0; j < numIterators; ++j) {
                lists.add((IntList)new IntArrayList());
            }
            for (j = 0; j < 50; ++j) {
                ((IntList)lists.get(r.nextInt(numIterators))).add(j);
            }
            for (j = 0; j < lists.size() + 1; ++j) {
                MergeIntIteratorTest.assertAscending(IntIteratorUtils.mergeAscending(MergeIntIteratorTest.iteratorsFromLists(lists)));
                Collections.rotate(lists, 1);
            }
            for (j = 0; j < 10; ++j) {
                Collections.shuffle(lists);
                MergeIntIteratorTest.assertAscending(IntIteratorUtils.mergeAscending(MergeIntIteratorTest.iteratorsFromLists(lists)));
            }
        }
    }

    private static void assertAscending(IntIterator it) {
        if (!it.hasNext()) {
            return;
        }
        int prev = it.nextInt();
        while (it.hasNext()) {
            int current = it.nextInt();
            if (prev > current) {
                Assert.fail((String)("not ascending: " + prev + ", then " + current));
            }
            prev = current;
        }
    }
}

