/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.BySegmentResultValueClass;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.hive.druid.io.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ListColumnIncluderator;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.hive.druid.io.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.TestIndex;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.timeline.LogicalSegment;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SegmentMetadataQueryTest {
    private static final SegmentMetadataQueryRunnerFactory FACTORY = new SegmentMetadataQueryRunnerFactory(new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();
    private final QueryRunner runner1;
    private final QueryRunner runner2;
    private final boolean mmap1;
    private final boolean mmap2;
    private final boolean rollup1;
    private final boolean rollup2;
    private final boolean differentIds;
    private final SegmentMetadataQuery testQuery;
    private final SegmentAnalysis expectedSegmentAnalysis1;
    private final SegmentAnalysis expectedSegmentAnalysis2;

    public static QueryRunner makeMMappedQueryRunner(String segmentId, boolean rollup, QueryRunnerFactory factory) {
        QueryableIndex index = rollup ? TestIndex.getMMappedTestIndex() : TestIndex.getNoRollupMMappedTestIndex();
        return QueryRunnerTestHelper.makeQueryRunner(factory, segmentId, (Segment)new QueryableIndexSegment(segmentId, index), null);
    }

    public static QueryRunner makeIncrementalIndexQueryRunner(String segmentId, boolean rollup, QueryRunnerFactory factory) {
        IncrementalIndex index = rollup ? TestIndex.getIncrementalTestIndex() : TestIndex.getNoRollupIncrementalTestIndex();
        return QueryRunnerTestHelper.makeQueryRunner(factory, segmentId, (Segment)new IncrementalIndexSegment(index, segmentId), null);
    }

    @Parameterized.Parameters(name="mmap1 = {0}, mmap2 = {1}, rollup1 = {2}, rollup2 = {3}, differentIds = {4}")
    public static Collection<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{true, true, true, true, false}, (Object)new Object[]{true, false, true, false, false}, (Object)new Object[]{false, true, true, false, false}, (Object)new Object[]{false, false, false, false, false}, (Object)new Object[]{false, false, true, true, false}, (Object)new Object[]{false, false, false, true, true});
    }

    public SegmentMetadataQueryTest(boolean mmap1, boolean mmap2, boolean rollup1, boolean rollup2, boolean differentIds) {
        String id1 = differentIds ? "testSegment1" : "testSegment";
        String id2 = differentIds ? "testSegment2" : "testSegment";
        this.runner1 = mmap1 ? SegmentMetadataQueryTest.makeMMappedQueryRunner(id1, rollup1, (QueryRunnerFactory)FACTORY) : SegmentMetadataQueryTest.makeIncrementalIndexQueryRunner(id1, rollup1, (QueryRunnerFactory)FACTORY);
        this.runner2 = mmap2 ? SegmentMetadataQueryTest.makeMMappedQueryRunner(id2, rollup2, (QueryRunnerFactory)FACTORY) : SegmentMetadataQueryTest.makeIncrementalIndexQueryRunner(id2, rollup2, (QueryRunnerFactory)FACTORY);
        this.mmap1 = mmap1;
        this.mmap2 = mmap2;
        this.rollup1 = rollup1;
        this.rollup2 = rollup2;
        this.differentIds = differentIds;
        this.testQuery = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("__time", "index", "placement"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.CARDINALITY, SegmentMetadataQuery.AnalysisType.SIZE, SegmentMetadataQuery.AnalysisType.INTERVAL, SegmentMetadataQuery.AnalysisType.MINMAX}).merge(true).build();
        this.expectedSegmentAnalysis1 = new SegmentAnalysis(id1, (List)ImmutableList.of((Object)Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-04-15T00:00:00.001Z")), (Map)ImmutableMap.of((Object)"__time", (Object)new ColumnAnalysis(ValueType.LONG.toString(), false, 12090L, null, null, null, null), (Object)"placement", (Object)new ColumnAnalysis(ValueType.STRING.toString(), false, mmap1 ? 10881L : 10764L, Integer.valueOf(1), (Comparable)((Object)"preferred"), (Comparable)((Object)"preferred"), null), (Object)"index", (Object)new ColumnAnalysis(ValueType.DOUBLE.toString(), false, 9672L, null, null, null, null)), mmap1 ? 167493L : 168188L, 1209L, null, null, null, null);
        this.expectedSegmentAnalysis2 = new SegmentAnalysis(id2, (List)ImmutableList.of((Object)Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-04-15T00:00:00.001Z")), (Map)ImmutableMap.of((Object)"__time", (Object)new ColumnAnalysis(ValueType.LONG.toString(), false, 12090L, null, null, null, null), (Object)"placement", (Object)new ColumnAnalysis(ValueType.STRING.toString(), false, mmap2 ? 10881L : 0L, Integer.valueOf(1), null, null, null), (Object)"index", (Object)new ColumnAnalysis(ValueType.DOUBLE.toString(), false, 9672L, null, null, null, null)), mmap2 ? 167493L : 168188L, 1209L, null, null, null, null);
    }

    @Test
    public void testSegmentMetadataQuery() {
        List results = Sequences.toList((Sequence)this.runner1.run(QueryPlus.wrap((Query)this.testQuery), (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        Assert.assertEquals(Arrays.asList(this.expectedSegmentAnalysis1), (Object)results);
    }

    @Test
    public void testSegmentMetadataQueryWithRollupMerge() {
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : "testSegment", null, (Map)ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ValueType.STRING.toString(), false, 0L, Integer.valueOf(0), null, null, null), (Object)"placementish", (Object)new ColumnAnalysis(ValueType.STRING.toString(), true, 0L, Integer.valueOf(0), null, null, null)), 0L, this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), null, null, null, this.rollup1 != this.rollup2 ? null : Boolean.valueOf(this.rollup1));
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("placement", "placementish"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.ROLLUP}).merge(true).build();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testSegmentMetadataQueryWithHasMultipleValuesMerge() {
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : "testSegment", null, (Map)ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ValueType.STRING.toString(), false, 0L, Integer.valueOf(1), null, null, null), (Object)"placementish", (Object)new ColumnAnalysis(ValueType.STRING.toString(), true, 0L, Integer.valueOf(9), null, null, null)), 0L, this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), null, null, null, null);
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("placement", "placementish"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.CARDINALITY}).merge(true).build();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testSegmentMetadataQueryWithComplexColumnMerge() {
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : "testSegment", null, (Map)ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ValueType.STRING.toString(), false, 0L, Integer.valueOf(1), null, null, null), (Object)"quality_uniques", (Object)new ColumnAnalysis("hyperUnique", false, 0L, null, null, null, null)), 0L, this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), null, null, null, null);
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("placement", "quality_uniques"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.CARDINALITY}).merge(true).build();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testSegmentMetadataQueryWithDefaultAnalysisMerge() {
        ColumnAnalysis analysis = new ColumnAnalysis(ValueType.STRING.toString(), false, (long)((this.mmap1 ? 10881 : 10764) + (this.mmap2 ? 10881 : 10764)), Integer.valueOf(1), (Comparable)((Object)"preferred"), (Comparable)((Object)"preferred"), null);
        this.testSegmentMetadataQueryWithDefaultAnalysisMerge("placement", analysis);
    }

    @Test
    public void testSegmentMetadataQueryWithDefaultAnalysisMerge2() {
        ColumnAnalysis analysis = new ColumnAnalysis(ValueType.STRING.toString(), false, (long)((this.mmap1 ? 6882 : 6808) + (this.mmap2 ? 6882 : 6808)), Integer.valueOf(3), (Comparable)((Object)"spot"), (Comparable)((Object)"upfront"), null);
        this.testSegmentMetadataQueryWithDefaultAnalysisMerge("market", analysis);
    }

    @Test
    public void testSegmentMetadataQueryWithDefaultAnalysisMerge3() {
        ColumnAnalysis analysis = new ColumnAnalysis(ValueType.STRING.toString(), false, (long)((this.mmap1 ? 9765 : 9660) + (this.mmap2 ? 9765 : 9660)), Integer.valueOf(9), (Comparable)((Object)"automotive"), (Comparable)((Object)"travel"), null);
        this.testSegmentMetadataQueryWithDefaultAnalysisMerge("quality", analysis);
    }

    private void testSegmentMetadataQueryWithDefaultAnalysisMerge(String column, ColumnAnalysis analysis) {
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : "testSegment", (List)ImmutableList.of(this.expectedSegmentAnalysis1.getIntervals().get(0)), (Map)ImmutableMap.of((Object)"__time", (Object)new ColumnAnalysis(ValueType.LONG.toString(), false, 24180L, null, null, null, null), (Object)"index", (Object)new ColumnAnalysis(ValueType.DOUBLE.toString(), false, 19344L, null, null, null, null), (Object)column, (Object)analysis), this.expectedSegmentAnalysis1.getSize() + this.expectedSegmentAnalysis2.getSize(), this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), null, null, null, null);
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        Query query = this.testQuery.withColumns((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("__time", "index", column)));
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testSegmentMetadataQueryWithNoAnalysisTypesMerge() {
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : "testSegment", null, (Map)ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ValueType.STRING.toString(), false, 0L, Integer.valueOf(0), null, null, null)), 0L, this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), null, null, null, null);
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("placement"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[0]).merge(true).build();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testSegmentMetadataQueryWithAggregatorsMerge() {
        HashMap expectedAggregators = Maps.newHashMap();
        for (AggregatorFactory agg : TestIndex.METRIC_AGGS) {
            expectedAggregators.put(agg.getName(), agg.getCombiningFactory());
        }
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : "testSegment", null, (Map)ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ValueType.STRING.toString(), false, 0L, Integer.valueOf(0), null, null, null)), 0L, this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), (Map)expectedAggregators, null, null, null);
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("placement"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.AGGREGATORS}).merge(true).build();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testSegmentMetadataQueryWithTimestampSpecMerge() {
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : "testSegment", null, (Map)ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ValueType.STRING.toString(), false, 0L, Integer.valueOf(0), null, null, null)), 0L, this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), null, new TimestampSpec("ds", "auto", null), null, null);
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("placement"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.TIMESTAMPSPEC}).merge(true).build();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testSegmentMetadataQueryWithQueryGranularityMerge() {
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : "testSegment", null, (Map)ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ValueType.STRING.toString(), false, 0L, Integer.valueOf(0), null, null, null)), 0L, this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), null, null, Granularities.NONE, null);
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("placement"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.QUERYGRANULARITY}).merge(true).build();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testBySegmentResults() {
        Result bySegmentResult = new Result(((Interval)this.expectedSegmentAnalysis1.getIntervals().get(0)).getStart(), (Object)new BySegmentResultValueClass(Arrays.asList(this.expectedSegmentAnalysis1), this.expectedSegmentAnalysis1.getId(), (Interval)this.testQuery.getIntervals().get(0)));
        QueryToolChest toolChest = FACTORY.getToolchest();
        QueryRunner singleSegmentQueryRunner = toolChest.preMergeQueryDecoration(this.runner1);
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{singleSegmentQueryRunner, singleSegmentQueryRunner}))), toolChest);
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)bySegmentResult, (Object)bySegmentResult), myRunner.run(QueryPlus.wrap((Query)this.testQuery.withOverriddenContext((Map)ImmutableMap.of((Object)"bySegment", (Object)true))), (Map)Maps.newHashMap()), "failed SegmentMetadata bySegment query");
        exec.shutdownNow();
    }

    @Test
    public void testSerde() throws Exception {
        String queryStr = "{\n  \"queryType\":\"segmentMetadata\",\n  \"dataSource\":\"test_ds\",\n  \"intervals\":[\"2013-12-04T00:00:00.000Z/2013-12-05T00:00:00.000Z\"],\n  \"analysisTypes\":[\"cardinality\",\"size\"]\n}";
        EnumSet<SegmentMetadataQuery.AnalysisType> expectedAnalysisTypes = EnumSet.of(SegmentMetadataQuery.AnalysisType.CARDINALITY, SegmentMetadataQuery.AnalysisType.SIZE);
        Query query = (Query)MAPPER.readValue(queryStr, Query.class);
        Assert.assertTrue((boolean)(query instanceof SegmentMetadataQuery));
        Assert.assertEquals((Object)"test_ds", (Object)Iterables.getOnlyElement((Iterable)query.getDataSource().getNames()));
        Assert.assertEquals((Object)Intervals.of((String)"2013-12-04T00:00:00.000Z/2013-12-05T00:00:00.000Z"), query.getIntervals().get(0));
        Assert.assertEquals(expectedAnalysisTypes, (Object)((SegmentMetadataQuery)query).getAnalysisTypes());
        Assert.assertEquals((Object)query, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)query), Query.class));
    }

    @Test
    public void testSerdeWithDefaultInterval() throws Exception {
        String queryStr = "{\n  \"queryType\":\"segmentMetadata\",\n  \"dataSource\":\"test_ds\"\n}";
        Query query = (Query)MAPPER.readValue(queryStr, Query.class);
        Assert.assertTrue((boolean)(query instanceof SegmentMetadataQuery));
        Assert.assertEquals((Object)"test_ds", (Object)Iterables.getOnlyElement((Iterable)query.getDataSource().getNames()));
        Assert.assertEquals((Object)Intervals.ETERNITY, query.getIntervals().get(0));
        Assert.assertTrue((boolean)((SegmentMetadataQuery)query).isUsingDefaultInterval());
        Assert.assertEquals((Object)query, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)query), Query.class));
    }

    @Test
    public void testDefaultIntervalAndFiltering() throws Exception {
        SegmentMetadataQuery testQuery = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("placement"))).merge(true).build();
        Assert.assertTrue((boolean)testQuery.isUsingDefaultInterval());
        Assert.assertEquals((Object)Intervals.ETERNITY, testQuery.getIntervals().get(0));
        Assert.assertEquals((long)testQuery.getIntervals().size(), (long)1L);
        List<LogicalSegment> testSegments = Arrays.asList(new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2012-01-01/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2012-01-01T01/PT1H");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-01-05/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-05-20/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2014-01-05/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2014-02-05/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2015-01-19T01/PT1H");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2015-01-20T02/PT1H");
            }
        });
        List filteredSegments = new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()).filterSegments(testQuery, testSegments);
        List<LogicalSegment> expectedSegments = Arrays.asList(new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2015-01-19T01/PT1H");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2015-01-20T02/PT1H");
            }
        });
        Assert.assertEquals((long)filteredSegments.size(), (long)2L);
        for (int i = 0; i < filteredSegments.size(); ++i) {
            Assert.assertEquals((Object)expectedSegments.get(i).getInterval(), (Object)((LogicalSegment)filteredSegments.get(i)).getInterval());
        }
        SegmentMetadataQueryConfig twoYearPeriodCfg = new SegmentMetadataQueryConfig("P2Y");
        List filteredSegments2 = new SegmentMetadataQueryQueryToolChest(twoYearPeriodCfg).filterSegments(testQuery, testSegments);
        List<LogicalSegment> expectedSegments2 = Arrays.asList(new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-05-20/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2014-01-05/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2014-02-05/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2015-01-19T01/PT1H");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2015-01-20T02/PT1H");
            }
        });
        Assert.assertEquals((long)filteredSegments2.size(), (long)5L);
        for (int i = 0; i < filteredSegments2.size(); ++i) {
            Assert.assertEquals((Object)expectedSegments2.get(i).getInterval(), (Object)((LogicalSegment)filteredSegments2.get(i)).getInterval());
        }
    }

    @Test
    public void testCacheKeyWithListColumnIncluderator() {
        SegmentMetadataQuery oneColumnQuery = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("foo"))).build();
        SegmentMetadataQuery twoColumnQuery = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("fo", "o"))).build();
        byte[] oneColumnQueryCacheKey = new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()).getCacheStrategy(oneColumnQuery).computeCacheKey((Query)oneColumnQuery);
        byte[] twoColumnQueryCacheKey = new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()).getCacheStrategy(twoColumnQuery).computeCacheKey((Query)twoColumnQuery);
        Assert.assertFalse((boolean)Arrays.equals(oneColumnQueryCacheKey, twoColumnQueryCacheKey));
    }

    @Test
    public void testAnanlysisTypesBeingSet() {
        SegmentMetadataQuery query1 = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("foo"))).build();
        SegmentMetadataQuery query2 = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("foo"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.MINMAX}).build();
        SegmentMetadataQueryConfig emptyCfg = new SegmentMetadataQueryConfig();
        SegmentMetadataQueryConfig analysisCfg = new SegmentMetadataQueryConfig();
        analysisCfg.setDefaultAnalysisTypes(EnumSet.of(SegmentMetadataQuery.AnalysisType.CARDINALITY));
        EnumSet analysis1 = query1.withFinalizedAnalysisTypes(emptyCfg).getAnalysisTypes();
        EnumSet analysis2 = query2.withFinalizedAnalysisTypes(emptyCfg).getAnalysisTypes();
        EnumSet analysisWCfg1 = query1.withFinalizedAnalysisTypes(analysisCfg).getAnalysisTypes();
        EnumSet analysisWCfg2 = query2.withFinalizedAnalysisTypes(analysisCfg).getAnalysisTypes();
        EnumSet expectedAnalysis1 = new SegmentMetadataQueryConfig().getDefaultAnalysisTypes();
        EnumSet<SegmentMetadataQuery.AnalysisType> expectedAnalysis2 = EnumSet.of(SegmentMetadataQuery.AnalysisType.MINMAX);
        EnumSet<SegmentMetadataQuery.AnalysisType> expectedAnalysisWCfg1 = EnumSet.of(SegmentMetadataQuery.AnalysisType.CARDINALITY);
        EnumSet<SegmentMetadataQuery.AnalysisType> expectedAnalysisWCfg2 = EnumSet.of(SegmentMetadataQuery.AnalysisType.MINMAX);
        Assert.assertEquals((Object)analysis1, (Object)expectedAnalysis1);
        Assert.assertEquals((Object)analysis2, expectedAnalysis2);
        Assert.assertEquals((Object)analysisWCfg1, expectedAnalysisWCfg1);
        Assert.assertEquals((Object)analysisWCfg2, expectedAnalysisWCfg2);
    }
}

