/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.jackson.JacksonUtils;
import org.apache.hive.druid.io.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactory;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.hive.druid.io.druid.query.lookup.LookupIntrospectHandler;
import org.apache.hive.druid.io.druid.query.lookup.LookupReferencesManager;
import org.apache.hive.druid.io.druid.query.lookup.RegisteredLookupExtractionFn;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RegisteredLookupExtractionFnTest {
    private static Map<String, String> MAP = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"bat", (Object)"baz");
    private static final LookupExtractor LOOKUP_EXTRACTOR = new MapLookupExtractor(MAP, true);
    private static final String LOOKUP_NAME = "some lookup";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSimpleDelegation() {
        LookupReferencesManager manager = (LookupReferencesManager)EasyMock.createStrictMock(LookupReferencesManager.class);
        this.managerReturnsMap(manager);
        EasyMock.replay((Object[])new Object[]{manager});
        RegisteredLookupExtractionFn fn = new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, true, null, true, Boolean.valueOf(false));
        EasyMock.verify((Object[])new Object[]{manager});
        for (String orig : Arrays.asList("", "foo", "bat")) {
            Assert.assertEquals((Object)LOOKUP_EXTRACTOR.apply(orig), (Object)fn.apply(orig));
        }
        Assert.assertEquals((Object)"not in the map", (Object)fn.apply("not in the map"));
    }

    @Test
    public void testMissingDelegation() {
        LookupReferencesManager manager = (LookupReferencesManager)EasyMock.createStrictMock(LookupReferencesManager.class);
        EasyMock.expect((Object)manager.get((String)EasyMock.eq((Object)LOOKUP_NAME))).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{manager});
        this.expectedException.expectMessage("Lookup [some lookup] not found");
        try {
            new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, true, null, true, Boolean.valueOf(false)).apply("foo");
        }
        catch (Throwable throwable) {
            EasyMock.verify((Object[])new Object[]{manager});
            throw throwable;
        }
        EasyMock.verify((Object[])new Object[]{manager});
    }

    @Test
    public void testNullLookup() {
        this.expectedException.expectMessage("`lookup` required");
        new RegisteredLookupExtractionFn(null, null, true, null, true, Boolean.valueOf(false));
    }

    @Test
    public void testSerDe() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        LookupReferencesManager manager = (LookupReferencesManager)EasyMock.createStrictMock(LookupReferencesManager.class);
        this.managerReturnsMap(manager);
        EasyMock.replay((Object[])new Object[]{manager});
        RegisteredLookupExtractionFn fn = new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, true, null, true, Boolean.valueOf(false));
        EasyMock.verify((Object[])new Object[]{manager});
        Map result = (Map)mapper.readValue(mapper.writeValueAsString((Object)fn), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((Object)mapper.convertValue((Object)fn, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT), (Object)result);
        Assert.assertEquals((Object)LOOKUP_NAME, result.get("lookup"));
        Assert.assertEquals((Object)true, result.get("retainMissingValue"));
        Assert.assertEquals((Object)true, result.get("injective"));
        Assert.assertNull(result.get("replaceMissingValueWith"));
        Assert.assertEquals((Object)false, result.get("optimize"));
    }

    @Test
    public void testEquals() {
        LookupReferencesManager manager = (LookupReferencesManager)EasyMock.createStrictMock(LookupReferencesManager.class);
        this.managerReturnsMap(manager);
        EasyMock.replay((Object[])new Object[]{manager});
        RegisteredLookupExtractionFn fn = new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, false, "something", true, Boolean.valueOf(false));
        Assert.assertEquals((Object)fn, (Object)new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, false, "something", true, Boolean.valueOf(false)));
        Assert.assertNotEquals((Object)fn, (Object)new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, true, null, true, Boolean.valueOf(false)));
        Assert.assertNotEquals((Object)fn, (Object)new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, false, "something else", true, Boolean.valueOf(false)));
        Assert.assertNotEquals((Object)fn, (Object)new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, false, "something", false, Boolean.valueOf(false)));
        Assert.assertNotEquals((Object)fn, (Object)new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, false, "something", true, Boolean.valueOf(true)));
        Assert.assertNotEquals((Object)fn, (Object)new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, false, null, true, Boolean.valueOf(false)));
        EasyMock.verify((Object[])new Object[]{manager});
    }

    private void managerReturnsMap(LookupReferencesManager manager) {
        EasyMock.expect((Object)manager.get((String)EasyMock.eq((Object)LOOKUP_NAME))).andReturn((Object)new LookupExtractorFactoryContainer("v0", new LookupExtractorFactory(){

            public boolean start() {
                return false;
            }

            public boolean replaces(@Nullable LookupExtractorFactory other) {
                return false;
            }

            public boolean close() {
                return false;
            }

            @Nullable
            public LookupIntrospectHandler getIntrospectHandler() {
                return null;
            }

            public LookupExtractor get() {
                return LOOKUP_EXTRACTOR;
            }
        })).anyTimes();
    }
}

